/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.StandardInsertStatement;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class InsertStatementValidator
extends UtilityValidator {
    @Check
    public void validateTermInInsertStatement(Term term) {
        InsertStatement insertStatement = ModelUtil.getAncestorOfType(term, InsertStatement.class);
        if (insertStatement != null) {
            StandardInsertStatement standardPart = insertStatement.getStandardInsertPart();
            if (standardPart == null) {
                standardPart = insertStatement.getSyntheticStandardInsertPart();
            }
            if (standardPart != null && standardPart.getColumns() != null && standardPart.getTerms() != null) {
                Schema schema = this.getSchemaToCheck(insertStatement);
                Keyspace ks = schema.getKeyspace(insertStatement.getKeyspace());
                EList<Term> terms = standardPart.getTerms();
                EList<ColumnEntity> columns = standardPart.getColumns();
                int index = this.findTermIndex((List<Term>)terms, term);
                if (index < columns.size()) {
                    Table table = this.getTableMeta(insertStatement.getTable());
                    Column column = this.getColumnMetadata((ColumnEntity)columns.get(index), table);
                    this.validateTermAgainstColumnType(term, column.getType(), column, schema, ks, (EStructuralFeature)CqlPackage.Literals.TERM__TERM);
                }
            }
        }
    }
}

