/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.AlterKeyspaceStatement;
import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.Property;
import com.datastax.devcenter.cql.cql.PropertyValue;
import com.datastax.devcenter.cql.cql.StatementsWithProperties;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.options.CompactionStrategy;
import com.datastax.devcenter.schema.options.ReplicationStrategy;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class PropertyMapValidator
extends UtilityValidator {
    private static final String FQN_LEVELED_COMPACTION_STRATEGY = "'org.apache.cassandra.db.compaction.LeveledCompactionStrategy'";
    private static final String LEVELED_COMPACTION_STRATEGY = "'LeveledCompactionStrategy'";
    private static final String FQN_SIZE_TIERED_COMPACTION_STRATEGY = "'org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy'";
    private static final String SIZE_TIERED_COMPACTION_STRATEGY = "'SizeTieredCompactionStrategy'";
    public static final String FQN_DATE_TIERED_COMPACTION_STRATEGY = "'" + CompactionStrategy.DATE_TIERED.getFullyQualifiedName() + "'";
    public static final String DATE_TIERED_COMPACTION_STRATEGY = "'" + CompactionStrategy.DATE_TIERED.getSimpleName() + "'";

    @Check
    public void checkValidProperty(Property property) {
        CqlStatement stmt = ModelUtil.getCqlStatement(property);
        if (stmt instanceof CreateTableStatement || stmt instanceof AlterTableStatement) {
            this.checkValidTableProperty(property);
        } else if (stmt instanceof CreateKeyspaceStatement || stmt instanceof AlterKeyspaceStatement) {
            this.checkValidKeyspaceProperty(property);
        } else if (stmt instanceof CreateIndexStatement) {
            this.checkValidIndexProperty(property);
        }
    }

    @Check
    public void checkValidPropertyDuplication(StatementsWithProperties stmt) {
        HashSet<String> visited_name = new HashSet<String>();
        int idx = 0;
        for (TableProperty property : stmt.getProperties()) {
            if (property.isClustering() || property.isCompactStorage()) continue;
            String propertyName = ((Property)property).getName();
            if (propertyName != null) {
                String lcPropertyName = propertyName.toLowerCase();
                if (visited_name.contains(lcPropertyName)) {
                    this.error("Property " + propertyName + " is already declared", (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_PROPERTIES__PROPERTIES, idx, "DUPLICATE_PROPERTY_NAME", new String[]{Integer.toString(idx)});
                }
                visited_name.add(lcPropertyName);
            }
            ++idx;
        }
    }

    @Check
    public void checkMandatoryKeyspaceProperty(CreateKeyspaceStatement stmt) {
        if (stmt.getProperties() == null) {
            return;
        }
        boolean foundReplication = false;
        for (TableProperty property : stmt.getProperties()) {
            if (!((Property)property).getName().toLowerCase().equals("replication")) continue;
            foundReplication = true;
        }
        if (!foundReplication) {
            this.error("Property replication is mandatory", (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_PROPERTIES__PROPERTIES, "MISSING_MANDATORY PROPERTY", new String[]{"replication"});
        }
    }

    protected void checkValidKeyspaceProperty(Property property) {
        String propertyName = property.getName().toLowerCase();
        if (propertyName.equals("replication")) {
            if (property.getPropertyMap() == null || property.getPropertyValue() != null) {
                this.error("Valid property value type is map", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_VALUE", new String[0]);
            }
            if (property.getPropertyMap() != null) {
                boolean foundClass = false;
                for (MapEntry option : property.getPropertyMap().getEntries()) {
                    if (!ModelUtil.termToString(option.getKey()).equals("'class'")) continue;
                    foundClass = true;
                    break;
                }
                if (!foundClass) {
                    this.error("Option 'class' is mandatory", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_MAP, "MISSING_MANDATORY_CLASS_OPTION", new String[0]);
                }
            }
        } else if (propertyName.equals("durable_writes")) {
            this.checkValidPropertyValueType(property, (CqlDataType)NativeCqlDataType.BOOLEAN);
        } else {
            this.error("Property name is not valid", (EStructuralFeature)CqlPackage.Literals.PROPERTY__NAME, "INVALID_PROPERTY_NAME", new String[]{propertyName});
        }
    }

    protected void checkValidIndexProperty(Property property) {
        String propertyName = property.getName().toLowerCase();
        if (propertyName.equals("options")) {
            if (property.getPropertyMap() == null || property.getPropertyValue() != null) {
                this.error("Valid property value type is map", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_VALUE", new String[0]);
            }
        } else {
            this.error("Property name is not valid", (EStructuralFeature)CqlPackage.Literals.PROPERTY__NAME, "INVALID_PROPERTY_NAME", new String[]{propertyName});
        }
    }

    protected void checkValidPropertyValueType(Property property, CqlDataType dataType) {
        PropertyValue propertyValue = property.getPropertyValue();
        if (property.getPropertyMap() != null) {
            this.error("Valid property value type is " + dataType.toString(), (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_VALUE", new String[0]);
        }
        this.checkValidPropertyValueType(propertyValue.getValue(), dataType);
    }

    protected boolean checkValidPropertyValueType(String value, CqlDataType dataType) {
        if (value != null && !this.isValidDataTypeValue(dataType, value)) {
            this.error("Valid property value type is " + dataType.toString(), (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_VALUE", new String[0]);
            return false;
        }
        return true;
    }

    protected void checkValidTableProperty(Property property) {
        String propertyName = property.getName().toLowerCase();
        if (propertyName.equals("comment")) {
            this.checkValidPropertyValueType(property, (CqlDataType)NativeCqlDataType.TEXT);
        } else if (propertyName.equals("read_repair_chance") || propertyName.equals("dclocal_read_repair_chance") || propertyName.equals("bloom_filter_fp_chance")) {
            this.checkValidPropertyValueType(property, (CqlDataType)NativeCqlDataType.FLOAT);
        } else if (propertyName.equals("gc_grace_seconds") || propertyName.equals("default_time_to_live") || propertyName.equals("memtable_flush_period_in_ms") || propertyName.equals("default_time_to_live")) {
            this.checkValidPropertyValueType(property, (CqlDataType)NativeCqlDataType.INT);
        } else if (propertyName.equals("index_interval") || propertyName.equals("min_index_interval") || propertyName.equals("max_index_interval")) {
            String propertyValue = property.getPropertyValue().getValue();
            if (this.checkValidPropertyValueType(propertyValue, (CqlDataType)NativeCqlDataType.INT) && Integer.valueOf(propertyValue) <= 0) {
                this.error(String.format("%s must be greater than 0", propertyName), (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_VALUE", new String[0]);
            }
        } else if (propertyName.equals("compaction") || propertyName.equals("compression")) {
            if (property.getPropertyValue() != null) {
                this.error("Valid property value type is map", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_VALUE", new String[0]);
            }
            if (propertyName.equals("compression")) {
                this.checkMandatoryCompressionMapProperty(property.getPropertyMap());
            }
        } else if (propertyName.equals("replicate_on_write") || propertyName.equals("populate_io_cache_on_flush")) {
            this.checkValidPropertyValueType(property, (CqlDataType)NativeCqlDataType.BOOLEAN);
        } else if (propertyName.equals("speculative_retry")) {
            String propertyValue = ModelUtil.stripName(property.getPropertyValue().getValue().toLowerCase());
            if (propertyValue.equals("none") || propertyValue.equals("always")) {
                return;
            }
            if (propertyValue.endsWith("ms")) {
                this.checkValidPropertyValueType(propertyValue.substring(0, propertyValue.lastIndexOf("ms")), (CqlDataType)NativeCqlDataType.FLOAT);
            } else if (propertyValue.endsWith("percentile")) {
                this.checkValidPropertyValueType(propertyValue.substring(0, propertyValue.lastIndexOf("percentile")), (CqlDataType)NativeCqlDataType.FLOAT);
            } else {
                this.error("Valid property values are 'ALWAYS', 'Xpercentile', 'Yms', or 'NONE'", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_VALUE", new String[0]);
            }
        } else if (propertyName.equals("caching")) {
            PropertyValue propertyValue = property.getPropertyValue();
            if (propertyValue != null) {
                String optionValue = propertyValue.getValue();
                if (optionValue.startsWith("'{") && optionValue.endsWith("}'")) {
                    String mapString = optionValue.substring(1, optionValue.length() - 1);
                    Map map = new HashMap();
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        map = (Map)mapper.readValue(mapString, (TypeReference)new TypeReference<HashMap<String, String>>(){});
                    }
                    catch (Exception exception) {
                        this.error("Invalid JSON map representation", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_CACHING", new String[0]);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        String optionName = (String)entry.getKey();
                        String lcValue = ((String)entry.getValue()).toLowerCase();
                        if (optionName.equals("keys")) {
                            if (lcValue.equals("all") || lcValue.equals("none")) continue;
                            this.error("keys can only have values ALL or NONE", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_CACHING", new String[0]);
                            continue;
                        }
                        if (optionName.equals("rows_per_partition")) {
                            if (lcValue.equals("all") || lcValue.equals("none") || NativeCqlDataType.INT.validate(lcValue)) continue;
                            this.error("'rows_per_partition' can only have values ALL, NONE or be numeric.", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_CACHING", new String[0]);
                            continue;
                        }
                        this.error(String.format("Option '%s' not supported", optionName), (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_CACHING", new String[0]);
                    }
                } else {
                    optionValue = propertyValue.getValue().toLowerCase();
                    if (!(optionValue.equals("'all'") || optionValue.equals("'keys_only'") || optionValue.equals("'rows_only'") || optionValue.equals("'none'"))) {
                        this.error("Only 'all', 'keys_only', 'rows_only' and 'none' are valid", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_CACHING", new String[0]);
                    }
                }
            }
        } else {
            this.error("Property name is not valid", (EStructuralFeature)CqlPackage.Literals.PROPERTY__NAME, "INVALID_PROPERTY_NAME", new String[]{propertyName});
        }
    }

    private void checkMandatoryCompressionMapProperty(MapLiteral map) {
        if (map == null) {
            return;
        }
        boolean foundCompression = false;
        for (MapEntry entry : map.getEntries()) {
            if (!ModelUtil.termToString(entry.getKey()).equalsIgnoreCase("'sstable_compression'")) continue;
            foundCompression = true;
            break;
        }
        if (!foundCompression) {
            this.error("Missing sub-option 'sstable_compression' for the 'compression' option.", (EStructuralFeature)CqlPackage.Literals.PROPERTY__NAME, "MISSING_SUBOPTION_SSTABLE_COMPRESSION", new String[]{"replication"});
        }
    }

    public void assertOptionPairExist(Property property, String requiredOptionName, String ... requiredOptionValue) {
        String[] stringArray = requiredOptionValue;
        int n = requiredOptionValue.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (ModelUtil.isOptionPairExist(property, requiredOptionName, element)) {
                return;
            }
            ++n2;
        }
        this.error(String.format("This option requires %s: %s", requiredOptionName, requiredOptionValue[0]), (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__KEY, "INVALID_OPTION_NAME", new String[0]);
    }

    protected boolean assertOptionValueType(CqlDataType dataType, String optionValue) {
        if (!this.isValidDataTypeValue(dataType, optionValue)) {
            this.error("Valid option value type for this option is " + dataType.toString(), (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "INVALID_OPTION_VALUE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean isValidDataTypeValue(CqlDataType dataType, String value) {
        if (dataType.isText()) {
            return dataType.validate(value);
        }
        return dataType.validate(ModelUtil.stripName(value));
    }

    protected void checkValidKeyspaceMapProperty(Property property, String optionName, String optionValue) {
        String propertyName = property.getName().toLowerCase();
        if (propertyName.equals("replication")) {
            if (optionName.equals("'class'")) {
                if (ReplicationStrategy.SIMPLE.matches(optionValue)) {
                    if (!ModelUtil.isOptionNameExist(property, "'replication_factor'")) {
                        this.error("SimpleStrategy requires a replication_factor strategy option", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__KEY, "INVALID_REPLICATION_CLASS", new String[0]);
                    }
                    this.warnIfReplicationStrategyCanBeSimplified(optionValue, ReplicationStrategy.SIMPLE);
                } else if (ReplicationStrategy.OLD.matches(optionValue)) {
                    this.warning("This is legacy strategy, use 'NetworkTopologyStrategy' instead", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "LEGACY_OLD_NETWORK_TOPOLOGY_STRATEGY", new String[0]);
                    this.warnIfReplicationStrategyCanBeSimplified(optionValue, ReplicationStrategy.OLD);
                } else if (!ReplicationStrategy.NETWORK_TOPOLOGY.matches(optionValue)) {
                    this.error("Valid values are: 'SimpleStrategy' or 'NetworkTopologyStrategy'", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "INVALID_REPLICATION_CLASS", new String[0]);
                } else {
                    this.warnIfReplicationStrategyCanBeSimplified(optionValue, ReplicationStrategy.NETWORK_TOPOLOGY);
                }
            } else if (optionName.equals("'replication_factor'")) {
                this.assertOptionPairExist(property, "'class'", ModelUtil.quote(ReplicationStrategy.SIMPLE.getFullyQualifiedName()), ModelUtil.quote(ReplicationStrategy.SIMPLE.getSimpleName()));
                this.assertOptionValueType(NativeCqlDataType.INT, optionValue);
            } else {
                this.assertOptionPairExist(property, "'class'", ModelUtil.quote(ReplicationStrategy.NETWORK_TOPOLOGY.getFullyQualifiedName()), ModelUtil.quote(ReplicationStrategy.NETWORK_TOPOLOGY.getSimpleName()));
                this.assertOptionValueType(NativeCqlDataType.INT, optionValue);
            }
        }
    }

    private void warnIfReplicationStrategyCanBeSimplified(String optionValue, ReplicationStrategy replicationStrategy) {
        if (replicationStrategy.matchesFQDN(optionValue)) {
            this.warning("Replication strategy can be simplified by removing the package prefix", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "SIMPLIFY_REPLICATION_CLASS", new String[0]);
        }
    }

    protected void raiseOptionNameNotSupported() {
        this.error("Option not supported", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__KEY, "INVALID_OPTION_NAME", new String[0]);
    }

    protected void checkValidTableMapProperty(Property property, String optionName, String optionValue) {
        String propertyName = property.getName().toLowerCase();
        if (propertyName.equals("caching")) {
            String lcValue = optionValue.toLowerCase();
            if (optionName.equals("'keys'")) {
                if (!lcValue.equals("'all'") && !lcValue.equals("'none'")) {
                    this.error("'keys' can only have values 'ALL' or 'NONE'", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "INVALID_PROPERTY_CACHING", new String[0]);
                }
            } else if (optionName.equals("'rows_per_partition'")) {
                if (!(lcValue.equals("'all'") || lcValue.equals("'none'") || NativeCqlDataType.INT.validate(ModelUtil.stripName(lcValue)))) {
                    this.error("'rows_per_partition' can only have values 'ALL', 'NONE' or be numeric.", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "INVALID_PROPERTY_CACHING", new String[0]);
                }
            } else {
                this.raiseOptionNameNotSupported();
            }
        } else if (propertyName.equals("compaction")) {
            if (optionName.equals("'tombstone_threshold'")) {
                this.assertOptionValueType(NativeCqlDataType.FLOAT, optionValue);
            } else if (optionName.equals("'tombstone_compaction_interval'")) {
                this.assertOptionValueType(NativeCqlDataType.INT, optionValue);
            } else if (optionName.equals("'min_sstable_size'")) {
                this.assertOptionPairExist(property, "'class'", SIZE_TIERED_COMPACTION_STRATEGY, FQN_SIZE_TIERED_COMPACTION_STRATEGY);
                this.assertOptionValueType(NativeCqlDataType.INT, optionValue);
            } else if (optionName.equals("'min_threshold'") || optionName.equals("'max_threshold'")) {
                this.assertOptionPairExist(property, "'class'", SIZE_TIERED_COMPACTION_STRATEGY, FQN_SIZE_TIERED_COMPACTION_STRATEGY, DATE_TIERED_COMPACTION_STRATEGY, FQN_DATE_TIERED_COMPACTION_STRATEGY);
                this.assertOptionValueType(NativeCqlDataType.INT, optionValue);
            } else if (optionName.equals("'bucket_low'") || optionName.equals("'bucket_high'") || optionName.equals("'cold_reads_to_omit'")) {
                this.assertOptionPairExist(property, "'class'", SIZE_TIERED_COMPACTION_STRATEGY, FQN_SIZE_TIERED_COMPACTION_STRATEGY);
                this.assertOptionValueType(NativeCqlDataType.FLOAT, optionValue);
            } else if (optionName.equals("'sstable_size_in_mb'")) {
                this.assertOptionPairExist(property, "'class'", LEVELED_COMPACTION_STRATEGY, FQN_LEVELED_COMPACTION_STRATEGY);
                this.assertOptionValueType(NativeCqlDataType.INT, optionValue);
            } else if (optionName.equals("'enabled'") || optionName.equals("'unchecked_tombstone_compaction'")) {
                this.assertOptionValueType(NativeCqlDataType.BOOLEAN, optionValue);
            } else if (optionName.equals("'class'")) {
                if (!(optionValue.equals(SIZE_TIERED_COMPACTION_STRATEGY) || optionValue.equals(FQN_SIZE_TIERED_COMPACTION_STRATEGY) || optionValue.equals(LEVELED_COMPACTION_STRATEGY) || optionValue.equals(FQN_LEVELED_COMPACTION_STRATEGY) || optionValue.equals(DATE_TIERED_COMPACTION_STRATEGY) || optionValue.equals(FQN_DATE_TIERED_COMPACTION_STRATEGY))) {
                    this.error(String.format("Default supported class values are %s and %s", SIZE_TIERED_COMPACTION_STRATEGY, LEVELED_COMPACTION_STRATEGY), (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "INVALID_COMPACTION_CLASS", new String[0]);
                }
            } else if (optionName.equals("'base_time_seconds'")) {
                this.assertOptionPairExist(property, "'class'", DATE_TIERED_COMPACTION_STRATEGY, FQN_DATE_TIERED_COMPACTION_STRATEGY);
                if (this.assertOptionValueType(NativeCqlDataType.INT, optionValue) && Integer.valueOf(optionValue) <= 0) {
                    this.error(String.format("%s must be greater than 0", optionName), (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "INVALID_OPTION_VALUE", new String[0]);
                }
            } else if (optionName.equals("'timestamp_resolution'")) {
                this.assertOptionPairExist(property, "'class'", DATE_TIERED_COMPACTION_STRATEGY, FQN_DATE_TIERED_COMPACTION_STRATEGY);
                this.assertOptionValueType(NativeCqlDataType.TEXT, optionValue);
                String resolution = optionValue.toLowerCase();
                if (!resolution.equals("'microseconds'") && !resolution.equals("'milliseconds'")) {
                    this.error(String.format("%s can only have values MICROSECONDS and MILLISECONDS", optionName), (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "INVALID_TIMESTAMP_RESOLUTION", new String[0]);
                }
            } else if (optionName.equals("'max_sstable_age_days'")) {
                this.assertOptionPairExist(property, "'class'", DATE_TIERED_COMPACTION_STRATEGY, FQN_DATE_TIERED_COMPACTION_STRATEGY);
                if (this.assertOptionValueType(NativeCqlDataType.INT, optionValue) && Integer.valueOf(optionValue) < 0) {
                    this.error(String.format("%s must be non-negative", optionName), (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "INVALID_OPTION_VALUE", new String[0]);
                }
            } else {
                this.raiseOptionNameNotSupported();
            }
        } else if (propertyName.equals("compression")) {
            if (optionName.equals("'crc_check_chance'")) {
                this.assertOptionValueType(NativeCqlDataType.FLOAT, optionValue);
            } else if (optionName.equals("'chunk_length_kb'")) {
                this.assertOptionValueType(NativeCqlDataType.INT, optionValue);
                try {
                    int kb = Integer.parseInt(optionValue);
                    if (Integer.bitCount(kb) > 1) {
                        this.error("Chunk length must be a power of 2", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, "CHUNK_LENGTH_KB_MUST_BE_POWER_OF_2", new String[0]);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (optionName.equals("'sstable_compression'")) {
                this.assertOptionValueType(NativeCqlDataType.TEXT, optionValue);
            } else {
                this.raiseOptionNameNotSupported();
            }
        }
    }

    @Check
    public void checkValidMapProperty(MapEntry mapEntry) {
        CqlStatement stmt = ModelUtil.getCqlStatement(mapEntry);
        Property property = ModelUtil.getAncestorOfType(mapEntry, Property.class);
        String optionName = ModelUtil.termToString(mapEntry.getKey());
        String optionValue = ModelUtil.termToString(mapEntry.getValue());
        if (property == null) {
            return;
        }
        if (stmt instanceof CreateTableStatement || stmt instanceof AlterTableStatement) {
            this.checkValidTableMapProperty(property, optionName, optionValue);
        } else if (stmt instanceof CreateKeyspaceStatement || stmt instanceof AlterKeyspaceStatement) {
            this.checkValidKeyspaceMapProperty(property, optionName, optionValue);
        }
    }

    @Check
    public void checkMaxIntervalGreaterThanMinInterval(Property property) {
        if (!property.getName().equalsIgnoreCase("max_index_interval")) {
            return;
        }
        CqlStatement cqlStatement = ModelUtil.getCqlStatement(property);
        if (!(cqlStatement instanceof CreateTableStatement) && !(cqlStatement instanceof AlterTableStatement)) {
            return;
        }
        StatementsWithProperties stmtWithProperties = (StatementsWithProperties)((Object)cqlStatement);
        Integer maxIndexInterval = this.propertyToInt(property);
        Integer minIndexInterval = null;
        EList<TableProperty> properties = stmtWithProperties.getProperties();
        for (TableProperty tableProperty : properties) {
            Property currentProperty;
            String name;
            if (!(tableProperty instanceof Property) || (name = (currentProperty = (Property)tableProperty).getName()) == null || !name.equalsIgnoreCase("min_index_interval")) continue;
            minIndexInterval = this.propertyToInt(currentProperty);
            break;
        }
        if (maxIndexInterval != null && minIndexInterval != null && minIndexInterval >= maxIndexInterval) {
            this.error("max_index_interval must be greater than min_index_interval", (EStructuralFeature)CqlPackage.Literals.PROPERTY__PROPERTY_VALUE, "INVALID_PROPERTY_VALUE", new String[0]);
        }
    }

    private Integer propertyToInt(Property property) {
        if (property == null || property.getPropertyValue() == null || property.getPropertyValue().getValue() == null) {
            return null;
        }
        String value = property.getPropertyValue().getValue();
        if (this.isValidDataTypeValue(NativeCqlDataType.INT, value)) {
            return Integer.valueOf(value);
        }
        return null;
    }
}

