/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.Relation;
import com.datastax.devcenter.cql.cql.RulesWithKeyspaceRef;
import com.datastax.devcenter.cql.cql.RulesWithTableRef;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TupleLiteral;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.FunctionUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.CollectionCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.datastax.devcenter.schema.types.MapCqlDataType;
import com.datastax.devcenter.schema.types.TupleCqlDataType;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class RelationValidator
extends UtilityValidator {
    @Check
    public void validateTermUsedInRelation(Term term) {
        Relation relation = ModelUtil.getAncestorOfType(term, Relation.class, 1);
        if (relation != null && !relation.isMapEntry()) {
            RulesWithTableRef tableRef = ModelUtil.getAncestorOfType(relation, RulesWithTableRef.class, null);
            RulesWithKeyspaceRef ksRef = (RulesWithKeyspaceRef)((Object)tableRef);
            if (tableRef != null) {
                Schema schema = this.getSchemaToCheck(tableRef);
                Keyspace ks = schema.getKeyspace(ksRef.getKeyspace());
                Table table = this.getTableMeta(tableRef.getTable());
                Column column = this.getColumnMetadata(relation.getColumn(), table);
                if (relation.getColumn() != null) {
                    CqlDataType columnType = this.getColumnTypeToValidate(relation, column);
                    this.validateTermAgainstColumnType(term, columnType, column, schema, ks, (EStructuralFeature)CqlPackage.Literals.TERM__TERM);
                }
            }
        }
    }

    @Check
    public void validateTermUsedInMapEntryRelation(Term term) {
        Relation relation = ModelUtil.getAncestorOfType(term, Relation.class, 1);
        if (relation != null && relation.isMapEntry()) {
            RulesWithTableRef tableRef = ModelUtil.getAncestorOfType(relation, RulesWithTableRef.class, null);
            RulesWithKeyspaceRef ksRef = (RulesWithKeyspaceRef)((Object)tableRef);
            if (tableRef != null) {
                Schema schema = this.getSchemaToCheck(tableRef);
                Keyspace ks = schema.getKeyspace(ksRef.getKeyspace());
                Table table = this.getTableMeta(tableRef.getTable());
                Column column = this.getColumnMetadata(relation.getColumn(), table);
                if (relation.getColumn() != null && column.getType().isMap()) {
                    MapCqlDataType columnType = (MapCqlDataType)this.getColumnTypeToValidate(relation, column);
                    if (term.equals(relation.getKeyTerm())) {
                        this.validateTermAgainstMapKeyType(relation.getKeyTerm(), columnType, column, schema, ks, (EStructuralFeature)CqlPackage.Literals.TERM__TERM);
                    } else if (term.equals(relation.getTerm())) {
                        this.validateTermAgainstMapValueType(relation.getTerm(), columnType, column, schema, ks, (EStructuralFeature)CqlPackage.Literals.TERM__TERM);
                    }
                }
            }
        }
    }

    @Check
    public void validateColumnTypeUsedInMapEntryRelation(Relation relation) {
        RulesWithTableRef tableRef;
        if (relation != null && relation.isMapEntry() && (tableRef = ModelUtil.getAncestorOfType(relation, RulesWithTableRef.class, null)) != null) {
            Table table = this.getTableMeta(tableRef.getTable());
            Column column = this.getColumnMetadata(relation.getColumn(), table);
            if (!column.getType().isMap() || column.getType().isFrozen()) {
                this.error("Query by key-value pair is only applicable for non-frozen map types", (EStructuralFeature)CqlPackage.Literals.RELATION__COLUMNS, "QUERY_BY_KEY_VALUE_PAIR_IS_ONLY_APPLICABLE_FOR_NON_FROZEN_MAP_TYPES", new String[0]);
            }
        }
    }

    @Check
    public void validateTupleLiteralInRelation(Relation relation) {
        if (relation != null && relation.getTermTuple() != null && relation.getColumns() != null) {
            TupleLiteral tuple = relation.getTermTuple();
            RulesWithTableRef statementWithTableRef = ModelUtil.getAncestorOfType(relation, RulesWithTableRef.class, null);
            RulesWithKeyspaceRef keyspaceRef = (RulesWithKeyspaceRef)((Object)statementWithTableRef);
            if (statementWithTableRef != null) {
                Table cfMeta = this.getTableMeta(statementWithTableRef);
                Schema schema = this.getSchemaToCheck(statementWithTableRef);
                Keyspace ks = schema.getKeyspace(keyspaceRef.getKeyspace());
                this.assertMultiColumnBasedTupleCompatibleWithTupleLiteral(relation, cfMeta, tuple, (EStructuralFeature)CqlPackage.Literals.RELATION__TERM_TUPLE, -1, schema, ks);
            }
        }
    }

    @Check
    public void validateTupleLiteralsInRelationInClause(Relation relation) {
        if (relation != null && relation.isIn() && relation.getTermTuples() != null && relation.getColumns() != null) {
            EList<TupleLiteral> tuples = relation.getTermTuples();
            RulesWithTableRef statementWithTableRef = ModelUtil.getAncestorOfType(relation, RulesWithTableRef.class);
            RulesWithKeyspaceRef keyspaceRef = (RulesWithKeyspaceRef)((Object)statementWithTableRef);
            if (statementWithTableRef != null) {
                Table cfMeta = this.getTableMeta(statementWithTableRef);
                Schema schema = this.getSchemaToCheck(statementWithTableRef);
                Keyspace ks = schema.getKeyspace(keyspaceRef.getKeyspace());
                int index = 0;
                while (index < tuples.size()) {
                    EReference feature = CqlPackage.Literals.RELATION__TERM_TUPLES;
                    this.assertMultiColumnBasedTupleCompatibleWithTupleLiteral(relation, cfMeta, (TupleLiteral)tuples.get(index), (EStructuralFeature)feature, index, schema, ks);
                    ++index;
                }
            }
        }
    }

    private CqlDataType getColumnTypeToValidate(Relation relation, Column column) {
        CqlDataType columnType = column.getType();
        if (relation.isMapEntry() || relation.isContains() && columnType.isCollection()) {
            if (columnType.isMap()) {
                if (relation.isMapEntry()) {
                    return columnType;
                }
                columnType = relation.isKey() ? ((MapCqlDataType)columnType).getKeyType() : ((MapCqlDataType)columnType).getElementType();
            } else {
                columnType = ((CollectionCqlDataType)columnType).getElementType();
            }
        }
        return columnType;
    }

    private void assertMultiColumnBasedTupleCompatibleWithTupleLiteral(Relation relation, Table cfMeta, TupleLiteral tuple, EStructuralFeature feature, int featureIndex, Schema schema, Keyspace ks) {
        LinkedList<CqlDataType> innerTypes = new LinkedList<CqlDataType>();
        for (ColumnEntity columnEntity : relation.getColumns()) {
            Column column = this.getColumnMetadata(columnEntity, cfMeta);
            innerTypes.add(column.getType());
        }
        TupleCqlDataType tupleType = new TupleCqlDataType(innerTypes);
        boolean compatible = true;
        if (tuple.getValues().size() != tupleType.getInnerTypes().size()) {
            compatible = false;
        } else {
            int index = 0;
            while (index < tupleType.getInnerTypes().size()) {
                CqlDataType columnType = tupleType.getInnerTypes().get(index);
                if (!columnType.testAssignment((Term)tuple.getValues().get(index), schema, ks).isAssignable()) {
                    compatible = false;
                    break;
                }
                ++index;
            }
        }
        if (!compatible) {
            String unfrozenTupleType = FunctionUtil.getUnfrozenSignature(Lists.newArrayList((Object[])new CqlDataType[]{tupleType}));
            TupleCqlDataType literalTypeApproximation = CqlDataTypeFactory.fromTupleTypeLiteral(tuple, schema, ks);
            String unfrozenLiteral = FunctionUtil.getUnfrozenSignature(Lists.newArrayList((Object[])new CqlDataType[]{literalTypeApproximation}));
            this.error(String.format("Column tuple type %s is not compatible with %s", unfrozenTupleType, unfrozenLiteral), relation, feature, featureIndex);
        }
    }
}

