/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.OrderByClause;
import com.datastax.devcenter.cql.cql.Relation;
import com.datastax.devcenter.cql.cql.SelectClause;
import com.datastax.devcenter.cql.cql.SelectCountClause;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.SelectorTTL;
import com.datastax.devcenter.cql.cql.SelectorWritetime;
import com.datastax.devcenter.cql.cql.WhereClause;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Table;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class SelectStatementValidator
extends UtilityValidator {
    @Check
    public void orderByAlias(SelectStatement stmt) {
        if (stmt.getOrderings() == null) {
            return;
        }
        int i = 0;
        while (i < stmt.getOrderings().size()) {
            String columnName;
            OrderByClause orderClause = (OrderByClause)stmt.getOrderings().get(i);
            if (orderClause.getColumn() != null && this.isAlias(stmt, columnName = this.getOrResolveColumnName(orderClause))) {
                this.error(String.format("Aliases are not allowed in order by clause (%s)", ModelUtil.stripName(columnName)), (EStructuralFeature)CqlPackage.Literals.SELECT_STATEMENT__ORDERINGS, i, "ALIASES_ARENT_ALLOWED_IN_ORDER_BY_CLAUSE", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void whereClauseAlias(WhereClause whereClause) {
        SelectStatement stmt = ModelUtil.getAncestorOfType(whereClause, SelectStatement.class);
        if (stmt == null || whereClause.getRelations() == null) {
            return;
        }
        int i = 0;
        while (i < whereClause.getRelations().size()) {
            String columnName;
            Relation relation = (Relation)whereClause.getRelations().get(i);
            if (relation.getColumn() != null && this.isAlias(stmt, columnName = this.getOrResolveColumnName(relation))) {
                this.error(String.format("Aliases aren't allowed in where clause (%s)", ModelUtil.stripName(columnName)), (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS, i, "ALIASES_ARENT_ALLOWED_IN_WHERE_CLAUSE", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void whereClauseKeyValuePair(WhereClause whereClause) {
        SelectStatement stmt = ModelUtil.getAncestorOfType(whereClause, SelectStatement.class);
        if (stmt == null || whereClause.getRelations() == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null) {
            return;
        }
        int i = 0;
        while (i < whereClause.getRelations().size()) {
            String columnName;
            Column column;
            Relation relation = (Relation)whereClause.getRelations().get(i);
            if (relation.getColumn() != null && (column = tableMeta.getColumn(columnName = this.getOrResolveColumnName(relation))) != null) {
                Index index = column.getIndex();
                if (relation.isMapEntry() && (index == null || !index.isEntries())) {
                    this.error(String.format("Column '%s' must have an ENTRIES index to query by key-value pair", ModelUtil.stripName(columnName)), (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS, i, "COLUMN_MUST_HAVE_AN_ENTRIES_INDEX_TO_QUERY_BY_KEY_VALUE_PAIR", new String[0]);
                }
            }
            ++i;
        }
    }

    @Check
    public void unsupportedOrderBy(SelectStatement stmt) {
        if (stmt.getOrderings() == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null) {
            return;
        }
        boolean allSameOrder = true;
        boolean allOppositeOrder = true;
        StringBuilder builderSameOrder = new StringBuilder();
        StringBuilder builderOppositeOrder = new StringBuilder();
        int i = 0;
        while (i < stmt.getOrderings().size()) {
            OrderByClause ord = (OrderByClause)stmt.getOrderings().get(i);
            if (ord.getColumn() != null) {
                String colName = ModelUtil.stripName(ord.getColumn().getName());
                Table.ClusteringOrder orderMeta = tableMeta.getClusteringOrder(colName);
                if (i > 0) {
                    builderSameOrder.append(", ");
                    builderOppositeOrder.append(", ");
                }
                builderSameOrder.append(colName);
                builderSameOrder.append(" ");
                builderSameOrder.append(orderMeta.getOrder());
                builderOppositeOrder.append(colName);
                builderOppositeOrder.append(" ");
                builderOppositeOrder.append(orderMeta.getOppositeOrder());
                if (ord.isReversed() && orderMeta.equals((Object)Table.ClusteringOrder.DESC) || !ord.isReversed() && orderMeta.equals((Object)Table.ClusteringOrder.ASC)) {
                    allOppositeOrder = false;
                }
                if (!ord.isReversed() && orderMeta.equals((Object)Table.ClusteringOrder.DESC) || ord.isReversed() && orderMeta.equals((Object)Table.ClusteringOrder.ASC)) {
                    allSameOrder = false;
                }
            }
            ++i;
        }
        if (!allOppositeOrder && !allSameOrder) {
            this.error(String.format("Unsupported order by relation. Need to be either all in same order (%s) or all in opposite order (%s).", builderSameOrder.toString(), builderOppositeOrder.toString()), (EStructuralFeature)CqlPackage.Literals.SELECT_STATEMENT__ORDER_BY, "UNSUPPORTED_ORDER_BY_RELATION", new String[0]);
        }
    }

    @Check
    public void inOnNonPrimaryKey(WhereClause whereClause) {
        if (ModelUtil.getAncestorOfType(whereClause, SelectStatement.class) == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(whereClause);
        if (tableMeta == null || whereClause.getRelations() == null) {
            return;
        }
        int i = 0;
        while (i < whereClause.getRelations().size()) {
            Relation rel = (Relation)whereClause.getRelations().get(i);
            if (rel.getColumn() != null) {
                String name = ModelUtil.stripName(rel.getColumn().getName());
                if (rel.isIn() && !tableMeta.isPrimaryKeyContain(name)) {
                    this.error(String.format("IN predicates on non-primary-key columns (%s) is not yet supported", name), (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS, i, "IN_PREDICATES_ON_NON_PRIMARY_KEY_COLUMNS_IS_NOT_YET_SUPPORTED", new String[0]);
                }
            }
            ++i;
        }
    }

    private String joinString(List<String> strings, String delimiter) {
        StringBuilder sb = new StringBuilder();
        if (strings.size() == 0) {
            return "";
        }
        sb.append(strings.get(0));
        int i = 1;
        while (i < strings.size()) {
            sb.append(delimiter);
            sb.append(strings.get(i));
            ++i;
        }
        return sb.toString();
    }

    private List<String> collectSelectorNames(List<Selector> selectors) {
        ArrayList<String> names = new ArrayList<String>();
        for (Selector sel : selectors) {
            if (sel.getColumn() == null) continue;
            names.add(ModelUtil.stripName(sel.getColumn().getName()));
        }
        return names;
    }

    @Check
    public void selectorWritetimeOnPrimaryKey(SelectorWritetime s) {
        Table tableMeta = this.getTableMeta(s);
        if (tableMeta == null || s.getColumn() == null) {
            return;
        }
        String name = ModelUtil.stripName(s.getColumn().getName());
        if (tableMeta.isPrimaryKeyContain(name)) {
            this.error(String.format("Cannot use selection function WRITETIME on PRIMARY KEY part %s", name), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_USE_SELECTION_FUNCTION_ON_PRIMARY_KEY_PART", new String[0]);
        }
    }

    @Check
    public void selectorTtlOnPrimaryKey(SelectorTTL s) {
        Table tableMeta = this.getTableMeta(s);
        if (tableMeta == null || s.getColumn() == null) {
            return;
        }
        String name = ModelUtil.stripName(s.getColumn().getName());
        if (tableMeta.isPrimaryKeyContain(name)) {
            this.error(String.format("Cannot use selection function TTL on PRIMARY KEY part %s", name), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_USE_SELECTION_FUNCTION_ON_PRIMARY_KEY_PART", new String[0]);
        }
    }

    @Check
    public void selectorWritetimeOnCollection(SelectorWritetime s) {
        Table tableMeta = this.getTableMeta(s);
        if (tableMeta == null || s.getColumn() == null) {
            return;
        }
        String name = ModelUtil.stripName(s.getColumn().getName());
        if (tableMeta.getColumn(name).getType().isCollection()) {
            this.error("Cannot use selection function WRITETIME on collections", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_USE_SELECTION_FUNCTION_ON_COLLECTIONS", new String[0]);
        }
    }

    @Check
    public void selectorTtlOnCollection(SelectorTTL s) {
        Table tableMeta = this.getTableMeta(s);
        if (tableMeta == null || s.getColumn() == null) {
            return;
        }
        String name = ModelUtil.stripName(s.getColumn().getName());
        if (tableMeta.getColumn(name).getType().isCollection()) {
            this.error("Cannot use selection function TTL on collections", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_USE_SELECTION_FUNCTION_ON_COLLECTIONS", new String[0]);
        }
    }

    @Check
    public void orderByNotInSameOrder(SelectStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (stmt.getOrderings() == null || tableMeta == null) {
            return;
        }
        List cks = Lists.transform(tableMeta.getClusteringKeys(), ISchemaElement.GET_NAME);
        int i = 0;
        while (i < stmt.getOrderings().size()) {
            String ckName;
            OrderByClause ob = (OrderByClause)stmt.getOrderings().get(i);
            if (ob.getColumn() != null && !tableMeta.getClusteringOrder(ckName = ModelUtil.stripName(ob.getColumn().getName())).equals((Object)Table.ClusteringOrder.NONE) && i < cks.size() && !((String)cks.get(i)).equals(ckName)) {
                this.error("Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY", (EStructuralFeature)CqlPackage.Literals.SELECT_STATEMENT__ORDERINGS, i, "ORDER_BY_CURRENTLY_ONLY_SUPPORT_THE_ORDERING_OF_COLUMNS_FOLLOWING_THEIR_DECLARED_ORDER_IN_THE_PRIMARY_KEY", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void orderByNotInOrder(SelectStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (stmt.getOrderings() == null || tableMeta == null) {
            return;
        }
        int i = 0;
        while (i < stmt.getOrderings().size()) {
            String ckName;
            OrderByClause ob = (OrderByClause)stmt.getOrderings().get(i);
            if (ob.getColumn() != null && !this.isAlias(stmt, ckName = ModelUtil.stripName(ob.getColumn().getName())) && tableMeta.getClusteringOrder(ckName).equals((Object)Table.ClusteringOrder.NONE)) {
                this.error(String.format("Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", ckName), (EStructuralFeature)CqlPackage.Literals.SELECT_STATEMENT__ORDERINGS, i, "ORDER_BY_IS_CURRENTLY_ONLY_SUPPORTED_ON_THE_CLUSTERED_COLUMNS_OF_THE_PRIMARY_KEY_GOT_", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void whereInAtNotLastPartition(WhereClause whereClause) {
        if (whereClause.getRelations() == null) {
            return;
        }
        SelectStatement stmt = ModelUtil.getAncestorOfType(whereClause, SelectStatement.class);
        if (stmt == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null) {
            return;
        }
        List<Column> pks = tableMeta.getPartitionKeys();
        String lastPkName = pks.get(pks.size() - 1).getName();
        List pkNames = Lists.transform(pks, ISchemaElement.GET_NAME);
        int i = 0;
        while (i < whereClause.getRelations().size()) {
            String name;
            Relation rel = (Relation)whereClause.getRelations().get(i);
            if (rel.isIn() && rel.getColumn() != null && pkNames.contains(name = ModelUtil.stripName(rel.getColumn().getName())) && !lastPkName.contains(name)) {
                this.error(String.format("IN is only supported on the last column (%s) of the partition key", lastPkName), (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS, i, "IN_IS_ONLY_SUPPORTED_ON_THE_LAST_COLUMN_OF_THE_PARTITION_KEY", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void limitPositiveNumber(SelectStatement stmt) {
        if (stmt.getLimit() != null && Integer.parseInt(stmt.getLimit()) <= 0) {
            this.error("LIMIT must be strictly positive", (EStructuralFeature)CqlPackage.Literals.SELECT_STATEMENT__LIMIT, "LIMIT_MUST_BE_STRICTLY_POSITIVE", new String[0]);
        }
    }

    @Check
    public void countAsterickOne(SelectCountClause clause) {
        if (clause.getInteger() != null && !clause.getInteger().equals("1")) {
            this.error("Only COUNT(*) and COUNT(1) operations are currently supported.", (EStructuralFeature)CqlPackage.Literals.SELECT_COUNT_CLAUSE__INTEGER, "ONLY_COUNT_AND_COUNT1_OPERATIONS_ARE_CURRENTLY_SUPPORTED", new String[0]);
        }
    }

    @Check
    public void distinctWithNonPartitionKey(SelectClause clause) {
        if (!clause.isDistinct()) {
            return;
        }
        SelectStatement stmt = ModelUtil.getAncestorOfType(clause, SelectStatement.class);
        if (stmt == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        List<Column> columnMetas = tableMeta.getPartitionKeys();
        List partitionNames = Lists.transform(columnMetas, ISchemaElement.GET_NAME);
        int i = 0;
        while (i < clause.getSelectors().size()) {
            Selector sel = (Selector)clause.getSelectors().get(i);
            String colName = ModelUtil.stripName(sel.getColumn().getName());
            if (sel.getColumn() != null && !partitionNames.contains(colName)) {
                this.error(String.format("SELECT DISTINCT queries must only request partition key columns (not %s)", colName), (EStructuralFeature)CqlPackage.Literals.SELECT_CLAUSE__SELECTORS, i, "SELECT_DISTINCT_QUERIES_MUST_ONLY_REQUEST_PARTITION_KEY_COLUMNS_NOT", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void distinctNotAllPartitionKeyAreQueried(SelectClause clause) {
        if (!clause.isDistinct()) {
            return;
        }
        SelectStatement stmt = ModelUtil.getAncestorOfType(clause, SelectStatement.class);
        if (stmt == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        List<Column> columnMetas = tableMeta.getPartitionKeys();
        List partitionNames = Lists.transform(columnMetas, ISchemaElement.GET_NAME);
        List<String> selectorNames = this.collectSelectorNames((List<Selector>)clause.getSelectors());
        ArrayList<String> unusedNames = new ArrayList<String>();
        for (String pName : partitionNames) {
            if (selectorNames.contains(pName)) continue;
            unusedNames.add(pName);
        }
        String unusedNameString = this.joinString(unusedNames, ", ");
        if (unusedNames.size() > 0) {
            this.error(String.format("SELECT DISTINCT queries must request all the partition key columns (missing %s)", unusedNameString), (EStructuralFeature)CqlPackage.Literals.SELECT_CLAUSE__DISTINCT, "SELECT_DISTINCT_QUERIES_MUST_REQUEST_ALL_THE_PARTITION_KEY_COLUMNS", new String[0]);
        }
    }

    @Check
    public void selectStatementWithoutSelectors(SelectStatement stmt) {
        if (stmt.getSelectClause() == null && stmt.getSelectCountClause() == null) {
            this.error("Zero-length column name. Nothing to select from.", (EStructuralFeature)CqlPackage.Literals.SELECT_STATEMENT__SELECT_CLAUSE, "ZERO_LENGTH_COLUMN_NAME", new String[0]);
        }
    }
}

