/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.parser.antlr.internal.InternalCqlParser;
import com.google.inject.Inject;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MissingTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider;
import org.eclipse.xtext.parser.antlr.SyntaxErrorMessageProvider;

public class SyntaxErrorMessageProviderCustom
extends SyntaxErrorMessageProvider {
    @Inject
    IGrammarAccess grammarAccess;

    public SyntaxErrorMessage getSyntaxErrorMessage(ISyntaxErrorMessageProvider.IParserErrorContext context) {
        if (context instanceof ISyntaxErrorMessageProvider.IUnorderedGroupErrorContext) {
            ((ISyntaxErrorMessageProvider.IUnorderedGroupErrorContext)context).getMissingMandatoryElements();
        }
        RecognitionException re = context.getRecognitionException();
        String unexpectedTokenText = "";
        if (re != null && re.token != null) {
            re.token.getType();
            unexpectedTokenText = re.token.getText();
        }
        if (context.getDefaultMessage().startsWith("extraneous")) {
            String msg = context.getDefaultMessage();
            String[] msgm = msg.split(" ");
            return new SyntaxErrorMessage("extra input " + msgm[2], "EXTRA_INPUT");
        }
        if (re instanceof MissingTokenException) {
            MissingTokenException mte = (MissingTokenException)re;
            int missingTokenId = mte.getMissingType();
            if (-1 == missingTokenId) {
                return new SyntaxErrorMessage(String.valueOf(unexpectedTokenText) + " is not a valid keyword", "KEYWORD_TYPO");
            }
            String missingTokenName = InternalCqlParser.tokenNames[missingTokenId];
            if (missingTokenName.startsWith("RULE_K")) {
                String correctTokenName = missingTokenName.replaceAll("RULE_K_", "");
                return new SyntaxErrorMessage("The keyword should be " + correctTokenName, "KEYWORD_TYPO");
            }
        } else if (re instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)re;
            switch (mte.expecting) {
                case 130: {
                    return new SyntaxErrorMessage("Insert \";\" to complete a statement", "END_WITH_EOF");
                }
                case 146: {
                    return new SyntaxErrorMessage("Expecting an identifier", "MISSING_IDENT");
                }
            }
            int expectingTokenId = mte.expecting;
            String expectingTokenName = InternalCqlParser.tokenNames[expectingTokenId];
            if (expectingTokenName.startsWith("RULE_K_")) {
                String keywordName = expectingTokenName.replaceAll("RULE_K_", "");
                return new SyntaxErrorMessage("This statement needs a " + keywordName, "MISSING_KEYWORD");
            }
        } else {
            boolean cfr_ignored_0 = re instanceof NoViableAltException;
        }
        return super.getSyntaxErrorMessage(context);
    }
}

