/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.ColumnOperation;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.Relation;
import com.datastax.devcenter.cql.cql.StandardInsertStatement;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.UpdateCondition;
import com.datastax.devcenter.cql.cql.UpdateStatement;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.CollectionCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.datastax.devcenter.schema.types.MapCqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class UpdateStatementValidator
extends UtilityValidator {
    private static final BigInteger longMaxValue = new BigInteger("9223372036854775807");

    @Check
    public void mandatoryPrimaryKey(UpdateStatement stmt) {
        if (stmt.getWhereClause() == null || stmt.getWhereClause().getRelations() == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null) {
            return;
        }
        if (this.allSetColumnsAreStatic(stmt, tableMeta)) {
            return;
        }
        ArrayList<Column> pks = new ArrayList<Column>(tableMeta.getPrimaryKeys());
        List primaryKeys = Lists.transform(pks, ISchemaElement.GET_NAME);
        for (Relation rel : stmt.getWhereClause().getRelations()) {
            String cn = ModelUtil.stripName(this.getOrResolveColumnName(rel));
            if (!primaryKeys.contains(cn)) continue;
            primaryKeys.remove(cn);
        }
        for (String unused : primaryKeys) {
            this.error(String.format("Missing PRIMARY KEY part %s", unused), (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__WHERE_CLAUSE, "MISSING_MANDATORY_PRIMARY_KEY_PART_", new String[0]);
        }
    }

    private boolean allSetColumnsAreStatic(UpdateStatement stmt, Table tableMeta) {
        for (ColumnOperation columnOp : stmt.getOperations()) {
            String colName = this.getOrResolveColumnName(columnOp);
            Column colMeta = tableMeta.getColumn(colName);
            if (colMeta == null || colMeta.isStatic()) continue;
            return false;
        }
        return true;
    }

    @Check
    public void checkIncrementDecrementNonCounter(UpdateStatement stmt) {
        if (stmt.getOperations() == null) {
            return;
        }
        int i = 0;
        while (i < stmt.getOperations().size()) {
            ColumnOperation colop = (ColumnOperation)stmt.getOperations().get(i);
            if (this.isColumnOperationIncrementDecrementForm(colop) && this.isTwoColumnsEqual(colop) && !this.isColumnParticularType(colop.getColumn(), NativeCqlDataType.COUNTER)) {
                this.error(String.format("Invalid operation for non counter column %s.", ModelUtil.stripName(colop.getColumn().getName())), (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__OPERATIONS, i, "INVALID_OPERATION_FOR_NON_COUNTER_COLUMN_", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void assignCounter(UpdateStatement stmt) {
        if (stmt.getOperations() == null) {
            return;
        }
        int i = 0;
        while (i < stmt.getOperations().size()) {
            ColumnOperation colop = (ColumnOperation)stmt.getOperations().get(i);
            if (this.isAssignATerm(colop) && this.isColumnParticularType(colop.getColumn(), NativeCqlDataType.COUNTER)) {
                this.error(String.format("Cannot set the value of counter column %s (counters can only be incremented/decremented, not set)", ModelUtil.stripName(colop.getColumn().getName())), (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__OPERATIONS, i, "CANNOT_SET_THE_VALUE_OF_COUNTER_COLUMN_COUNTERS_CAN_ONLY_BE_INCREMENTED_DECREMENTED_NOT_SET", new String[]{ModelUtil.stripName(colop.getColumn().getName()), colop.getTerm().getValue().getConstant().getValue()});
            }
            ++i;
        }
    }

    @Check
    public void allColumnsForCompactStorage(InsertStatement stmt) {
        if (stmt.getStandardInsertPart() == null || stmt.getStandardInsertPart().getColumns() == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta.isCompactStorage() && stmt.getStandardInsertPart().getColumns() != null && stmt.getStandardInsertPart().getColumns().size() != tableMeta.getColumns().size()) {
            this.error("For COMPACT STORAGE table all columns are mandatory", (EStructuralFeature)CqlPackage.Literals.CREATE_TABLE_STATEMENT__TABLE, "COLUMN_IS_MANDATORY_FOR_THIS_COMPACT_STORAGE_TABLE", new String[0]);
        }
    }

    @Check
    public void multipleUpdateForSameColumn(UpdateStatement stmt) {
        if (stmt.getOperations() == null) {
            return;
        }
        HashSet<String> s = new HashSet<String>();
        int i = 0;
        while (i < stmt.getOperations().size()) {
            ColumnOperation colop = (ColumnOperation)stmt.getOperations().get(i);
            if (colop != null && colop.getColumn() != null) {
                String name = ModelUtil.stripName(colop.getColumn().getName());
                if (s.contains(name)) {
                    this.error(String.format("Trying to update value for column %s more than once in one statement", name), (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__OPERATIONS, i, "MULTIPLE_DEFINITIONS_FOUND_FOR_COLUMN_", new String[0]);
                }
                s.add(name);
            }
            ++i;
        }
    }

    @Check
    public void multipleInsertForSameColumn(StandardInsertStatement stmt) {
        if (stmt.getColumns() == null) {
            return;
        }
        HashSet<String> s = new HashSet<String>();
        int i = 0;
        while (i < stmt.getColumns().size()) {
            ColumnEntity colField = (ColumnEntity)stmt.getColumns().get(i);
            if (colField != null) {
                String name = ModelUtil.stripName(colField.getName());
                if (s.contains(name)) {
                    this.error(String.format("Trying to insert value for column %s more than once in one statement", name), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMNS_REF__COLUMNS, i, "MULTIPLE_DEFINITIONS_FOUND_FOR_COLUMN_", new String[0]);
                }
                s.add(name);
            }
            ++i;
        }
    }

    @Check
    public void insertCounter(StandardInsertStatement stmt) {
        InsertStatement insertStatement = (InsertStatement)stmt.eContainer();
        Table tableMeta = this.getTableMeta(insertStatement);
        for (Column col : tableMeta.getColumns()) {
            if (!col.getType().equals(NativeCqlDataType.COUNTER)) continue;
            this.error("INSERT statement is not allowed on tables having counters, use UPDATE instead", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMNS_REF__COLUMNS, "INSERT_STATEMENT_ARE_NOT_ALLOWED_ON_COUNTER_TABLES_USE_UPDATE_INSTEAD", new String[0]);
        }
    }

    @Check
    public void setPrimaryKeyPart(UpdateStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (stmt.getOperations() == null || tableMeta == null) {
            return;
        }
        int i = 0;
        while (i < stmt.getOperations().size()) {
            String columnName;
            ColumnOperation colop = (ColumnOperation)stmt.getOperations().get(i);
            ColumnEntity columnField = colop.getColumn();
            if (columnField != null && tableMeta.isPrimaryKeyContain(columnName = ModelUtil.stripName(columnField.getName()))) {
                this.error(String.format("PRIMARY KEY part %s found in SET part", columnName), (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__OPERATIONS, i, "PRIMARY_KEY_PART_FOUND_IN_SET_PART", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void incrementOverflow(ColumnOperation colop) {
        BigInteger increment;
        if (this.isTwoColumnsEqual(colop) && this.isAppend(colop) && NativeCqlDataType.INT.validate(this.getConstant(colop.getTerm())) && (increment = new BigInteger(this.getConstant(colop.getTerm()))).compareTo(longMaxValue) >= 0) {
            this.error(String.format("The negation of %s overflows supported counter precision (signed 8 bytes integer)", increment.toString()), (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__TERM, "THE_NEGATION_OF_OVERFLOWS_SUPPORTED_COUNTER_PRECISION_SIGNED_8_BYTES_INTEGER", new String[0]);
        }
    }

    @Check
    public void notAssignInIf(UpdateCondition condition) {
        int i = 0;
        while (i < condition.getOperations().size()) {
            ColumnOperation colop = (ColumnOperation)condition.getOperations().get(i);
            if (!this.isAssignATerm(colop)) {
                this.error("Only ColumnName = Value is supported.", (EStructuralFeature)CqlPackage.Literals.UPDATE_CONDITION__OPERATIONS, i, "ONLY_COLUMN_EQUAL_VALUE_IS_SUPPORTED", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void checkNonNullIncrementDecrement(ColumnOperation colop) {
        if (this.isTwoColumnsEqual(colop) && this.isAppend(colop) && this.isNullConstant(colop.getTerm())) {
            this.error("Invalid null value for counter increment/decrement", (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__TERM, "INVALID_NULL_VALUE_FOR_COUNTER_INCREMENT_DECREMENT", new String[0]);
        }
    }

    @Check
    public void checkIncrementDecrement(UpdateStatement stmt) {
        if (stmt.getOperations() == null) {
            return;
        }
        int i = 0;
        while (i < stmt.getOperations().size()) {
            ColumnOperation colop = (ColumnOperation)stmt.getOperations().get(i);
            if (this.isColumnOperationIncrementDecrementForm(colop) && !this.isTwoColumnsEqual(colop)) {
                this.error("Only expressions of the form X = X +/- <value> are suppported.", (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__OPERATIONS, i, "ONLY_EXPRESSION_OF_THE_FORM_X_X_VALUE_ARE_SUPPORTED", new String[0]);
            }
            ++i;
        }
    }

    protected void checkColumnTypeList(ColumnOperation colop, Column colMeta, Schema schema, Keyspace ks) {
        if (colop == null || !colop.isMapList()) {
            return;
        }
        Term keyTerm = colop.getKeyTerm();
        Term valueTerm = colop.getTerm();
        CqlDataType colType = colMeta.getType();
        if (colType == null || keyTerm == null || valueTerm == null || !colType.isCollection()) {
            return;
        }
        CqlDataType argType = ((CollectionCqlDataType)colType).getElementType();
        if (NativeCqlDataType.INT.testAssignment(keyTerm, schema, ks).isNotAssignable()) {
            this.error("index has to be an integer", (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__KEY_TERM, "INDEX_NOT_INTEGER", new String[0]);
        }
        if (argType.testAssignment(valueTerm, schema, ks).isNotAssignable()) {
            this.error(String.format("Column %s type %s is not compatible with type %s", colMeta.getName(), colType.toString(), CqlDataTypeFactory.fromTermType(valueTerm, schema, ks)), (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__TERM, "NOT_EQUAL_TYPE", new String[0]);
        }
    }

    protected void checkColumnTypeMap(ColumnOperation colop, Column colMeta, Schema schema, Keyspace ks) {
        if (colop == null || !colop.isMapList()) {
            return;
        }
        Term keyTerm = colop.getKeyTerm();
        Term valueTerm = colop.getTerm();
        CqlDataType colType = colMeta.getType();
        if (colType == null || keyTerm == null || valueTerm == null || !colType.isMap()) {
            return;
        }
        CqlDataType argType1 = ((MapCqlDataType)colType).getKeyType();
        CqlDataType argType2 = ((MapCqlDataType)colType).getElementType();
        if (argType1.testAssignment(keyTerm, schema, ks).isNotAssignable()) {
            this.error(String.format("Column %s key type %s is not compatible with type %s", colMeta.getName(), argType1.toString(), CqlDataTypeFactory.fromTermType(keyTerm, schema, ks)), (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__KEY_TERM, "NOT_EQUAL_TYPE", new String[0]);
        }
        if (argType2.testAssignment(valueTerm, schema, ks).isNotAssignable()) {
            this.error(String.format("Column %s value type %s is not compatible with type %s", colMeta.getName(), argType2.toString(), CqlDataTypeFactory.fromTermType(valueTerm, schema, ks)), (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__TERM, "NOT_EQUAL_TYPE", new String[0]);
        }
    }

    protected void checkColumnTypeOtherColumn(ColumnOperation colop, Column colMeta, Column otherColMeta, Schema schema, Keyspace keyspace) {
        if (colop == null || colMeta == null) {
            return;
        }
        CqlDataType colType = colMeta.getType();
        if (colType == null) {
            return;
        }
        Term term = colop.getTerm();
        if (term != null && colMeta.getType().testAssignment(term, schema, keyspace).isNotAssignable()) {
            this.error(String.format("Column %s type %s is not compatible with type %s", colMeta.getName(), colType.toString(), CqlDataTypeFactory.fromTermType(term, schema, keyspace)), (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__TERM, "NOT_EQUAL_TYPE", new String[0]);
        }
        if (otherColMeta != null && !otherColMeta.getType().equals(colMeta.getType())) {
            this.error(String.format("Column %s has type %s", colMeta.getName(), colMeta.getType().toString()), (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__OTHER_COLUMN, "NOT_EQUAL_TYPE", new String[0]);
        }
        if (this.isPrepend(colop)) {
            if (!colop.getPrependSign().equals("+")) {
                this.error("Can only prepend (\"+\") a list in front of another list type column", (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__PREPEND_SIGN, "NOT_PREPEND_LIST_SIGN", new String[0]);
            }
            if (!this.isList(term)) {
                this.error("Can only prepend a list in front of another list type column", (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__TERM, "NOT_PREPEND_LIST", new String[0]);
            }
            if (!colMeta.getType().isList()) {
                this.error("Can only prepend on list type column", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "NOT_PREPEND_LIST", new String[0]);
            }
        }
        if (this.isAppend(colop)) {
            if (this.isMap(term)) {
                if (colop.getAppendSign().equals("-")) {
                    this.error("Can not subtract a map", (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__APPEND_SIGN, "SUBTRACT_A_MAP", new String[0]);
                }
            } else if (!(NativeCqlDataType.INT.testAssignment(term, schema, keyspace).isAssignable() || this.isList(term) || this.isSet(term))) {
                this.error("Valid types to append are int, set, list or map ", (EStructuralFeature)CqlPackage.Literals.COLUMN_OPERATION__TERM, "NOT_SUPPORTED_TYPE", new String[0]);
            }
        }
    }

    @Check
    public void checkColumnType(ColumnOperation colop) {
        Table cfMeta = this.getTableMeta(colop);
        Column colMeta = this.getColumnMetadata(colop.getColumn(), cfMeta);
        Schema schema = this.getSchemaToCheck(colop);
        if (colMeta == null) {
            return;
        }
        CqlDataType colType = colMeta.getType();
        if (colType == null) {
            return;
        }
        if (colType.isCollection() && colType.isFrozen() && (this.isAppend(colop) || this.isPrepend(colop) || this.isMapOrListAssign(colop))) {
            this.error(String.format("Invalid operation for frozen collection column %s", ModelUtil.stripName(colop.getColumn().getName())), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "INVALID_OPERATION_FOR_FROZEN_COLLECTION_COLUMN", new String[0]);
        }
        if (colop.isMapList()) {
            if (colType.isList()) {
                this.checkColumnTypeList(colop, colMeta, schema, cfMeta.getKeyspace());
            } else if (colType.isMap()) {
                this.checkColumnTypeMap(colop, colMeta, schema, cfMeta.getKeyspace());
            } else {
                this.error(String.format("Column %s has type %s, this syntax is only for list and map", colMeta.getName(), colType.toString()), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "NOT_LIST_MAP_TYPE", new String[0]);
            }
        } else {
            Column otherColMeta = this.getColumnMetadata(colop.getOtherColumn(), cfMeta);
            this.checkColumnTypeOtherColumn(colop, colMeta, otherColMeta, schema, cfMeta.getKeyspace());
        }
    }

    @Check
    public void listOperationNotAllowedInConditionUpdate(UpdateStatement stmt) {
        if (this.isConditional(stmt)) {
            int i = 0;
            while (i < stmt.getOperations().size()) {
                ColumnOperation colop = (ColumnOperation)stmt.getOperations().get(i);
                if ((this.isPrepend(colop) || this.isAppend(colop)) && this.isList(colop.getTerm())) {
                    this.error("List operation are not allowed in conditional updates", (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__OPERATIONS, i, "LIST_OPERATION_ARE_NOT_ALLOWED_IN_CONDITIONAL_UPDATES", new String[0]);
                }
                ++i;
            }
        }
    }

    private boolean isColumnOperationIncrementDecrementForm(ColumnOperation colop) {
        return colop.getColumn() != null && colop.getOtherColumn() != null && this.isAppend(colop) && NativeCqlDataType.INT.validate(colop.getTerm());
    }

    private boolean isTwoColumnsEqual(ColumnOperation colop) {
        return colop.getColumn() != null && colop.getOtherColumn() != null && colop.getColumn().getName().equals(colop.getOtherColumn().getName());
    }

    private boolean isAssignATerm(ColumnOperation colop) {
        return !this.isAppend(colop) && !this.isPrepend(colop) && !this.isMapOrListAssign(colop) && colop.getTerm() != null && colop.getOtherColumn() == null;
    }

    private boolean isColumnParticularType(ColumnEntity columnField, CqlDataType dataType) {
        if (columnField == null) {
            return false;
        }
        Table tableMeta = this.getTableMeta(columnField);
        if (tableMeta == null) {
            return false;
        }
        Column columnMeta = tableMeta.getColumn(ModelUtil.stripName(columnField.getName()));
        if (columnMeta == null) {
            return false;
        }
        return columnMeta.getType().equals(dataType);
    }
}

