/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.AlterUserStatement;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.UserEntity;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class UserStatementValidator
extends UtilityValidator {
    @Check
    public void emptyUserName(UserEntity userOrRole) {
        if (userOrRole.getName() == null || ModelUtil.stripName(userOrRole.getName()).isEmpty()) {
            this.error("User name can't be an empty string", (EStructuralFeature)CqlPackage.Literals.USER_ENTITY__NAME, "USERNAME_CANT_BE_AN_EMPTY_STRING", new String[0]);
        }
    }

    @Check
    public void emptyAlterUserStmt(AlterUserStatement stmt) {
        if (stmt.getUserOptions().isEmpty() && !stmt.isSuperuser() && !stmt.isNosuperuser()) {
            this.error("Alter [ROLE|USER] options can't be empty", (EStructuralFeature)CqlPackage.Literals.ALTER_USER_STATEMENT__USER_OPTIONS, "ALTER_USER_ROLE_CANT_BE_EMPTY_STRING", new String[0]);
        }
    }
}

