/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.DeleteStatement;
import com.datastax.devcenter.cql.cql.UsingClause;
import com.datastax.devcenter.cql.cql.UsingClauseOption;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class UsingClauseValidator
extends UtilityValidator {
    @Check
    public void TtlOptionInDeleteBatch(UsingClause usingClause) {
        int i = 0;
        while (i < usingClause.getOptions().size()) {
            if (((UsingClauseOption)usingClause.getOptions().get(i)).isTtlOption() && ModelUtil.isAstChildOf(usingClause, DeleteStatement.class)) {
                this.error("USING TTL is not allowed in DELETE statement", (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE__OPTIONS, i, "TTL_NOT_ALLOWED_IN_DELETE_STATEMENT", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void ttlMaximum(UsingClauseOption usingClauseOption) {
        Integer TTL;
        if (usingClauseOption.isTtlOption() && usingClauseOption.getTtl() != null && (TTL = Integer.valueOf(Integer.parseInt(usingClauseOption.getTtl()))) > 630720000) {
            this.error(String.format("TTL is too large, allowed maximum is %d", 630720000), (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE_OPTION__TTL, "TTL_IS_TOO_LARGE_REQUESTED_MAXIMUM_", new String[0]);
        }
    }

    @Check
    public void nullTimestamp(UsingClauseOption usingClauseOption) {
        if (usingClauseOption.isTimestampOption() && (usingClauseOption.getTimestamp() == null || usingClauseOption.getTimestamp().equals(""))) {
            this.error("Invalid null value of timestamp", (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE_OPTION__TIMESTAMP, "INVALID_NULL_VALUE_OF_TIMESTAMP", new String[0]);
        }
    }

    @Check
    public void invalidTimestamp(UsingClauseOption usingClauseOption) {
        if (usingClauseOption.isTimestampOption() && !NativeCqlDataType.TIMESTAMP.validate(usingClauseOption.getTimestamp())) {
            this.error("Invalid timestamp value", (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE_OPTION__TIMESTAMP, "INVALID_TIMESTAMP_VALUE", new String[0]);
        }
    }

    @Check
    public void nullTTL(UsingClauseOption usingClauseOption) {
        if (usingClauseOption.isTtlOption() && (usingClauseOption.getTtl() == null || usingClauseOption.getTtl().equals(""))) {
            this.error("Invalid null value of TTL", (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE_OPTION__TTL, "INVALID_NULL_VALUE_OF_TTL", new String[0]);
        }
    }

    @Check
    public void negativeTTL(UsingClauseOption usingClauseOption) {
        if (usingClauseOption.isTtlOption() && usingClauseOption.getTtl() != null && usingClauseOption.getTtl().startsWith("-")) {
            this.error("TTL must be greater or equal to 0", (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE_OPTION__TTL, "A_TTL_MUST_BE_GREATER_OR_EQUAL_TO_0", new String[0]);
        }
    }
}

