/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.ColumnOperation;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.GrantStatement;
import com.datastax.devcenter.cql.cql.IndexEntity;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.ListLiteral;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.Relation;
import com.datastax.devcenter.cql.cql.RevokeStatement;
import com.datastax.devcenter.cql.cql.RulesWithColumnRef;
import com.datastax.devcenter.cql.cql.RulesWithColumnsRef;
import com.datastax.devcenter.cql.cql.RulesWithFieldRef;
import com.datastax.devcenter.cql.cql.RulesWithFieldsRef;
import com.datastax.devcenter.cql.cql.RulesWithIndexRef;
import com.datastax.devcenter.cql.cql.RulesWithKeyspaceRef;
import com.datastax.devcenter.cql.cql.RulesWithTableRef;
import com.datastax.devcenter.cql.cql.RulesWithTriggerRef;
import com.datastax.devcenter.cql.cql.RulesWithTypeRef;
import com.datastax.devcenter.cql.cql.RulesWithUserOrRoleRef;
import com.datastax.devcenter.cql.cql.RulesWithUserRef;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.SetLiteral;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TokenRelation;
import com.datastax.devcenter.cql.cql.TriggerEntity;
import com.datastax.devcenter.cql.cql.TupleType;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.UpdateStatement;
import com.datastax.devcenter.cql.cql.UserEntity;
import com.datastax.devcenter.cql.cql.UserOrRoleEntity;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.AbstractCqlJavaValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.datastax.devcenter.schema.types.MapCqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.devcenter.schema.types.UserDefinedTypeCqlDataType;
import com.datastax.driver.core.VersionNumber;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class UtilityValidator
extends AbstractCqlJavaValidator {
    @Inject
    protected CqlContextProvider contextProvider;

    public void register(EValidatorRegistrar registrar) {
    }

    protected Schema getSchemaToCheck(EObject eObject) {
        CqlContext context = this.contextProvider.get(eObject);
        return context.getSchemaToCheck();
    }

    protected Schema getDatabaseSchema(EObject eObject) {
        CqlContext context = this.contextProvider.get(eObject);
        return context.getDatabaseSchema();
    }

    protected String getCrossReferenceName(EObject semanticObject, EStructuralFeature structuralFeature) {
        return this.getCrossReferenceName(semanticObject, structuralFeature, 0);
    }

    protected String getCrossReferenceName(EObject semanticObject, EStructuralFeature structuralFeature, int index) {
        String xrefName = null;
        List<INode> nodes = this.getCrossReferenceNames(semanticObject, structuralFeature);
        if (nodes.size() > index) {
            xrefName = nodes.get(index).getText().trim();
        }
        return xrefName;
    }

    protected List<INode> getCrossReferenceNames(EObject semanticObject, EStructuralFeature structuralFeature) {
        return NodeModelUtils.findNodesForFeature((EObject)semanticObject, (EStructuralFeature)structuralFeature);
    }

    protected Table getTableMeta(EObject o) {
        return this.contextProvider.get(o).getTableMeta(o);
    }

    protected Column getColumnMetadata(ColumnEntity columnEntity, Table tableMeta) {
        if (columnEntity == null || tableMeta == null) {
            return null;
        }
        Column colMeta = tableMeta.getColumn(ModelUtil.stripName(columnEntity.getName()));
        return colMeta == null ? null : colMeta;
    }

    protected boolean isFrozenType(Type type) {
        return type != null && type.getFrozenType() != null;
    }

    protected boolean isTupleType(Type type) {
        return type != null && type.getTuple() != null;
    }

    protected boolean isCustomType(Type type) {
        return type != null && type.getCustomType() != null;
    }

    protected boolean isNativeType(Type type) {
        return type != null && type.getNativeType() != null;
    }

    protected boolean isUserType(Type type) {
        return type != null && type.getUserType() != null;
    }

    protected boolean isCollectionType(Type type) {
        return type != null && type.getCollectionType() != null;
    }

    protected boolean isCounterType(Type type) {
        return type != null && this.isNativeType(type) && type.getNativeType().equalsIgnoreCase("counter");
    }

    protected boolean isFrozenRequiredForTuples() {
        return !this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_3);
    }

    protected boolean isFrozenCollectionSupported() {
        return this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_3);
    }

    protected boolean isCurrentVersionGreaterOrEqual(VersionNumber version) {
        CqlContext cqlContext = this.contextProvider.get(this.getCurrentObject());
        return cqlContext.isCurrentVersionGreaterOrEqual(version);
    }

    protected boolean isContainerFrozen(EObject obj) {
        if (obj == null || !(obj.eContainer() instanceof Type)) {
            return false;
        }
        return this.isFrozenType((Type)obj.eContainer());
    }

    protected boolean isFrozen(EObject obj) {
        EObject currentObj = obj;
        while (currentObj != null) {
            if (this.isContainerFrozen(currentObj)) {
                return true;
            }
            if (currentObj instanceof TupleType) {
                return true;
            }
            currentObj = currentObj.eContainer();
        }
        return false;
    }

    protected boolean isCollection(Term term) {
        return term != null && term.getValue() != null && term.getValue().getCollection() != null;
    }

    protected boolean isList(Term term) {
        return this.isCollection(term) && term.getValue().getCollection() instanceof ListLiteral;
    }

    protected boolean isSet(Term term) {
        return this.isCollection(term) && term.getValue().getCollection() instanceof SetLiteral;
    }

    protected boolean isMap(Term term) {
        return this.isCollection(term) && term.getValue().getCollection() instanceof MapLiteral;
    }

    protected boolean isNullConstant(Term term) {
        return term != null && term.getValue() != null && term.getValue().isNil();
    }

    protected boolean isNull(Term term) {
        return term != null && term.getValue() != null && term.getValue().isNil();
    }

    protected String getConstant(Term term) {
        if (term != null && term.getValue() != null && term.getValue().getConstant() != null) {
            return term.getValue().getConstant().getValue();
        }
        return "";
    }

    protected boolean isEqual(Relation rel) {
        return rel.getType() != null && rel.getType().equals("=");
    }

    protected boolean isUnequal(Relation rel) {
        return rel.getType() != null && !rel.getType().equals("=");
    }

    protected boolean isToken(Relation rel) {
        return rel instanceof TokenRelation;
    }

    protected boolean isIn(Relation rel) {
        return rel.isIn();
    }

    protected boolean isPrepend(ColumnOperation colop) {
        return colop.getPrependSign() != null;
    }

    protected boolean isAppend(ColumnOperation colop) {
        return colop.getAppendSign() != null;
    }

    protected boolean isMapOrListAssign(ColumnOperation colop) {
        return colop.isMapList();
    }

    private boolean equalAlias(Selector sel, String columnName) {
        return sel.getAlias() != null && sel.getAlias().equals(columnName);
    }

    protected String getOrResolveKeyspaceName(RulesWithKeyspaceRef rule) {
        String crossReferenceName;
        KeyspaceEntity keyspaceEntity = rule.getKeyspace();
        if (keyspaceEntity == null) {
            Keyspace ksMeta = this.contextProvider.get(rule).getSchemaToCheck().getKeyspace(keyspaceEntity);
            return ksMeta == null ? null : ksMeta.getName();
        }
        String keyspaceName = keyspaceEntity.getName();
        if (keyspaceName == null && (crossReferenceName = this.getCrossReferenceName(rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_KEYSPACE_REF__KEYSPACE)) != null) {
            keyspaceName = crossReferenceName;
        }
        return keyspaceName;
    }

    protected boolean isAlias(SelectStatement stmt, String columnName) {
        if (stmt != null && stmt.getSelectClause() != null) {
            for (Selector sel : stmt.getSelectClause().getSelectors()) {
                if (!this.equalAlias(sel, columnName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isConditional(UpdateStatement stmt) {
        return stmt == null ? false : stmt.getCondition() != null;
    }

    protected boolean isConditional(InsertStatement stmt) {
        return stmt == null ? false : stmt.isIfNotExists();
    }

    protected String getOrResolveTableName(CqlStatement stmt) {
        if (stmt instanceof RulesWithTableRef) {
            return this.getOrResolveTableName((RulesWithTableRef)((Object)stmt));
        }
        TableEntity tableEntity = ModelUtil.getTable(stmt);
        return tableEntity == null ? null : tableEntity.getName();
    }

    protected String getOrResolveTableName(RulesWithTableRef rule) {
        TableEntity tableEntity = rule.getTable();
        return tableEntity == null ? null : this.getOrResolveName(tableEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TABLE_REF__TABLE);
    }

    protected String getOrResolveTypeName(RulesWithTypeRef rule) {
        TypeEntity typeEntity = rule.getUserType();
        return typeEntity == null ? null : this.getOrResolveName(typeEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TYPE_REF__USER_TYPE);
    }

    protected String getOrResolveColumnName(RulesWithColumnRef rule) {
        ColumnEntity columnEntity = rule.getColumn();
        return columnEntity == null ? null : this.getOrResolveName(columnEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN);
    }

    protected String getOrResolveColumnName(RulesWithColumnsRef rule, int index) {
        EList<ColumnEntity> columnEntityList = rule.getColumns();
        String columnName = null;
        if (columnEntityList.size() > index) {
            ColumnEntity columnEntity = (ColumnEntity)columnEntityList.get(index);
            columnName = columnEntity == null ? null : this.getOrResolveName(columnEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMNS_REF__COLUMNS);
        }
        return columnName;
    }

    protected String getOrResolveFieldName(RulesWithFieldRef rule) {
        FieldEntity fieldEntity = rule.getUserTypeField();
        return fieldEntity == null ? null : this.getOrResolveName(fieldEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FIELD_REF__USER_TYPE_FIELD);
    }

    protected String getOrResolveFieldName(RulesWithFieldsRef rule, int index) {
        EList<FieldEntity> fieldEntityList = rule.getUserTypeFields();
        String fieldName = null;
        if (fieldEntityList.size() > index) {
            FieldEntity fieldEntity = (FieldEntity)fieldEntityList.get(index);
            fieldName = fieldEntity == null ? null : this.getOrResolveName(fieldEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FIELDS_REF__USER_TYPE_FIELDS);
        }
        return fieldName;
    }

    protected String getOrResolveUserName(RulesWithUserRef rule) {
        UserEntity userEntity = rule.getUser();
        return userEntity == null ? null : this.getOrResolveName(userEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_REF__USER);
    }

    protected String getOrResolveUserOrRoleName(GrantStatement rule) {
        UserOrRoleEntity userOrRoleEntity = rule.getGrantee();
        return userOrRoleEntity == null ? null : this.getOrResolveName(userOrRoleEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.GRANT_STATEMENT__GRANTEE);
    }

    protected String getOrResolveUserOrRoleName(RevokeStatement rule) {
        UserOrRoleEntity userOrRoleEntity = rule.getRevokee();
        return userOrRoleEntity == null ? null : this.getOrResolveName(userOrRoleEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.REVOKE_STATEMENT__REVOKEE);
    }

    protected String getOrResolveUserOrRoleName(RulesWithUserOrRoleRef rule) {
        UserOrRoleEntity userOrRoleEntity = rule.getUserOrRole();
        return userOrRoleEntity == null ? null : this.getOrResolveName(userOrRoleEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_OR_ROLE_REF__USER_OR_ROLE);
    }

    protected String getOrResolveIndexName(RulesWithIndexRef rule) {
        IndexEntity indexEntity = rule.getIndex();
        return indexEntity == null ? null : this.getOrResolveName(indexEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_INDEX_REF__INDEX);
    }

    protected String getOrResolveTriggerName(RulesWithTriggerRef rule) {
        TriggerEntity triggerEntity = rule.getTrigger();
        return triggerEntity == null ? null : this.getOrResolveName(triggerEntity.getName(), rule, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TRIGGER_REF__TRIGGER);
    }

    private String getOrResolveName(String name, EObject semanticObject, EStructuralFeature feature) {
        String crossReferenceName;
        if (name == null && (crossReferenceName = this.getCrossReferenceName(semanticObject, feature)) != null) {
            name = crossReferenceName;
        }
        return name;
    }

    protected boolean isCounter(ColumnDef tableColumn) {
        return tableColumn.getType() != null && tableColumn.getType().getNativeType() != null && NativeCqlDataType.COUNTER.matches(tableColumn.getType());
    }

    protected boolean hasCounter(EList<ColumnDef> tableColumns) {
        for (ColumnDef tableColumn : tableColumns) {
            if (!this.isCounter(tableColumn)) continue;
            return true;
        }
        return false;
    }

    protected String buildUDTString(UserDefinedTypeCqlDataType cdt) {
        StringBuilder builder = new StringBuilder(String.valueOf(cdt.getUserType().getName()) + "{ ");
        Iterator<UserTypeField> it = cdt.getUserType().getFields().iterator();
        while (it.hasNext()) {
            UserTypeField entry = it.next();
            builder.append(ModelUtil.doubleQuote(entry.getName()));
            builder.append(" : ");
            builder.append(entry.getType().toCanonicalString());
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" }");
        return builder.toString();
    }

    protected void validateTermAgainstColumnType(Term term, CqlDataType columnType, Column column, Schema schema, Keyspace keyspace, EStructuralFeature feature) {
        if (columnType.testAssignment(term, schema, keyspace).isNotAssignable()) {
            CqlDataType argumentType = CqlDataTypeFactory.fromTermType(term, schema, keyspace);
            String columnDisplayType = columnType.toCanonicalString();
            if (columnType instanceof UserDefinedTypeCqlDataType) {
                columnDisplayType = this.buildUDTString((UserDefinedTypeCqlDataType)columnType);
            }
            if (term.getSourceObject() != null) {
                this.error(String.format("Column %s type %s is not compatible with type %s", column.getName(), columnDisplayType, argumentType.toCanonicalString()), term.getSourceObject().eContainer(), term.getSourceObject().eContainingFeature(), -1, "NOT_EQUAL_TYPE", new String[0]);
            } else {
                this.error(String.format("Column %s type %s is not compatible with type %s", column.getName(), columnDisplayType, argumentType.toCanonicalString()), feature, "NOT_EQUAL_TYPE", new String[0]);
            }
        }
    }

    protected void validateTermAgainstMapKeyType(Term term, MapCqlDataType mapType, Column column, Schema schema, Keyspace keyspace, EStructuralFeature feature) {
        CqlDataType argumentType = CqlDataTypeFactory.fromTermType(term, schema, keyspace);
        CqlDataType mapKeyType = mapType.getKeyType();
        if (mapKeyType.testAssignment(term, schema, keyspace).isNotAssignable()) {
            String columnDisplayType = mapKeyType.toCanonicalString();
            if (mapKeyType instanceof UserDefinedTypeCqlDataType) {
                columnDisplayType = this.buildUDTString((UserDefinedTypeCqlDataType)mapKeyType);
            }
            this.error(String.format("Key of map '%s' type '%s' is not compatible with type '%s'", column.getName(), columnDisplayType, argumentType.toCanonicalString()), feature, "NOT_EQUAL_TYPE", new String[0]);
        }
    }

    protected void validateTermAgainstMapValueType(Term term, MapCqlDataType mapType, Column column, Schema schema, Keyspace keyspace, EStructuralFeature feature) {
        CqlDataType argumentType = CqlDataTypeFactory.fromTermType(term, schema, keyspace);
        CqlDataType mapKeyType = mapType.getElementType();
        if (mapKeyType.testAssignment(term, schema, keyspace).isNotAssignable()) {
            String columnDisplayType = mapKeyType.toCanonicalString();
            if (mapKeyType instanceof UserDefinedTypeCqlDataType) {
                columnDisplayType = this.buildUDTString((UserDefinedTypeCqlDataType)mapKeyType);
            }
            this.error(String.format("Value of map '%s' type '%s' is not compatible with type '%s'", column.getName(), columnDisplayType, argumentType.toCanonicalString()), feature, "NOT_EQUAL_TYPE", new String[0]);
        }
    }

    protected int findTermIndex(List<Term> terms, Term term) {
        int index = 0;
        for (Term t : terms) {
            if (t == term) break;
            ++index;
        }
        return index;
    }
}

