/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.cql.AlterRoleStatement;
import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.AlterTypeStatement;
import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateRoleStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.CreateTriggerStatement;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.CreateUserStatement;
import com.datastax.devcenter.cql.cql.DeleteStatement;
import com.datastax.devcenter.cql.cql.DropFunctionStatement;
import com.datastax.devcenter.cql.cql.DropIndexStatement;
import com.datastax.devcenter.cql.cql.DropKeyspaceStatement;
import com.datastax.devcenter.cql.cql.DropRoleStatement;
import com.datastax.devcenter.cql.cql.DropTableStatement;
import com.datastax.devcenter.cql.cql.DropTriggerStatement;
import com.datastax.devcenter.cql.cql.DropTypeStatement;
import com.datastax.devcenter.cql.cql.DropUserStatement;
import com.datastax.devcenter.cql.cql.Function;
import com.datastax.devcenter.cql.cql.FunctionDeclarationStatement;
import com.datastax.devcenter.cql.cql.GrantStatement;
import com.datastax.devcenter.cql.cql.IndexColumnDef;
import com.datastax.devcenter.cql.cql.IndexEntity;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.ListRolesStatement;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.Property;
import com.datastax.devcenter.cql.cql.Relation;
import com.datastax.devcenter.cql.cql.RevokeStatement;
import com.datastax.devcenter.cql.cql.SelectClause;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.SelectorFunction;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.UpdateStatement;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.parser.antlr.UnreservedKeywordlLiteralParser;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.PropertyMapValidator;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.BuiltInFunctionsRegistry;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.validation.Check;

public class VersionCompatibleValidator
extends UtilityValidator {
    @Inject
    private UnreservedKeywordlLiteralParser unresKeywordLiteralParser;
    private static final EStructuralFeature ANNOTATE_WHOLE_INSTANCE = null;
    private static final Set<String> FUNCTION_NAMES_121 = ImmutableSet.copyOf((Object[])new String[]{"timeuuid", "now", "minTimeuuid", "maxTimeuuid", "dateOf", "unixTimestampOf"});
    private static final Set<String> NATIVE_TYPES_220 = ImmutableSet.copyOf((Object[])new String[]{"date", "time", "smallint", "tinyint"});

    @Check
    public void checkNewNativeTypes(Type typeRule) {
        String nativeType = typeRule.getNativeType();
        if (nativeType != null && NATIVE_TYPES_220.contains(nativeType)) {
            this.assertVersionMinimumRequirement(nativeType, CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.TYPE__NATIVE_TYPE);
        }
    }

    @Check
    public void checkCreateRole(CreateRoleStatement stmt) {
        this.assertVersionMinimumRequirement("CREATE ROLE", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.CREATE_ROLE_STATEMENT__USER_OR_ROLE);
    }

    @Check
    public void checkAlterRole(AlterRoleStatement stmt) {
        this.assertVersionMinimumRequirement("ALTER ROLE", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_OR_ROLE_REF__USER_OR_ROLE);
    }

    @Check
    public void checkDropRole(DropRoleStatement stmt) {
        this.assertVersionMinimumRequirement("DROP ROLE", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_OR_ROLE_REF__USER_OR_ROLE);
    }

    @Check
    public void checkListRoles(ListRolesStatement stmt) {
        this.assertVersionMinimumRequirement("LIST ROLES", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_OR_ROLE_REF__USER_OR_ROLE);
    }

    @Check
    public void checkGrantRole(GrantStatement stmt) {
        if (stmt.getUserOrRole() != null) {
            this.assertVersionMinimumRequirement("GRANT ROLE", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_OR_ROLE_REF__USER_OR_ROLE);
        }
    }

    @Check
    public void checkRevokeRole(RevokeStatement stmt) {
        if (stmt.getUserOrRole() != null) {
            this.assertVersionMinimumRequirement("REVOKE ROLE", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_OR_ROLE_REF__USER_OR_ROLE);
        }
    }

    @Check
    public void checkUpdateStatementIfExists(UpdateStatement stmt) {
        if (stmt.isIfExists()) {
            this.assertVersionMinimumRequirement("IF EXISTS", (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_EXISTS__IF_EXISTS, CqlConstants.CASSANDRA_2_0_13, CqlConstants.CASSANDRA_2_1_3);
        }
    }

    @Check
    public void checkDateTieredCompactionNotAvailableBefore2_0_11(MapEntry mapEntry) {
        CqlStatement stmt = ModelUtil.getCqlStatement(mapEntry);
        Property property = ModelUtil.getAncestorOfType(mapEntry, Property.class);
        String optionName = ModelUtil.termToString(mapEntry.getKey());
        String optionValue = ModelUtil.termToString(mapEntry.getValue());
        if (property == null) {
            return;
        }
        if ((stmt instanceof CreateTableStatement || stmt instanceof AlterTableStatement) && optionName.equalsIgnoreCase("'class'") && (optionValue.equalsIgnoreCase(PropertyMapValidator.DATE_TIERED_COMPACTION_STRATEGY) || optionValue.equalsIgnoreCase(PropertyMapValidator.FQN_DATE_TIERED_COMPACTION_STRATEGY))) {
            this.assertVersionMinimumRequirement("DateTieredCompactionStrategy", (EStructuralFeature)CqlPackage.Literals.MAP_ENTRY__VALUE, CqlConstants.CASSANDRA_2_0_11, CqlConstants.CASSANDRA_2_1_1);
        }
    }

    @Check
    public void checkNewerThan213(Type type) {
        if (this.isFrozenType(type) && this.isCollectionType(type.getFrozenType())) {
            this.assertVersionMinimumRequirement("Frozen collections", CqlConstants.CASSANDRA_2_1_3, (EStructuralFeature)CqlPackage.Literals.TYPE__FROZEN_TYPE);
        }
    }

    @Check
    public void checkNewerThan213(IndexColumnDef rule) {
        if (rule.isFull()) {
            this.assertVersionMinimumRequirement("FULL()", CqlConstants.CASSANDRA_2_1_3, (EStructuralFeature)CqlPackage.Literals.INDEX_COLUMN_DEF__FULL);
        }
    }

    @Check
    public void checkNewerThan210(Relation rule) {
        if (rule.isContains()) {
            this.assertVersionMinimumRequirement("CONTAINS", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.RELATION__CONTAINS);
        }
    }

    @Check
    public void checkNewewThan210(IndexEntity indexEntity) {
        IParseResult parseResult;
        String indexName = indexEntity.getName();
        if (indexName != null && indexName.startsWith("\"") && indexName.endsWith("\"")) {
            this.assertVersionMinimumRequirement("Use of quoted identifiers for index names", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.INDEX_ENTITY__NAME);
        }
        if (indexName != null && !(parseResult = this.unresKeywordLiteralParser.doParse(indexName)).hasSyntaxErrors()) {
            this.assertVersionMinimumRequirement("Use of unreserved keywords for index names", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.INDEX_ENTITY__NAME);
        }
    }

    @Check
    public void checkNewewThan210(DropIndexStatement stmt) {
        KeyspaceEntity keyspaceEntity = stmt.getKeyspace();
        if (keyspaceEntity != null && !StringUtils.isEmpty((String)keyspaceEntity.getName())) {
            this.assertVersionMinimumRequirement("Dropping an index using a keyspace qualifier", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_KEYSPACE_REF__KEYSPACE);
        }
    }

    @Check
    public void checkNewerThan210(IndexColumnDef rule) {
        String colName;
        Column colMeta;
        Table tableMeta;
        CreateIndexStatement stmt = ModelUtil.getAncestorOfType(rule, CreateIndexStatement.class);
        if (stmt != null && (tableMeta = this.getTableMeta(stmt)) != null && (colMeta = tableMeta.getColumn(ModelUtil.stripName(colName = this.getOrResolveColumnName(rule)))) != null && colMeta.getType().isCollection()) {
            this.assertVersionMinimumRequirement("Secondary indexes on collections", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN);
        }
        if (rule.isKeys()) {
            this.assertVersionMinimumRequirement("KEYS()", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.INDEX_COLUMN_DEF__KEYS);
        }
    }

    @Check
    public void checkNewerThan210(DropUserStatement stmt) {
        if (stmt.isIfExists()) {
            this.assertVersionMinimumRequirement("IF EXISTS", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_EXISTS__IF_EXISTS);
        }
    }

    @Check
    public void checkNewerThan210(CreateUserStatement stmt) {
        if (stmt.isIfNotExists()) {
            this.assertVersionMinimumRequirement("IF NOT EXISTS", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_NOT_EXISTS__IF_NOT_EXISTS);
        }
    }

    @Check
    public void checkNewerThan210(CreateTypeStatement stmt) {
        this.assertVersionMinimumRequirement("CREATE TYPE", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.CREATE_TYPE_STATEMENT__USER_TYPE);
    }

    @Check
    public void checkNewerThan210(AlterTypeStatement stmt) {
        this.assertVersionMinimumRequirement("ALTER TYPE", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TYPE_REF__USER_TYPE);
    }

    @Check
    public void checkNewerThan210(DropTypeStatement stmt) {
        this.assertVersionMinimumRequirement("DROP TYPE", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TYPE_REF__USER_TYPE);
    }

    @Check
    public void checkNewerThan210(Type typeObject) {
        if (typeObject.getTuple() != null) {
            this.assertVersionMinimumRequirement("TUPLE type", CqlConstants.CASSANDRA_2_1_0, (EStructuralFeature)CqlPackage.Literals.TYPE__TUPLE);
        }
    }

    @Check
    public void checkNewerThan207(Function functionName) {
        if ("uuid".equals(functionName.getName())) {
            this.assertVersionMinimumRequirement("uuid() function", CqlConstants.CASSANDRA_2_0_7, (EStructuralFeature)CqlPackage.Literals.FUNCTION__NAME);
        }
    }

    @Check
    public void checkNewerThan207(DeleteStatement stmt) {
        if (stmt.isIfExists()) {
            this.assertVersionMinimumRequirement("IF EXISTS", CqlConstants.CASSANDRA_2_0_7, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_EXISTS__IF_EXISTS);
        }
    }

    @Check
    public void checkNewerThan206(ColumnDef stmt) {
        if (stmt.isStaticColumn()) {
            this.assertVersionMinimumRequirement("STATIC in Create Table", CqlConstants.CASSANDRA_2_0_6, (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__STATIC_COLUMN);
        }
    }

    @Check
    public void checkNewerThan206(Relation relation) {
        if (relation.getColumns() != null && relation.getColumns().size() > 0) {
            this.assertVersionMinimumRequirement("Grouping clustering columns together in a relation", CqlConstants.CASSANDRA_2_0_6, ANNOTATE_WHOLE_INSTANCE);
        }
    }

    @Check
    public void checkNewerThan200(AlterTableStatement stmt) {
        if (stmt.getOperation().toLowerCase().equals("drop")) {
            this.assertVersionMinimumRequirement("DROP in Alter Table", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__OPERATION);
        }
    }

    @Check
    public void checkNewerThan201(SelectClause sc) {
        if (sc.isDistinct()) {
            this.assertVersionMinimumRequirement("DISTINCT keyword", CqlConstants.CASSANDRA_2_0_1, (EStructuralFeature)CqlPackage.Literals.SELECT_CLAUSE__DISTINCT);
        }
    }

    @Check
    public void checkNewerThan200(CreateTriggerStatement stmt) {
        this.assertVersionMinimumRequirement("CREATE TRIGGER", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.CREATE_TRIGGER_STATEMENT__TRIGGER);
    }

    @Check
    public void checkNewerThan200(DropTriggerStatement stmt) {
        this.assertVersionMinimumRequirement("DROP TRIGGER", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.CREATE_TRIGGER_STATEMENT__TRIGGER);
    }

    @Check
    public void checkNewerThan200(Selector sel) {
        if (sel.getAlias() != null) {
            this.assertVersionMinimumRequirement("Alias name", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.SELECTOR__ALIAS);
        }
    }

    @Check
    public void checkNewerThan200(InsertStatement stmt) {
        if (stmt.isIfNotExists()) {
            this.assertVersionMinimumRequirement("IF NOT EXISTS", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_NOT_EXISTS__IF_NOT_EXISTS);
        }
    }

    @Check
    public void checkNewerThan200(UpdateStatement stmt) {
        if (this.isConditional(stmt)) {
            this.assertVersionMinimumRequirement("IF", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__CONDITION);
        }
    }

    @Check
    public void checkNewerThan200(CreateKeyspaceStatement stmt) {
        if (stmt.isIfNotExists()) {
            this.assertVersionMinimumRequirement("IF NOT EXISTS", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_NOT_EXISTS__IF_NOT_EXISTS);
        }
    }

    @Check
    public void checkNewerThan200(CreateTableStatement stmt) {
        if (stmt.isIfNotExists()) {
            this.assertVersionMinimumRequirement("IF NOT EXISTS", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_NOT_EXISTS__IF_NOT_EXISTS);
        }
    }

    @Check
    public void checkNewerThan200(CreateIndexStatement stmt) {
        if (stmt.isIfNotExists()) {
            this.assertVersionMinimumRequirement("IF NOT EXISTS", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_NOT_EXISTS__IF_NOT_EXISTS);
        }
    }

    @Check
    public void checkNewerThan200(DropKeyspaceStatement stmt) {
        if (stmt.isIfExists()) {
            this.assertVersionMinimumRequirement("IF EXISTS", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_EXISTS__IF_EXISTS);
        }
    }

    @Check
    public void checkNewerThan200(DropTableStatement stmt) {
        if (stmt.isIfExists()) {
            this.assertVersionMinimumRequirement("IF EXISTS", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_EXISTS__IF_EXISTS);
        }
    }

    @Check
    public void checkNewerThan200(DropIndexStatement stmt) {
        if (stmt.isIfExists()) {
            this.assertVersionMinimumRequirement("IF EXISTS", CqlConstants.CASSANDRA_2_0_0, (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_IF_EXISTS__IF_EXISTS);
        }
    }

    @Check
    public void checkNewerThan121(Function functionName) {
        if (FUNCTION_NAMES_121.contains(functionName.getName())) {
            this.assertVersionMinimumRequirement(String.valueOf(functionName.getName()) + "() function", CqlConstants.CASSANDRA_1_2_1, (EStructuralFeature)CqlPackage.Literals.FUNCTION__NAME);
        }
    }

    @Check
    public void checkNewerThan121(Value value) {
        if (value.getConstant() == null) {
            return;
        }
        String constant = value.getConstant().getValue();
        if (NativeCqlDataType.FLOAT.validate(constant) && constant.toLowerCase().indexOf("e") >= 0) {
            this.assertVersionMinimumRequirement("Exponent notation in float constants", CqlConstants.CASSANDRA_1_2_1, (EStructuralFeature)CqlPackage.Literals.VALUE__CONSTANT);
        }
    }

    @Check
    public void checkNewerThan125(SelectorFunction function) {
        if (function.getFunctionName() != null && function.getFunctionName().getName().toLowerCase().equals("token")) {
            this.assertVersionMinimumRequirement("token() function in select clauses", CqlConstants.CASSANDRA_1_2_5, (EStructuralFeature)CqlPackage.Literals.SELECTOR_FUNCTION__FUNCTION_NAME);
        }
    }

    @Check
    public void checkNewerThan125(Function functionName) {
        for (SchemaFunction f : BuiltInFunctionsRegistry.getBuiltInFunctions()) {
            if (!f.isConverter() || !f.toString().equalsIgnoreCase(functionName.getName())) continue;
            this.assertVersionMinimumRequirement(f + "() function", CqlConstants.CASSANDRA_1_2_5, (EStructuralFeature)CqlPackage.Literals.FUNCTION__NAME);
            break;
        }
    }

    @Check
    public void checkNewerThan126(CreateIndexStatement stmt) {
        if (stmt.isCustom()) {
            this.assertVersionMinimumRequirement("Custom secondary indexes", CqlConstants.CASSANDRA_1_2_6, (EStructuralFeature)CqlPackage.Literals.CREATE_INDEX_STATEMENT__CUSTOM);
        }
    }

    @Check
    public void checkNewerThan128(Relation relation) {
        if (relation.getTerms() != null && relation.getTerms().size() == 0) {
            this.assertVersionMinimumRequirement("Empty IN clauses", CqlConstants.CASSANDRA_1_2_8, (EStructuralFeature)CqlPackage.Literals.RELATION__TERMS);
        }
    }

    @Check
    public void checkInsertJsonAtLeastVersion300(InsertStatement insert) {
        if (insert.getJsonInsertPart() != null) {
            this.assertVersionMinimumRequirement("Json support", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.INSERT_STATEMENT__JSON_INSERT_PART);
        }
    }

    @Check
    public void checkSelectJsonAtLeastVersion300(SelectStatement select) {
        if (select.isJsonSelect()) {
            this.assertVersionMinimumRequirement("Json support", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.SELECT_STATEMENT__JSON_SELECT);
        }
    }

    @Check
    public void checkJsonFunctionsAtLeastVersion300(Function functionName) {
        if (functionName.getName().equalsIgnoreCase("fromJson") || functionName.getName().equalsIgnoreCase("toJson")) {
            this.assertVersionMinimumRequirement("Json support", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.FUNCTION__NAME);
        }
    }

    @Check
    public void checkCreateFunctionAtLeastVersion300(FunctionDeclarationStatement create) {
        this.assertVersionMinimumRequirement("UDF support", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.FUNCTION_DECLARATION_STATEMENT__FUNCTION);
    }

    @Check
    public void checkDropFunctionAtLeastVersion300(DropFunctionStatement drop) {
        this.assertVersionMinimumRequirement("UDF support", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.DROP_FUNCTION_STATEMENT__FUNCTION);
    }

    @Check
    public void checkEntriesIndexAtLeastVersion300(IndexColumnDef index) {
        if (index.isEntries()) {
            this.assertVersionMinimumRequirement("ENTRIES()", CqlConstants.CASSANDRA_2_2_0, (EStructuralFeature)CqlPackage.Literals.INDEX_COLUMN_DEF__ENTRIES);
        }
    }

    private void assertVersionMinimumRequirement(String description, VersionNumber versionRequirement, EStructuralFeature feature) {
        this.assertVersionMinimumRequirement(description, feature, versionRequirement);
    }

    private void assertVersionMinimumRequirement(String description, EStructuralFeature feature, VersionNumber ... versionRequirements) {
        VersionNumber versionRequirement;
        CqlContext cqlContext = this.contextProvider.get(this.getCurrentObject());
        if (!cqlContext.isCurrentVersionGreaterOrEqual(versionRequirement = cqlContext.getBestMatchForCurrentVersion(versionRequirements))) {
            String versions = this.getVersionsAsString(versionRequirements);
            VersionNumber currentVersion = cqlContext.getCassandraVersion();
            String message = String.format("%s is introduced in Cassandra %s. You are currently using Cassandra %s", description, versions, currentVersion.toString());
            this.error(message, feature, "NOT_YET_SUPPORTED", new String[0]);
        }
    }

    private String getVersionsAsString(VersionNumber ... versions) {
        StringBuilder sb = new StringBuilder();
        int numVersions = versions.length;
        int index = 0;
        while (index < numVersions) {
            if (index > 0) {
                if (index < numVersions - 1) {
                    sb.append(", ");
                } else {
                    sb.append(" and ");
                }
            }
            sb.append(versions[index].getMajor()).append('.').append(versions[index].getMinor()).append('.').append(versions[index].getPatch());
            ++index;
        }
        return sb.toString();
    }
}

