/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.Relation;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TokenRelation;
import com.datastax.devcenter.cql.cql.WhereClause;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class WhereClauseValidator
extends UtilityValidator {
    private Set<String> collectEqualNames(List<Relation> relations) {
        HashSet<String> result = new HashSet<String>();
        for (Relation rel : relations) {
            if (rel.getColumn() == null || !rel.getType().equals("=")) continue;
            result.add(rel.getColumn().getName());
        }
        return result;
    }

    private Set<String> collectInNames(List<Relation> relations) {
        HashSet<String> result = new HashSet<String>();
        for (Relation rel : relations) {
            if (rel.getColumn() == null || !rel.isIn()) continue;
            result.add(rel.getColumn().getName());
        }
        return result;
    }

    @Check
    public void restrictedMoreThanOneIfIncludeEqual(WhereClause whereClause) {
        Set<String> equalNames = this.collectEqualNames((List<Relation>)whereClause.getRelations());
        HashSet<String> sawNames = new HashSet<String>();
        int i = 0;
        while (i < whereClause.getRelations().size()) {
            Relation rel = (Relation)whereClause.getRelations().get(i);
            if (rel.getColumn() != null) {
                String colName = rel.getColumn().getName();
                if (equalNames.contains(colName) && !this.isEqual(rel) || sawNames.contains(colName) && this.isEqual(rel)) {
                    this.error(String.format("%s cannot be restricted by more than one relation if it includes an Equal", ModelUtil.stripName(rel.getColumn().getName())), (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS, i, "CANNOT_BE_RESTRICTED_BY_MORE_THAN_ONE_RELATION_IF_IT_INCLUDES_AN_EQUAL", new String[0]);
                }
                if (this.isEqual(rel)) {
                    sawNames.add(colName);
                }
            }
            ++i;
        }
    }

    @Check
    public void restrictedMoreThanOneIfIncludeIn(WhereClause whereClause) {
        Set<String> inNames = this.collectInNames((List<Relation>)whereClause.getRelations());
        HashSet<String> sawNames = new HashSet<String>();
        int i = 0;
        while (i < whereClause.getRelations().size()) {
            Relation rel = (Relation)whereClause.getRelations().get(i);
            if (rel.getColumn() != null) {
                String colName = rel.getColumn().getName();
                if (inNames.contains(colName) && !this.isIn(rel) || sawNames.contains(colName) && this.isIn(rel)) {
                    this.error(String.format("%s cannot be restricted by more than one relation if it includes a IN", ModelUtil.stripName(rel.getColumn().getName())), (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS, i, "CANNOT_BE_RESTRICTED_BY_MORE_THAN_ONE_RELATION_IF_IT_INCLUDES_A_IN", new String[0]);
                }
                if (this.isIn(rel)) {
                    sawNames.add(colName);
                }
            }
            ++i;
        }
    }

    @Check
    public void nullInRelation(Relation rel) {
        if (rel.isIn() && rel.getTerms() != null) {
            int i = 0;
            while (i < rel.getTerms().size()) {
                Term term = (Term)rel.getTerms().get(i);
                if (term.getValue() != null && term.getValue().isNil()) {
                    this.error("Invalid null value for IN restriction", (EStructuralFeature)CqlPackage.Literals.RELATION__TERMS, i, "INVALID_NULL_VALUE_FOR_IN_RESTRICTION", new String[0]);
                }
                ++i;
            }
        }
    }

    @Check
    public void inOnCollection(Relation rel) {
        if (rel.isIn() && rel.getTerms() != null) {
            int i = 0;
            while (i < rel.getTerms().size()) {
                Term term = (Term)rel.getTerms().get(i);
                if (term.getValue() != null && term.getValue().getCollection() != null) {
                    this.error("Invalid IN relation on collection column", (EStructuralFeature)CqlPackage.Literals.RELATION__TERMS, i, "INVALID_IN_RELATION_ON_COLLECTION_COLUMN", new String[0]);
                }
                ++i;
            }
        }
    }

    @Check
    public void containsOnCollection(Relation rel) {
        String colName;
        Table tableMeta;
        Column colMeta;
        if (rel.isContains() && rel.getColumn() != null && (colMeta = (tableMeta = this.getTableMeta(rel)).getColumn(colName = this.getOrResolveColumnName(rel))) != null && !colMeta.getType().isCollection()) {
            this.error("Cannot use CONTAINS relation on non collection column", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_USE_CONTAINS_RELATION_ON_NON_COLLECTION_COLUMN", new String[0]);
        }
    }

    @Check
    public void checkColumnInWhere(Relation rel) {
        Table tableMeta = this.getTableMeta(rel);
        if (tableMeta == null || rel.getColumn() == null || rel.getColumn().getName() == null) {
            return;
        }
        String name = ModelUtil.stripName(rel.getColumn().getName());
        if (tableMeta.isPrimaryKeyContain(name)) {
            return;
        }
        Schema schema = this.contextProvider.get(rel).getSchemaToCheck();
        if (schema.isColumnIndexed(name)) {
            return;
        }
        CqlStatement stmt = ModelUtil.getCqlStatement(rel);
        if (stmt instanceof SelectStatement && this.isAlias((SelectStatement)stmt, name)) {
            return;
        }
        this.error("Columns used in where clauses must be part of the PRIMARY KEY or have a secondary index", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "COLUMNS_USED_IN_WHERE_CLAUSES_MUST_BE_PART_OF_THE_PRIMARY_KEY_OR_HAVE_A_SECONDARY_INDEX", new String[0]);
    }

    @Check
    public void checkInOrEqualOnly(Relation rel) {
        if (ModelUtil.getAncestorOfType(rel, SelectStatement.class) == null || rel.getColumn() == null || rel instanceof TokenRelation) {
            return;
        }
        Table tableMeta = this.getTableMeta(rel);
        if (tableMeta == null) {
            return;
        }
        if (tableMeta.isPartitionKeyContain(ModelUtil.stripName(rel.getColumn().getName())) && !rel.isIn() && !rel.getType().equals("=")) {
            this.error("In select statement, only EQ and IN relation are supported on the partition key (unless you use the token() function)", (EStructuralFeature)CqlPackage.Literals.RELATION__TYPE, "ONLY_EQ_AND_IN_RELATION_ARE_SUPPORTED_ON_THE_PARTITION_KEY_UNLESS_YOU_USE_THE_TOKEN_FUNCTION", new String[0]);
        }
    }

    @Check
    public void checkPreviousPartitionKeysAreRestricted(WhereClause whereClause) {
        Relation rel;
        Table tableMeta = this.getTableMeta(whereClause);
        List<Column> partitionKeys = tableMeta.getPartitionKeys();
        EList<Relation> rels = whereClause.getRelations();
        HashSet<String> equaled = new HashSet<String>();
        HashSet<String> allKeys = new HashSet<String>();
        for (Column pk : partitionKeys) {
            allKeys.add(pk.getName());
        }
        int idx = 0;
        while (idx < rels.size()) {
            rel = (Relation)rels.get(idx);
            if (rel.getColumn() != null && rel.getType().equals("=")) {
                equaled.add(ModelUtil.stripName(rel.getColumn().getName()));
            }
            ++idx;
        }
        idx = 0;
        while (idx < rels.size()) {
            rel = (Relation)rels.get(idx);
            if (rel.getColumn() != null) {
                this.assertPrevioiusPartitionKeyIsDeclared(partitionKeys, allKeys, equaled, ModelUtil.stripName(rel.getColumn().getName()), idx, (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS);
            }
            ++idx;
        }
    }

    private void assertPrevioiusPartitionKeyIsDeclared(List<Column> partitionKeys, Set<String> keys, Set<String> equaled, String name, int idx, EStructuralFeature feature) {
        int i = 0;
        while (i < partitionKeys.size()) {
            Column pk = partitionKeys.get(i);
            if (pk.getName().equals(name)) break;
            if (keys.contains(name) && !equaled.contains(pk.getName())) {
                this.error("A column of a partition key can be restricted only if the preceding one is restricted by an Equal relation.\nYou need to restrict " + pk.getName() + " before restrict " + name + ".", feature, idx, "A_COLUMN_OF_A_PARTITION_KEY_CAN_BE_RESTRICTED_ONLY_IF_THE_PRECEDING_ONE_IS_RESTRICTED_BY_AN_EQUAL_RELATION", new String[]{pk.getName(), pk.getType().toString()});
                break;
            }
            ++i;
        }
    }

    @Check
    public void checkPreviousClusteringKeysAreRestricted(WhereClause whereClause) {
        Relation rel;
        Table tableMeta = this.getTableMeta(whereClause);
        List<Column> clusteringKeys = tableMeta.getClusteringKeys();
        EList<Relation> rels = whereClause.getRelations();
        HashSet<String> equaled = new HashSet<String>();
        HashSet<String> allKeys = new HashSet<String>();
        for (Column ck : clusteringKeys) {
            allKeys.add(ck.getName());
        }
        int idx = 0;
        while (idx < rels.size()) {
            rel = (Relation)rels.get(idx);
            if (rel.getColumn() != null && rel.getType().equals("=")) {
                equaled.add(ModelUtil.stripName(rel.getColumn().getName()));
            }
            ++idx;
        }
        idx = 0;
        while (idx < rels.size()) {
            rel = (Relation)rels.get(idx);
            if (rel.getColumn() != null) {
                this.assertPrevioiusClusteringKeyIsDeclared(clusteringKeys, allKeys, equaled, ModelUtil.stripName(rel.getColumn().getName()), idx, (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS);
            }
            ++idx;
        }
    }

    private void assertPrevioiusClusteringKeyIsDeclared(List<Column> clusteringKeys, Set<String> keys, Set<String> equaled, String name, int idx, EStructuralFeature feature) {
        int i = 0;
        while (i < clusteringKeys.size()) {
            Column ck = clusteringKeys.get(i);
            if (ck.getName().equals(name)) break;
            if (keys.contains(name) && !equaled.contains(ck.getName())) {
                this.error("A column of a clustering key can be restricted only if the preceding one is restricted by an Equal relation.\nYou need to restrict " + ck.getName() + " before restrict " + name + ".", feature, idx, "A_COLUMN_OF_A_PARTITION_KEY_CAN_BE_RESTRICTED_ONLY_IF_THE_PRECEDING_ONE_IS_RESTRICTED_BY_AN_EQUAL_RELATION", new String[]{ck.getName(), ck.getType().toString()});
                break;
            }
            ++i;
        }
    }
}

