/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation.assignment;

import com.datastax.devcenter.cql.cql.ConstantValue;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.cql.validation.assignment.Assignment;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;

public class AssignmentTester {
    public static AssignabilityType testAssignment(Assignment assignment, CqlDataType receiverType, Schema schema, Keyspace ks) {
        AssignabilityType assignabilityType = AssignabilityType.NOT_ASSIGNABLE;
        if (assignment.getColumnType().isPresent()) {
            CqlDataType columnType = (CqlDataType)assignment.getColumnType().get();
            if (columnType.equals(receiverType)) {
                assignabilityType = AssignabilityType.EXACT_MATCH;
            } else if (receiverType.isCompatibleWith(columnType)) {
                assignabilityType = AssignabilityType.WEAKLY_ASSIGNABLE;
            }
        } else if (assignment.getTerm().isPresent()) {
            Term term = (Term)assignment.getTerm().get();
            assignabilityType = receiverType.testAssignment(term, schema, ks);
        }
        return assignabilityType;
    }

    public static AssignabilityType testAssignmentWithConstantLiteral(ConstantValue constant, CqlDataType receiverType) {
        AssignabilityType assignabilityType = AssignabilityType.EXACT_MATCH;
        assignabilityType = receiverType.isCollection() ? AssignabilityType.NOT_ASSIGNABLE : (!(receiverType instanceof NativeCqlDataType) ? AssignabilityType.WEAKLY_ASSIGNABLE : (receiverType.validate(constant.getValue()) ? AssignabilityType.WEAKLY_ASSIGNABLE : AssignabilityType.NOT_ASSIGNABLE));
        return assignabilityType;
    }
}

