/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public enum BuiltInFunction {
    TOKEN("token", -1, (CqlDataType)UnknownCqlDataType.INSTANCE, (CqlDataType)NativeCqlDataType.BLOB, false),
    NOW("now", 0, (CqlDataType)UnknownCqlDataType.INSTANCE, (CqlDataType)NativeCqlDataType.TIMEUUID, false),
    MINTIMEUUID("minTimeuuid", 1, (CqlDataType)NativeCqlDataType.TIMESTAMP, (CqlDataType)NativeCqlDataType.TIMEUUID, false),
    MAXTIMEUUID("maxTimeuuid", 1, (CqlDataType)NativeCqlDataType.TIMESTAMP, (CqlDataType)NativeCqlDataType.TIMEUUID, false),
    DATEOF("dateOf", 1, (CqlDataType)NativeCqlDataType.TIMEUUID, (CqlDataType)NativeCqlDataType.TIMESTAMP, false),
    UNIXTIMESTAMPOF("unixTimestampOf", 1, (CqlDataType)NativeCqlDataType.TIMEUUID, (CqlDataType)NativeCqlDataType.BIGINT, false),
    UUID("uuid", 0, (CqlDataType)UnknownCqlDataType.INSTANCE, (CqlDataType)NativeCqlDataType.UUID, false),
    ASCIIASBLOB("asciiAsBlob", 1, NativeCqlDataType.ASCII, NativeCqlDataType.BLOB),
    BLOBASASCII("blobAsAscii", 1, NativeCqlDataType.BLOB, NativeCqlDataType.ASCII),
    BIGINTASBLOB("bigintAsBlob", 1, NativeCqlDataType.BIGINT, NativeCqlDataType.BLOB),
    BLOBASBIGINT("blobAsBigint", 1, NativeCqlDataType.BLOB, NativeCqlDataType.BIGINT),
    BOOLEANASBLOB("booleanAsBlob", 1, NativeCqlDataType.BOOLEAN, NativeCqlDataType.BLOB),
    BLOBASBOOLEAN("blobAsBoolean", 1, NativeCqlDataType.BLOB, NativeCqlDataType.BOOLEAN),
    COUNTERASBLOB("counterAsBlob", 1, NativeCqlDataType.COUNTER, NativeCqlDataType.BLOB),
    BLOBASCOUNTER("blobAsCounter", 1, NativeCqlDataType.BLOB, NativeCqlDataType.COUNTER),
    DECIMALASBLOB("decimalAsBlob", 1, NativeCqlDataType.DECIMAL, NativeCqlDataType.BLOB),
    BLOBASDECIMAL("blobAsDecimal", 1, NativeCqlDataType.BLOB, NativeCqlDataType.DECIMAL),
    DOUBLEASBLOB("doubleAsBlob", 1, NativeCqlDataType.DOUBLE, NativeCqlDataType.BLOB),
    BLOBASDOUBLE("blobAsDouble", 1, NativeCqlDataType.BLOB, NativeCqlDataType.DOUBLE),
    FLOATASBLOB("floatAsBlob", 1, NativeCqlDataType.FLOAT, NativeCqlDataType.BLOB),
    BLOBASFLOAT("blobAsFloat", 1, NativeCqlDataType.BLOB, NativeCqlDataType.FLOAT),
    INETASBLOB("inetAsBlob", 1, NativeCqlDataType.INET, NativeCqlDataType.BLOB),
    BLOBASINET("blobAsInet", 1, NativeCqlDataType.BLOB, NativeCqlDataType.INET),
    INTASBLOB("intAsBlob", 1, NativeCqlDataType.INT, NativeCqlDataType.BLOB),
    BLOBASINT("blobAsInt", 1, NativeCqlDataType.BLOB, NativeCqlDataType.INT),
    TEXTASBLOB("textAsBlob", 1, NativeCqlDataType.TEXT, NativeCqlDataType.BLOB),
    BLOBASTEXT("blobAsText", 1, NativeCqlDataType.BLOB, NativeCqlDataType.TEXT),
    TIMESTAMPASBLOB("timestampAsBlob", 1, NativeCqlDataType.TIMESTAMP, NativeCqlDataType.BLOB),
    BLOBASTIMESTAMP("blobAsTimestamp", 1, NativeCqlDataType.BLOB, NativeCqlDataType.TIMESTAMP),
    TIMEUUIDASBLOB("timeuuidAsBlob", 1, NativeCqlDataType.TIMEUUID, NativeCqlDataType.BLOB),
    BLOBASTIMEUUID("blobAsTimeuuid", 1, NativeCqlDataType.BLOB, NativeCqlDataType.TIMEUUID),
    UUIDASBLOB("uuidAsBlob", 1, NativeCqlDataType.UUID, NativeCqlDataType.BLOB),
    BLOBASUUID("blobAsUuid", 1, NativeCqlDataType.BLOB, NativeCqlDataType.UUID),
    VARCHARASBLOB("varcharAsBlob", 1, NativeCqlDataType.VARCHAR, NativeCqlDataType.BLOB),
    BLOBASVARCHAR("blobAsVarchar", 1, NativeCqlDataType.BLOB, NativeCqlDataType.VARCHAR),
    VARINTASBLOB("varintAsBlob", 1, NativeCqlDataType.VARINT, NativeCqlDataType.BLOB),
    BLOBASVARINT("blobAsVarint", 1, NativeCqlDataType.BLOB, NativeCqlDataType.VARINT),
    TOJSON("toJson", 1, (CqlDataType)UnknownCqlDataType.INSTANCE, (CqlDataType)NativeCqlDataType.TEXT, CqlPackage.Literals.SELECTOR_FUNCTION),
    FROMJSON("fromJson", 1, (CqlDataType)UnknownCqlDataType.INSTANCE, (CqlDataType)NativeCqlDataType.TEXT, CqlPackage.Literals.TERM);

    private final String functionName;
    private final int arity;
    private final CqlDataType inputValidator;
    private final CqlDataType returnType;
    private final boolean isConverter;
    private final EClass containingStatementType;

    public static boolean isValid(String functionName) {
        try {
            return BuiltInFunction.valueOf(functionName.toUpperCase()) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private BuiltInFunction(String functionName, int argNumber, CqlDataType inputValidator, CqlDataType returnType) {
        this(functionName, argNumber, inputValidator, returnType, true);
    }

    private BuiltInFunction(String functionName, int arity, CqlDataType inputValidator, CqlDataType returnType, boolean isConverter) {
        this.functionName = functionName;
        this.arity = arity;
        this.inputValidator = inputValidator;
        this.returnType = returnType;
        this.isConverter = isConverter;
        this.containingStatementType = null;
    }

    private BuiltInFunction(String functionName, int arity, CqlDataType inputValidator, CqlDataType returnType, EClass containingStatementType) {
        this.functionName = functionName;
        this.arity = arity;
        this.inputValidator = inputValidator;
        this.returnType = returnType;
        this.isConverter = true;
        this.containingStatementType = containingStatementType;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public CqlDataType getInputValidator() {
        return this.inputValidator;
    }

    public CqlDataType getReturnType() {
        return this.returnType;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isConverter() {
        return this.isConverter;
    }

    public boolean isValidArgumentCount(int n) {
        return this.arity < 0 ? true : n == this.arity;
    }

    public boolean isInputValid(String input) {
        return this.inputValidator.validate(input);
    }

    public boolean isInputValid(Term term) {
        return this.inputValidator.validate(term);
    }

    public String toString() {
        return this.functionName;
    }

    public static boolean isValidContainingStatementType(String functionName, EObject container) {
        BuiltInFunction builtIn = BuiltInFunction.valueOf(functionName.toUpperCase());
        return builtIn.containingStatementType == null || builtIn.containingStatementType.isSuperTypeOf(container.eClass());
    }
}

