/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;

public class BuiltInFunctionsRegistry {
    private static final Map<String, List<SchemaFunction>> registeredFunctions = new HashMap<String, List<SchemaFunction>>();

    static {
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("token", null, (CqlDataType)NativeCqlDataType.BLOB, false));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("now", null, (CqlDataType)NativeCqlDataType.TIMEUUID, false));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("minTimeuuid", (CqlDataType)NativeCqlDataType.TIMESTAMP, (CqlDataType)NativeCqlDataType.TIMEUUID, false));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("maxTimeuuid", (CqlDataType)NativeCqlDataType.TIMESTAMP, (CqlDataType)NativeCqlDataType.TIMEUUID, false));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("dateOf", (CqlDataType)NativeCqlDataType.TIMEUUID, (CqlDataType)NativeCqlDataType.TIMESTAMP, false));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("unixTimestampOf", (CqlDataType)NativeCqlDataType.TIMEUUID, (CqlDataType)NativeCqlDataType.BIGINT, false));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("uuid", null, (CqlDataType)NativeCqlDataType.UUID, false));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("asciiAsBlob", NativeCqlDataType.ASCII, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsAscii", NativeCqlDataType.BLOB, NativeCqlDataType.ASCII));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("bigintAsBlob", NativeCqlDataType.BIGINT, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsBigint", NativeCqlDataType.BLOB, NativeCqlDataType.BIGINT));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("booleanAsBlob", NativeCqlDataType.BOOLEAN, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsBoolean", NativeCqlDataType.BLOB, NativeCqlDataType.BOOLEAN));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("counterAsBlob", NativeCqlDataType.COUNTER, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsCounter", NativeCqlDataType.BLOB, NativeCqlDataType.COUNTER));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("decimalAsBlob", NativeCqlDataType.DECIMAL, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsDecimal", NativeCqlDataType.BLOB, NativeCqlDataType.DECIMAL));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("doubleAsBlob", NativeCqlDataType.DOUBLE, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsDouble", NativeCqlDataType.BLOB, NativeCqlDataType.DOUBLE));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("floatAsBlob", NativeCqlDataType.FLOAT, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsFloat", NativeCqlDataType.BLOB, NativeCqlDataType.FLOAT));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("inetAsBlob", NativeCqlDataType.INET, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsInet", NativeCqlDataType.BLOB, NativeCqlDataType.INET));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("intAsBlob", NativeCqlDataType.INT, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsInt", NativeCqlDataType.BLOB, NativeCqlDataType.INT));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("textAsBlob", NativeCqlDataType.TEXT, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsText", NativeCqlDataType.BLOB, NativeCqlDataType.TEXT));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("timestampAsBlob", NativeCqlDataType.TIMESTAMP, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsTimestamp", NativeCqlDataType.BLOB, NativeCqlDataType.TIMESTAMP));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("timeuuidAsBlob", NativeCqlDataType.TIMEUUID, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsTimeuuid", NativeCqlDataType.BLOB, NativeCqlDataType.TIMEUUID));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("uuidAsBlob", NativeCqlDataType.UUID, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsUuid", NativeCqlDataType.BLOB, NativeCqlDataType.UUID));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("varcharAsBlob", NativeCqlDataType.VARCHAR, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsVarchar", NativeCqlDataType.BLOB, NativeCqlDataType.VARCHAR));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("varintAsBlob", NativeCqlDataType.VARINT, NativeCqlDataType.BLOB));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("blobAsVarint", NativeCqlDataType.BLOB, NativeCqlDataType.VARINT));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("toJson", (CqlDataType)UnknownCqlDataType.INSTANCE, (CqlDataType)NativeCqlDataType.TEXT, CqlPackage.Literals.SELECTOR_FUNCTION));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("fromJson", (CqlDataType)UnknownCqlDataType.INSTANCE, (CqlDataType)UnknownCqlDataType.INSTANCE, CqlPackage.Literals.TERM));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("sum", NativeCqlDataType.SMALLINT, NativeCqlDataType.SMALLINT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("sum", NativeCqlDataType.INT, NativeCqlDataType.INT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("sum", NativeCqlDataType.BIGINT, NativeCqlDataType.BIGINT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("sum", NativeCqlDataType.VARINT, NativeCqlDataType.VARINT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("sum", NativeCqlDataType.DECIMAL, NativeCqlDataType.DECIMAL).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("sum", NativeCqlDataType.FLOAT, NativeCqlDataType.FLOAT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("sum", NativeCqlDataType.DOUBLE, NativeCqlDataType.DOUBLE).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("avg", NativeCqlDataType.SMALLINT, NativeCqlDataType.SMALLINT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("avg", NativeCqlDataType.INT, NativeCqlDataType.INT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("avg", NativeCqlDataType.BIGINT, NativeCqlDataType.BIGINT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("avg", NativeCqlDataType.VARINT, NativeCqlDataType.VARINT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("avg", NativeCqlDataType.DECIMAL, NativeCqlDataType.DECIMAL).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("avg", NativeCqlDataType.FLOAT, NativeCqlDataType.FLOAT).aggregate(true));
        BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("avg", NativeCqlDataType.DOUBLE, NativeCqlDataType.DOUBLE).aggregate(true));
        for (NativeCqlDataType nativeType : NativeCqlDataType.getNativeTypes()) {
            if (nativeType == NativeCqlDataType.VARCHAR || nativeType == NativeCqlDataType.BLOB) continue;
            BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("max", (CqlDataType)nativeType, (CqlDataType)nativeType, CqlPackage.Literals.SELECTOR_FUNCTION).aggregate(true));
            BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("min", (CqlDataType)nativeType, (CqlDataType)nativeType, CqlPackage.Literals.SELECTOR_FUNCTION).aggregate(true));
            BuiltInFunctionsRegistry.registerFunction(BuiltInFunctionsRegistry.build("count", (CqlDataType)nativeType, (CqlDataType)NativeCqlDataType.BIGINT, CqlPackage.Literals.SELECTOR_FUNCTION).aggregate(true));
        }
    }

    public static Collection<SchemaFunction> getBuiltInFunctions() {
        ArrayList<SchemaFunction> allFunctions = new ArrayList<SchemaFunction>();
        for (List<SchemaFunction> functions : registeredFunctions.values()) {
            allFunctions.addAll(functions);
        }
        return allFunctions;
    }

    public static List<SchemaFunction> getFunctionsWithName(String functionName) {
        return registeredFunctions.get(BuiltInFunctionsRegistry.norm(functionName));
    }

    public static synchronized void registerFunction(SchemaFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("Cannot add null function");
        }
        if (function.getKeyspace() == null) {
            throw new IllegalArgumentException("Cannot add function to null keyspace");
        }
        if (function.getFunctionName() == null) {
            throw new IllegalArgumentException("Cannot add function with null name");
        }
        String functionName = function.getFunctionName().toLowerCase().trim();
        List<SchemaFunction> list = registeredFunctions.get(functionName);
        if (list == null) {
            list = new ArrayList<SchemaFunction>();
            registeredFunctions.put(functionName, list);
        }
        list.add(function);
    }

    public static boolean isValid(String functionName) {
        return registeredFunctions.get(BuiltInFunctionsRegistry.norm(functionName)) != null;
    }

    private static SchemaFunction build(String functionName, CqlDataType singleInputParameterType, CqlDataType returnType, EClass containerTypeRestriction) {
        SchemaFunction function = new SchemaFunction(functionName, -1);
        if (functionName != null) {
            function.functionName(functionName);
        }
        if (singleInputParameterType != null) {
            function.addFunctionParameter("", singleInputParameterType);
        }
        if (returnType != null) {
            function.returnType(returnType);
        }
        if (containerTypeRestriction != null) {
            function.containingStatementTypeRestriction(containerTypeRestriction);
        }
        function.setKeyspace(new Keyspace("system"));
        return function;
    }

    private static SchemaFunction build(String functionName, CqlDataType singleInputParameterType, CqlDataType returnType) {
        return BuiltInFunctionsRegistry.build(functionName, singleInputParameterType, returnType, null);
    }

    public static SchemaFunction build(String functionName, CqlDataType singleInputParameterType, CqlDataType returnType, boolean isConverter) {
        return BuiltInFunctionsRegistry.build(functionName, singleInputParameterType, returnType).converter(isConverter);
    }

    private static String norm(String function) {
        return function.toLowerCase().trim();
    }
}

