/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.KeyspaceProvider;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;

public class Column
extends AbstractSchemaElement
implements KeyspaceProvider {
    private CqlDataType type;
    private Table table;
    private Index index;
    private boolean isStatic;
    private String originalName;

    public Column(String name, CqlDataType dataType) {
        this(name, name, dataType);
    }

    public Column(String name, String originalName, CqlDataType dataType) {
        super(name);
        this.type = dataType;
        this.originalName = originalName;
    }

    public Column(String name, int scriptLineIndex, CqlDataType dataType) {
        this(name, dataType);
        this.setStatementIndex(scriptLineIndex);
    }

    @Override
    public Column deepCopy(Object parent) {
        Table parentTable = (Table)parent;
        Keyspace parentKeyspace = parentTable == null ? null : parentTable.getKeyspace();
        Column newColumn = new Column(this.name, this.statementIndex, this.type.deepCopy(parentKeyspace));
        newColumn.setTable(parentTable);
        newColumn.setStatic(this.isStatic);
        newColumn.setIndex(null);
        return newColumn;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @Override
    public Keyspace getKeyspace() {
        return this.table.getKeyspace();
    }

    public Table getTable() {
        return this.table;
    }

    protected void setTable(Table table) {
        this.table = table;
        this.firePropertyChange("table", this.table, this.table);
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
        this.firePropertyChange("index", this.index, this.index);
    }

    public void dropIndex() {
        this.index = null;
    }

    public CqlDataType getType() {
        return this.type;
    }

    public void setType(CqlDataType type) {
        this.type = type;
        this.firePropertyChange("type", this.type, this.type);
    }

    public boolean isCounter() {
        return this.type == NativeCqlDataType.COUNTER;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        this.firePropertyChange("static", this.isStatic, this.isStatic);
    }

    public boolean isPrimaryKey() {
        return this.table.getPrimaryKeys().contains(this);
    }

    public void setPrimaryKey(boolean primaryKey) {
        boolean oldValue = this.isPrimaryKey();
        if (primaryKey) {
            this.table.addPrimaryKey(this);
        } else {
            this.table.removePrimaryKey(this);
        }
        this.firePropertyChange("primaryKey", oldValue, primaryKey);
    }

    public boolean isPartitionKey() {
        return this.table.getPartitionKeys().contains(this);
    }

    public boolean isClusteringColumn() {
        return this.table.getClusteringKeys().contains(this);
    }

    public Table.ClusteringOrder getClusteringOrder() {
        return this.table.getClusteringOrder(this.getName());
    }

    public void setClusteringOrder(Table.ClusteringOrder order) {
        Table.ClusteringOrder oldValue = this.getClusteringOrder();
        this.table.addClusteringOrder(this.getName(), order);
        this.firePropertyChange("clusteringOrder", (Object)oldValue, (Object)order);
    }

    public String toString() {
        return String.format("column: %s %s #%d", this.name, this.type, this.statementIndex);
    }
}

