/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.KeyspaceProvider;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.types.CqlDataType;

public class FunctionParameter
extends AbstractSchemaElement
implements KeyspaceProvider {
    private SchemaFunction function;
    private CqlDataType type;
    private String originalName;

    public FunctionParameter(String name, CqlDataType dataType) {
        this(name, name, dataType);
    }

    public FunctionParameter(String name, String originalName, CqlDataType dataType) {
        super(name);
        this.type = dataType;
        this.originalName = originalName;
    }

    public FunctionParameter(String name, int scriptLineIndex, CqlDataType dataType) {
        this(name, dataType);
        this.setStatementIndex(scriptLineIndex);
    }

    @Override
    public FunctionParameter deepCopy(Object parent) {
        SchemaFunction parentFunction = (SchemaFunction)parent;
        Keyspace parentKeyspace = parentFunction == null ? null : parentFunction.getKeyspace();
        FunctionParameter newParameter = new FunctionParameter(this.name, this.statementIndex, this.type.deepCopy(parentKeyspace));
        newParameter.setFunction(parentFunction);
        return newParameter;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @Override
    public Keyspace getKeyspace() {
        return this.function.getKeyspace();
    }

    public SchemaFunction getFunction() {
        return this.function;
    }

    protected void setFunction(SchemaFunction function) {
        this.function = function;
        this.firePropertyChange("function", this.function, this.function);
    }

    public CqlDataType getType() {
        return this.type;
    }

    public void setType(CqlDataType type) {
        this.type = type;
        this.firePropertyChange("type", this.type, this.type);
    }

    public String toString() {
        return String.format("parameter: %s %s #%d", this.name, this.type, this.statementIndex);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionParameter other = (FunctionParameter)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

