/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.KeyspaceProvider;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;

public class Index
extends AbstractSchemaElement
implements KeyspaceProvider {
    private IndexDefinition definition = new IndexDefinition();

    public Index(String name) {
        super(name);
    }

    public Index(String name, int scriptLineIndex) {
        this(name);
        this.setStatementIndex(scriptLineIndex);
    }

    public Column getColumn() {
        return this.definition.column;
    }

    public void setColumn(Column column) {
        Column column2 = this.definition.column;
        Column column3 = column;
        this.definition.column = column3;
        this.firePropertyChange("column", column2, column3);
    }

    public String getCustomClassName() {
        return this.definition.customClassName;
    }

    public Index setCustomClassName(String customClassName) {
        String string = this.definition.customClassName;
        String string2 = customClassName;
        this.definition.customClassName = string2;
        this.firePropertyChange("customClassName", string, string2);
        return this;
    }

    public boolean isFull() {
        return this.definition.full;
    }

    public void setFull(boolean full) {
        this.definition.full = full;
    }

    public boolean isKeys() {
        return this.definition.keys;
    }

    public void setKeys(boolean keys) {
        this.definition.keys = keys;
    }

    public void setEntries(boolean entries) {
        this.definition.entries = entries;
    }

    public boolean isEntries() {
        return this.definition.entries;
    }

    public boolean isCustom() {
        return this.definition.customClassName != null;
    }

    public void setDefinition(IndexDefinition definition) {
        this.definition = definition;
    }

    public IndexDefinition getDefinition() {
        return this.definition;
    }

    public String getColumnDefinition() {
        String columnName = ModelUtil.escapeName(((IndexDefinition)this.definition).column.name);
        if (this.isKeys()) {
            return String.format("KEYS(%s)", columnName);
        }
        if (this.isFull()) {
            return String.format("FULL(%s)", columnName);
        }
        if (this.isEntries()) {
            return String.format("ENTRIES(%s)", columnName);
        }
        return columnName;
    }

    @Override
    public Keyspace getKeyspace() {
        return this.definition.column.getKeyspace();
    }

    @Override
    public Index deepCopy(Object parent) {
        String indexColumnTableName;
        Table newTable;
        String indexColumnKeyspaceName;
        Keyspace newKeyspace;
        Schema parentSchema = (Schema)parent;
        Column newIndexColumn = null;
        if (this.definition.column != null && this.definition.column.getTable() != null && this.definition.column.getTable().getKeyspace() != null && (newKeyspace = parentSchema.getKeyspace(indexColumnKeyspaceName = this.definition.column.getTable().getKeyspace().getName())) != null && (newTable = newKeyspace.getTable(indexColumnTableName = this.definition.column.getTable().getName())) != null) {
            newIndexColumn = newTable.getColumn(this.definition.column.getName());
        }
        Index newIndex = new Index(this.name, this.statementIndex);
        newIndex.setColumn(newIndexColumn);
        newIndex.setCustomClassName(this.definition.customClassName);
        newIndex.setKeys(this.definition.keys);
        newIndex.setFull(this.definition.full);
        newIndex.setEntries(this.definition.entries);
        if (newIndexColumn != null) {
            newIndexColumn.setIndex(newIndex);
        }
        return newIndex;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.definition.column == null ? 0 : this.definition.column.hashCode());
        result = 31 * result + (this.definition.column == null || this.definition.column.getTable() == null ? 0 : this.definition.column.getTable().hashCode());
        result = 31 * result + (this.definition.column == null || this.definition.column.getKeyspace() == null ? 0 : this.definition.column.getKeyspace().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Index other = (Index)obj;
        if (this.definition.column == null ? other.definition.column != null : !this.definition.column.equals(other.definition.column)) {
            return false;
        }
        if (this.definition.column.getTable() == null ? other.definition.column.getTable() != null : !this.definition.column.getTable().equals(other.definition.column.getTable())) {
            return false;
        }
        return !(this.definition.column.getKeyspace() == null ? other.definition.column.getKeyspace() != null : !this.definition.column.getKeyspace().equals(other.definition.column.getKeyspace()));
    }

    public String toString() {
        return String.format("index: %s #%d", this.name, this.statementIndex);
    }

    public static class IndexDefinition {
        private Column column;
        private String customClassName;
        private boolean full;
        private boolean keys;
        private boolean entries;

        public void setColumn(Column column) {
            this.column = column;
        }

        public Column getColumn() {
            return this.column;
        }

        public void setCustomClassName(String customClassName) {
            this.customClassName = customClassName;
        }

        public String getCustomClassName() {
            return this.customClassName;
        }

        public void setFull(boolean full) {
            this.full = full;
        }

        public boolean isFull() {
            return this.full;
        }

        public void setKeys(boolean keys) {
            this.keys = keys;
        }

        public boolean isKeys() {
            return this.keys;
        }

        public void setEntries(boolean entries) {
            this.entries = entries;
        }

        public boolean isEntries() {
            return this.entries;
        }
    }
}

