/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.ITableElement;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Indices
extends AbstractSchemaElement
implements ITableElement,
Iterable<Index>,
List<Index> {
    private List<Index> indices = Collections.synchronizedList(new ArrayList());
    private Keyspace keyspace;
    private Table table;

    public Indices(String name) {
        super(name);
    }

    @Override
    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    @Override
    public void setKeyspace(Keyspace keyspace) {
        this.keyspace = keyspace;
        this.firePropertyChange("keyspace", this.keyspace, this.keyspace);
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void setTable(Table table) {
        this.table = table;
        this.firePropertyChange("table", this.table, this.table);
    }

    public List<Index> getIndices() {
        return this;
    }

    public void setIndices(List<Index> indices) {
        this.indices = indices;
    }

    @Override
    public Indices deepCopy(Object parent) {
        ArrayList<Index> copy = new ArrayList<Index>(this.indices.size());
        for (Index index : this.indices) {
            copy.add(index.deepCopy(parent));
        }
        Indices indicesClone = new Indices(this.name);
        indicesClone.indices = copy;
        indicesClone.keyspace = this.keyspace != null ? this.keyspace.deepCopy(this.keyspace.getSchema()) : null;
        indicesClone.table = this.table != null ? this.table.deepCopy(this.table.getKeyspace()) : null;
        return indicesClone;
    }

    @Override
    public Iterator<Index> iterator() {
        return this.indices.iterator();
    }

    @Override
    public int size() {
        return this.indices.size();
    }

    @Override
    public boolean isEmpty() {
        return this.indices.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.indices.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.indices.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.indices.toArray(a);
    }

    @Override
    public boolean add(Index e) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        boolean result = this.indices.add(e);
        if (result) {
            this.firePropertyChange("indices", oldIndices, this.indices);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        boolean result = this.indices.remove(o);
        if (result) {
            this.firePropertyChange("indices", oldIndices, this.indices);
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.indices.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Index> c) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        boolean result = this.indices.addAll(c);
        if (result) {
            this.firePropertyChange("indices", oldIndices, this.indices);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Index> c) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        boolean result = this.indices.addAll(index, c);
        if (result) {
            this.firePropertyChange("indices", oldIndices, this.indices);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        boolean result = this.indices.removeAll(c);
        if (result) {
            this.firePropertyChange("indices", oldIndices, this.indices);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        boolean result = this.indices.retainAll(c);
        if (result) {
            this.firePropertyChange("indices", oldIndices, this.indices);
        }
        return result;
    }

    @Override
    public void clear() {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        this.indices.clear();
        this.firePropertyChange("indices", oldIndices, this.indices);
    }

    @Override
    public boolean equals(Object o) {
        return this.indices.equals(o);
    }

    @Override
    public int hashCode() {
        return this.indices.hashCode();
    }

    @Override
    public Index get(int index) {
        return this.indices.get(index);
    }

    @Override
    public Index set(int index, Index element) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        Index result = this.indices.set(index, element);
        this.firePropertyChange("indices", oldIndices, this.indices);
        return result;
    }

    @Override
    public void add(int index, Index element) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        this.indices.add(index, element);
        this.firePropertyChange("indices", oldIndices, this.indices);
    }

    @Override
    public Index remove(int index) {
        ArrayList<Index> oldIndices = new ArrayList<Index>(this.indices);
        Index result = this.indices.remove(index);
        this.firePropertyChange("indices", oldIndices, this.indices);
        return result;
    }

    @Override
    public int indexOf(Object o) {
        return this.indices.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indices.lastIndexOf(o);
    }

    @Override
    public ListIterator<Index> listIterator() {
        return this.indices.listIterator();
    }

    @Override
    public ListIterator<Index> listIterator(int index) {
        return this.indices.listIterator(index);
    }

    @Override
    public List<Index> subList(int fromIndex, int toIndex) {
        return this.indices.subList(fromIndex, toIndex);
    }
}

