/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.schema.AbstractKeyspaceSchemaElement;
import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.options.KeyspaceOptions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Keyspace
extends AbstractSchemaElement {
    public static final Set<String> SYSTEM_KEYSPACES = ImmutableSet.of((Object)"system", (Object)"system_traces", (Object)"dse_system", (Object)"OpsCenter", (Object)"system_auth", (Object)"system_distributed", (Object[])new String[0]);
    private Schema schema;
    private final List<Table> tables = Collections.synchronizedList(new ArrayList());
    private final List<UserType> userTypes = Collections.synchronizedList(new ArrayList());
    private final Set<SchemaFunction> functions = Collections.newSetFromMap(new ConcurrentHashMap());
    private KeyspaceOptions options = new KeyspaceOptions();
    private boolean isSystemKeyspace;

    public static String availableUserTypeName(Keyspace keyspace, String base) {
        String name;
        int i = 1;
        do {
            name = String.valueOf(base) + i;
        } while (keyspace != null && keyspace.getUserType(String.valueOf(base) + i++) != null);
        return name;
    }

    public static String availableTableName(Keyspace keyspace, String base) {
        String name;
        int i = 1;
        do {
            name = String.valueOf(base) + i;
        } while (keyspace != null && keyspace.getTable(String.valueOf(base) + i++) != null);
        return name;
    }

    public Keyspace(String name) {
        super(name);
        this.isSystemKeyspace = SYSTEM_KEYSPACES.contains(name);
    }

    public Keyspace(String name, int scriptLineIndex) {
        this(name);
        this.setStatementIndex(scriptLineIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Keyspace deepCopy(Object parent) {
        Schema parentSchema = (Schema)parent;
        Keyspace newKeyspace = new Keyspace(this.name, this.getStatementIndex());
        newKeyspace.setSchema(parentSchema);
        newKeyspace.options = this.options == null ? null : this.options.deepCopy();
        Collection<AbstractKeyspaceSchemaElement> collection = this.userTypes;
        synchronized (collection) {
            for (UserType userTypeMeta : this.userTypes) {
                newKeyspace.addUserType(userTypeMeta.deepCopy(newKeyspace));
            }
        }
        collection = this.functions;
        synchronized (collection) {
            for (SchemaFunction function : this.functions) {
                newKeyspace.addFunction(function.deepCopy(newKeyspace));
            }
        }
        collection = this.tables;
        synchronized (collection) {
            for (Table tableMeta : this.tables) {
                newKeyspace.addTable(tableMeta.deepCopy(newKeyspace));
            }
        }
        return newKeyspace;
    }

    public boolean isSystemKeyspace() {
        return this.isSystemKeyspace;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Keyspace setSchema(Schema parent) {
        this.schema = parent;
        return this;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTable(String name) {
        Table result = null;
        if (name != null) {
            List<Table> list = this.tables;
            synchronized (list) {
                for (Table tableMeta : this.tables) {
                    if (!name.equals(tableMeta.getName())) continue;
                    result = tableMeta;
                    break;
                }
            }
        }
        return result;
    }

    public Keyspace addTable(Table table) {
        this.tables.remove(table);
        this.tables.add(table);
        table.setKeyspace(this);
        Metrics.setGaugeValue((String)"table_count", (int)this.tables.size());
        return this;
    }

    public Keyspace removeTable(String name) {
        Table table = this.getTable(name);
        if (table != null) {
            this.removeTable(table);
        }
        Metrics.setGaugeValue((String)"table_count", (int)this.tables.size());
        return this;
    }

    public Keyspace removeTable(Table table) {
        this.tables.remove(table);
        return this;
    }

    public List<UserType> getUserTypes() {
        return this.userTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserType getUserType(String name) {
        UserType result = null;
        if (name != null) {
            List<UserType> list = this.userTypes;
            synchronized (list) {
                for (UserType userTypeMeta : this.userTypes) {
                    if (!name.equals(userTypeMeta.getName())) continue;
                    result = userTypeMeta;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaFunction getFunction(SchemaFunction function) {
        SchemaFunction result = null;
        if (function != null) {
            Set<SchemaFunction> set = this.functions;
            synchronized (set) {
                for (SchemaFunction next : this.getFunctions()) {
                    if (!function.equals(next)) continue;
                    result = next;
                    break;
                }
            }
        }
        return result;
    }

    public Keyspace addUserType(UserType userType) {
        this.userTypes.remove(userType);
        this.userTypes.add(userType);
        userType.setKeyspace(this);
        Metrics.setGaugeValue((String)"udt_count", (int)this.userTypes.size());
        return this;
    }

    public Keyspace removeUserType(String name) {
        UserType userType = this.getUserType(name);
        if (userType != null) {
            this.removeUserType(userType);
        }
        Metrics.setGaugeValue((String)"udt_count", (int)this.userTypes.size());
        return this;
    }

    public Keyspace removeUserType(UserType userType) {
        this.userTypes.remove(userType);
        return this;
    }

    public KeyspaceOptions getOptions() {
        return this.options;
    }

    public void setOptions(KeyspaceOptions options) {
        this.options = options;
        this.firePropertyChange("options", this.options, this.options);
    }

    public Keyspace addFunction(SchemaFunction function) {
        this.functions.remove(function);
        this.functions.add(function);
        this.countUDFs(function);
        return this;
    }

    public void removeFunction(SchemaFunction function) {
        this.functions.remove(function);
        this.countUDFs(function);
    }

    public Set<SchemaFunction> getFunctions() {
        return new HashSet<SchemaFunction>(this.functions);
    }

    public List<SchemaFunction> findMatchingFunctions(String name) {
        ArrayList<SchemaFunction> matchingFunctions = new ArrayList<SchemaFunction>();
        if (name == null) {
            return matchingFunctions;
        }
        for (SchemaFunction f : this.getFunctions()) {
            if (!name.equals(f.getFunctionName())) continue;
            matchingFunctions.add(f);
        }
        return matchingFunctions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(String.format("ks: %s #%d", this.name, this.statementIndex)) + "\n");
        String cfIndent = "  ";
        Collection<AbstractKeyspaceSchemaElement> collection = this.tables;
        synchronized (collection) {
            for (Table cf : this.tables) {
                sb.append(String.valueOf(cfIndent) + cf.toString() + "\n");
            }
        }
        collection = this.userTypes;
        synchronized (collection) {
            for (UserType userType : this.userTypes) {
                sb.append(String.valueOf(cfIndent) + userType.toString() + "\n");
            }
        }
        collection = this.functions;
        synchronized (collection) {
            for (SchemaFunction function : this.functions) {
                sb.append(String.valueOf(cfIndent) + function.toString() + "\n");
            }
        }
        return sb.toString();
    }

    private void countUDFs(SchemaFunction function) {
        int scalarFunctionCount = 0;
        int aggregateFunctionCount = 0;
        for (SchemaFunction f : this.functions) {
            if (f.isAggregate()) {
                ++aggregateFunctionCount;
                continue;
            }
            ++scalarFunctionCount;
        }
        function.setKeyspace(this);
        Metrics.setGaugeValue((String)"udf_count", (int)scalarFunctionCount);
        Metrics.setGaugeValue((String)"aggregate_udf_count", (int)aggregateFunctionCount);
    }
}

