/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.services.CqlGrammarAccess;
import com.datastax.devcenter.json.services.JsonGrammarAccess;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.xtext.IGrammarAccess;

public enum Keyword {
    SELECT("SELECT", CqlGrammarAccess.K_SELECTElements.class, true),
    FROM("FROM", CqlGrammarAccess.K_FROMElements.class, true),
    AS("AS", CqlGrammarAccess.K_ASCElements.class, false),
    WHERE("WHERE", CqlGrammarAccess.K_WHEREElements.class, true),
    AND("AND", CqlGrammarAccess.K_ANDElements.class, true),
    KEY("KEY", CqlGrammarAccess.K_KEYElements.class, false),
    INSERT("INSERT", CqlGrammarAccess.K_INSERTElements.class, true),
    UPDATE("UPDATE", CqlGrammarAccess.K_UPDATEElements.class, true),
    WITH("WITH", CqlGrammarAccess.K_WITHElements.class, true),
    LIMIT("LIMIT", CqlGrammarAccess.K_LIMITElements.class, true),
    USING("USING", CqlGrammarAccess.K_USINGElements.class, true),
    USE("USE", CqlGrammarAccess.K_USEElements.class, true),
    DISTINCT("DISTINCT", CqlGrammarAccess.K_DISTINCTElements.class, false),
    COUNT("COUNT", CqlGrammarAccess.K_COUNTElements.class, false),
    SET("SET", CqlGrammarAccess.K_SETElements.class, true),
    BEGIN("BEGIN", CqlGrammarAccess.K_BEGINElements.class, true),
    UNLOGGED("UNLOGGED", CqlGrammarAccess.K_UNLOGGEDElements.class, true),
    BATCH("BATCH", CqlGrammarAccess.K_BATCHElements.class, true),
    APPLY("APPLY", CqlGrammarAccess.K_APPLYElements.class, true),
    TRUNCATE("TRUNCATE", CqlGrammarAccess.K_TRUNCATEElements.class, true),
    DELETE("DELETE", CqlGrammarAccess.K_DELETEElements.class, true),
    IN("IN", CqlGrammarAccess.K_INElements.class, true),
    CREATE("CREATE", CqlGrammarAccess.K_CREATEElements.class, true),
    KEYSPACE("KEYSPACE", CqlGrammarAccess.K_KEYSPACEElements.class, true),
    SCHEMA("SCHEMA", CqlGrammarAccess.K_KEYSPACEElements.class, true),
    KEYSPACES("KEYSPACES", CqlGrammarAccess.K_KEYSPACESElements.class, true),
    TABLE("TABLE", CqlGrammarAccess.K_TABLEElements.class, true),
    COLUMNFAMILY("COLUMNFAMILY", CqlGrammarAccess.K_TABLEElements.class, true),
    INDEX("INDEX", CqlGrammarAccess.K_INDEXElements.class, true),
    CUSTOM("CUSTOM", CqlGrammarAccess.K_CUSTOMElements.class, false),
    ON("ON", CqlGrammarAccess.K_ONElements.class, true),
    TO("TO", CqlGrammarAccess.K_TOElements.class, true),
    DROP("DROP", CqlGrammarAccess.K_DROPElements.class, true),
    PRIMARY("PRIMARY", CqlGrammarAccess.K_PRIMARYElements.class, true),
    INTO("INTO", CqlGrammarAccess.K_INTOElements.class, true),
    VALUES("VALUES", CqlGrammarAccess.K_VALUESElements.class, false),
    TIMESTAMP("TIMESTAMP", CqlGrammarAccess.K_TIMESTAMPElements.class, true),
    TTL("TTL", CqlGrammarAccess.K_TTLElements.class, false),
    ALTER("ALTER", CqlGrammarAccess.K_ALTERElements.class, true),
    RENAME("RENAME", CqlGrammarAccess.K_RENAMEElements.class, true),
    ADD("ADD", CqlGrammarAccess.K_ADDElements.class, true),
    TYPE("TYPE", CqlGrammarAccess.K_TYPEElements.class, false),
    COMPACT("COMPACT", CqlGrammarAccess.K_COMPACTElements.class, false),
    STORAGE("STORAGE", CqlGrammarAccess.K_STORAGEElements.class, false),
    ORDER("ORDER", CqlGrammarAccess.K_ORDERElements.class, true),
    BY("BY", CqlGrammarAccess.K_BYElements.class, true),
    ASC("ASC", CqlGrammarAccess.K_ASCElements.class, true),
    DESC("DESC", CqlGrammarAccess.K_DESCElements.class, true),
    ALLOW("ALLOW", CqlGrammarAccess.K_ALLOWElements.class, true),
    FILTERING("FILTERING", CqlGrammarAccess.K_FILTERINGElements.class, true),
    IF("IF", CqlGrammarAccess.K_IFElements.class, true),
    STATIC("STATIC", CqlGrammarAccess.K_STATICElements.class, false),
    GRANT("GRANT", CqlGrammarAccess.K_GRANTElements.class, true),
    ALL("ALL", CqlGrammarAccess.K_ALLElements.class, false),
    PERMISSION("PERMISSION", CqlGrammarAccess.K_PERMISSIONElements.class, false),
    PERMISSIONS("PERMISSIONS", CqlGrammarAccess.K_PERMISSIONSElements.class, false),
    OF("OF", CqlGrammarAccess.K_OFElements.class, true),
    REVOKE("REVOKE", CqlGrammarAccess.K_REVOKEElements.class, true),
    MODIFY("MODIFY", CqlGrammarAccess.K_MODIFYElements.class, true),
    AUTHORIZE("AUTHORIZE", CqlGrammarAccess.K_AUTHORIZEElements.class, true),
    NORECURSIVE("NORECURSIVE", CqlGrammarAccess.K_NORECURSIVEElements.class, true),
    USER("USER", CqlGrammarAccess.K_USERElements.class, false),
    USERS("USERS", CqlGrammarAccess.K_USERSElements.class, false),
    SUPERUSER("SUPERUSER", CqlGrammarAccess.K_SUPERUSERElements.class, false),
    NOSUPERUSER("NOSUPERUSER", CqlGrammarAccess.K_NOSUPERUSERElements.class, false),
    PASSWORD("PASSWORD", CqlGrammarAccess.K_PASSWORDElements.class, false),
    CLUSTERING("CLUSTERING", CqlGrammarAccess.K_CLUSTERINGElements.class, false),
    ASCII("ascii", CqlGrammarAccess.K_ASCIIElements.class, false),
    BIGINT("bigint", CqlGrammarAccess.K_BIGINTElements.class, false),
    BLOB("blob", CqlGrammarAccess.K_BLOBElements.class, false),
    BOOLEAN("boolean", CqlGrammarAccess.K_BOOLEANElements.class, false),
    COUNTER("counter", CqlGrammarAccess.K_COUNTERElements.class, false),
    DECIMAL("decimal", CqlGrammarAccess.K_DECIMALElements.class, false),
    DOUBLE("double", CqlGrammarAccess.K_DOUBLEElements.class, false),
    FLOAT("float", CqlGrammarAccess.K_FLOATElements.class, false),
    INET("inet", CqlGrammarAccess.K_INETElements.class, false),
    INT("int", CqlGrammarAccess.K_INTElements.class, false),
    TEXT("text", CqlGrammarAccess.K_TEXTElements.class, false),
    UUID("uuid", CqlGrammarAccess.K_UUIDElements.class, false),
    VARCHAR("varchar", CqlGrammarAccess.K_VARCHARElements.class, false),
    VARINT("varint", CqlGrammarAccess.K_VARINTElements.class, false),
    TIMEUUID("timeuuid", CqlGrammarAccess.K_TIMEUUIDElements.class, false),
    TOKEN("token", CqlGrammarAccess.K_TOKENElements.class, true),
    WRITETIME("writetime", CqlGrammarAccess.K_WRITETIMEElements.class, false),
    NULL("null", JsonGrammarAccess.K_NULLElements.class, true),
    NOT("NOT", CqlGrammarAccess.K_NOTElements.class, true),
    EXISTS("EXISTS", CqlGrammarAccess.K_EXISTSElements.class, true),
    MAP("map", CqlGrammarAccess.K_MAPElements.class, true),
    LIST("list", CqlGrammarAccess.K_LISTElements.class, true),
    NAN("NaN", CqlGrammarAccess.K_NANElements.class, true),
    INFINITY("infinity", CqlGrammarAccess.K_INFINITYElements.class, true),
    TRIGGER("TRIGGER", CqlGrammarAccess.K_TRIGGERElements.class, true);

    private final String name;
    private final Class<? extends IGrammarAccess.IParserRuleAccess> parserAccessClass;
    private final boolean reserved;
    private static final Set<Keyword> statementFirstSet;

    static {
        statementFirstSet = new HashSet<Keyword>(Arrays.asList(SELECT, INSERT, UPDATE, BATCH, DELETE, USE, TRUNCATE, CREATE, DROP, ALTER, GRANT, REVOKE, LIST));
    }

    private Keyword(String name, Class<? extends IGrammarAccess.IParserRuleAccess> parserAccessClass, boolean reserved) {
        this.name = name;
        this.parserAccessClass = parserAccessClass;
        this.reserved = reserved;
    }

    public String toString() {
        return this.name;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public boolean isStartingKeyword() {
        return statementFirstSet.contains((Object)this);
    }

    public boolean matches(String keyword) {
        if (keyword == null) {
            return false;
        }
        return keyword.equalsIgnoreCase(this.name);
    }

    public boolean matches(Type type) {
        if (type == null || type.getNativeType() == null) {
            return false;
        }
        return type.getNativeType().equalsIgnoreCase(this.name);
    }
}

