/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;

public enum Permission {
    CREATE,
    ALTER,
    DROP,
    SELECT,
    MODIFY,
    AUTHORIZE,
    DESCRIBE,
    EXECUTE;

    public static final Set<Permission> ALL;
    public static final Set<Permission> NONE;
    public static final Set<Permission> KEYSPACE_LEVEL_PERMISSIONS;
    public static final Set<Permission> TABLE_LEVEL_PERMISSIONS;
    public static final Set<Permission> MULTIPLE_FUNCTION_PERMISSIONS;
    public static final Set<Permission> SINGLE_FUNCTION_PERMISSIONS;
    public static final Set<Permission> MULTIPLE_ROLE_PERMISSIONS;
    public static final Set<Permission> SINGLE_ROLE_PERMISSIONS;

    static {
        ALL = Sets.immutableEnumSet(EnumSet.range(CREATE, EXECUTE));
        NONE = ImmutableSet.of();
        KEYSPACE_LEVEL_PERMISSIONS = Sets.immutableEnumSet((Enum)CREATE, (Enum[])new Permission[]{ALTER, DROP, SELECT, MODIFY, AUTHORIZE});
        TABLE_LEVEL_PERMISSIONS = Sets.immutableEnumSet((Enum)ALTER, (Enum[])new Permission[]{DROP, SELECT, MODIFY, AUTHORIZE});
        MULTIPLE_FUNCTION_PERMISSIONS = Sets.immutableEnumSet((Enum)CREATE, (Enum[])new Permission[]{ALTER, DROP, AUTHORIZE, EXECUTE});
        SINGLE_FUNCTION_PERMISSIONS = Sets.immutableEnumSet((Enum)ALTER, (Enum[])new Permission[]{DROP, AUTHORIZE, EXECUTE});
        MULTIPLE_ROLE_PERMISSIONS = Sets.immutableEnumSet((Enum)CREATE, (Enum[])new Permission[]{ALTER, DROP, AUTHORIZE, DESCRIBE});
        SINGLE_ROLE_PERMISSIONS = Sets.immutableEnumSet((Enum)ALTER, (Enum[])new Permission[]{DROP, AUTHORIZE});
    }
}

