/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Indices;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.Trigger;
import com.datastax.devcenter.schema.User;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Schema
extends AbstractSchemaElement {
    private final List<Keyspace> keyspaces = Collections.synchronizedList(new ArrayList());
    private final Indices indices;
    private final List<User> users;
    private final List<Trigger> triggers;
    private String defaultKeyspaceName = "";
    private String currentKeyspaceName = "";

    public static String availableKeyspaceName(Schema schema, String base) {
        String name;
        int i = 1;
        do {
            name = String.valueOf(base) + i;
        } while (schema != null && schema.getKeyspace(String.valueOf(base) + i++) != null);
        return name;
    }

    public Schema(String name) {
        super(name);
        this.indices = new Indices(name);
        this.users = Collections.synchronizedList(new ArrayList());
        this.triggers = Collections.synchronizedList(new ArrayList());
    }

    public Schema(String name, int statementIndex) {
        this(name);
        this.setStatementIndex(statementIndex);
    }

    @Override
    public Schema deepCopy(Object parent) {
        Schema newSchema = new Schema(this.name, this.getStatementIndex());
        for (Keyspace ks : this.keyspaces) {
            newSchema.addKeyspace(ks.deepCopy(newSchema));
        }
        for (Index index : this.indices) {
            newSchema.addIndex(index.deepCopy(newSchema));
        }
        for (Trigger trigger : this.triggers) {
            newSchema.addTrigger(trigger.deepCopy(newSchema));
        }
        for (User user : this.users) {
            newSchema.addUser(user.deepCopy(newSchema));
        }
        newSchema.setDefaultKeyspaceName(this.defaultKeyspaceName);
        newSchema.setCurrentKeyspaceName(this.currentKeyspaceName);
        return newSchema;
    }

    public void setDefaultKeyspaceName(String keyspaceName) {
        Keyspace keyspace = this.getKeyspace(keyspaceName);
        if (keyspace != null) {
            this.defaultKeyspaceName = keyspaceName;
        }
    }

    public String getDefaultKeyspaceName() {
        return this.defaultKeyspaceName == null || this.defaultKeyspaceName.length() == 0 ? "" : this.defaultKeyspaceName;
    }

    public Keyspace getDefaultKeyspace() {
        return this.getKeyspace(this.getDefaultKeyspaceName());
    }

    public Schema setCurrentKeyspaceName(String keyspaceName) {
        Keyspace keyspace = this.getKeyspace(keyspaceName);
        if (keyspace != null) {
            this.currentKeyspaceName = keyspaceName;
        }
        return this;
    }

    public String getCurrentKeyspaceName() {
        return this.currentKeyspaceName == null || this.currentKeyspaceName.length() == 0 ? this.defaultKeyspaceName : this.currentKeyspaceName;
    }

    public Keyspace getCurrentKeyspace() {
        return this.getKeyspace(this.getCurrentKeyspaceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keyspace getKeyspace(String keyspaceName) {
        Keyspace result = null;
        if (keyspaceName != null) {
            List<Keyspace> list = this.keyspaces;
            synchronized (list) {
                for (Keyspace ks : this.keyspaces) {
                    if (!keyspaceName.equals(ks.getName())) continue;
                    result = ks;
                    break;
                }
            }
        }
        return result;
    }

    public List<Keyspace> getKeyspaces() {
        return this.keyspaces;
    }

    public Schema addKeyspace(Keyspace keyspace) {
        return this.addKeyspace(keyspace, false);
    }

    public Schema addKeyspace(Keyspace keyspace, boolean ifNotExists) {
        if (this.keyspaces.contains(keyspace) && ifNotExists) {
            return this;
        }
        this.keyspaces.remove(keyspace);
        this.keyspaces.add(keyspace);
        keyspace.setSchema(this);
        Metrics.setGaugeValue((String)"keyspace_count", (int)this.keyspaces.size());
        return this;
    }

    public Schema removeKeyspace(String keyspaceName) {
        Keyspace keyspace = this.getKeyspace(keyspaceName);
        if (keyspace != null) {
            this.removeKeyspace(keyspace);
        }
        Metrics.setGaugeValue((String)"keyspace_count", (int)this.keyspaces.size());
        return this;
    }

    public Schema removeKeyspace(Keyspace keyspace) {
        if (this.keyspaces.remove(keyspace) && keyspace.getName().equals(this.currentKeyspaceName)) {
            this.currentKeyspaceName = "";
        }
        return this;
    }

    public Indices getIndices() {
        return this.indices;
    }

    public Schema addIndex(Index index) {
        this.indices.remove(index);
        this.indices.add(index);
        return this;
    }

    public Schema removeIndex(String indexName) {
        Index index = this.getIndex(indexName);
        if (index != null) {
            this.removeIndex(index);
        }
        return this;
    }

    public Schema removeIndex(Index index) {
        this.indices.remove(index);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isColumnIndexed(String columnName) {
        Indices indices = this.indices;
        synchronized (indices) {
            Index indexMeta;
            Iterator<Index> iterator = this.indices.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(indexMeta = iterator.next()).getColumn().getName().equals(columnName));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema rebuildIndex() {
        this.indices.clear();
        List<Keyspace> list = this.keyspaces;
        synchronized (list) {
            for (Keyspace keyspace : this.keyspaces) {
                for (Table table : keyspace.getTables()) {
                    for (Column column : table.getColumns()) {
                        Index index = column.getIndex();
                        if (index == null || index.getName().equals("")) continue;
                        this.indices.add(index);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index getIndex(String indexName) {
        Index result = null;
        Indices indices = this.indices;
        synchronized (indices) {
            for (Index index : this.indices) {
                if (!index.getName().equals(indexName)) continue;
                result = index;
                break;
            }
        }
        return result;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public Schema addTrigger(Trigger trigger) {
        this.triggers.remove(trigger);
        this.triggers.add(trigger);
        return this;
    }

    public Schema removeTrigger(String triggerName) {
        Trigger trigger = this.getTrigger(triggerName);
        if (trigger != null) {
            this.removeTrigger(trigger);
        }
        return this;
    }

    public Schema removeTrigger(Trigger trigger) {
        this.triggers.remove(trigger);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger getTrigger(String triggerName) {
        Trigger result = null;
        List<Trigger> list = this.triggers;
        synchronized (list) {
            for (Trigger trigger : this.triggers) {
                if (!trigger.getName().equals(triggerName)) continue;
                result = trigger;
                break;
            }
        }
        return result;
    }

    public boolean isUserExist(String username) {
        return this.getUser(username) != null;
    }

    public Schema addUser(User user) {
        return this.addUser(user, false);
    }

    public Schema addUser(User user, boolean ifNotExists) {
        if (this.users.contains(user) && ifNotExists) {
            return this;
        }
        this.users.remove(user);
        this.users.add(user);
        return this;
    }

    public Schema removeUser(String username) {
        User user = this.getUser(username);
        if (user != null) {
            this.removeUser(user);
        }
        return this;
    }

    public Schema removeUser(User user) {
        this.users.remove(user);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String username) {
        User result = null;
        if (username != null) {
            List<User> list = this.users;
            synchronized (list) {
                for (User user : this.users) {
                    if (!user.getName().equals(username)) continue;
                    result = user;
                    break;
                }
            }
        }
        return result;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public String getKeyspaceName(KeyspaceEntity keyspaceEntity) {
        Keyspace keyspace = this.getKeyspace(keyspaceEntity);
        return keyspace == null ? null : keyspace.getName();
    }

    public Keyspace getKeyspace(KeyspaceEntity keyspaceEntity) {
        Keyspace ksMeta = null;
        ksMeta = keyspaceEntity != null ? this.getKeyspace(ModelUtil.stripName(keyspaceEntity.getName())) : this.getCurrentKeyspace();
        return ksMeta;
    }

    public Table getTable(KeyspaceEntity keyspaceEntity, TableEntity tableEntity) {
        return this.getTable(this.getKeyspaceName(keyspaceEntity), tableEntity);
    }

    public Table getTable(String keyspaceName, TableEntity tableEntity) {
        if (tableEntity == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)keyspaceName)) {
            return null;
        }
        Keyspace keyspace = this.getKeyspace(keyspaceName);
        return keyspace == null ? null : keyspace.getTable(ModelUtil.stripName(tableEntity.getName()));
    }

    public UserType getUserType(KeyspaceEntity keyspaceEntity, TypeEntity typeEntity) {
        return this.getUserType(this.getKeyspaceName(keyspaceEntity), typeEntity);
    }

    public UserType getUserType(String keyspaceName, TypeEntity typeEntity) {
        if (typeEntity == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)keyspaceName)) {
            return null;
        }
        Keyspace keyspace = this.getKeyspace(keyspaceName);
        return keyspace == null ? null : keyspace.getUserType(ModelUtil.stripName(typeEntity.getName()));
    }

    public UserType getUserType(String keyspaceName, String userTypeName) {
        if (StringUtils.isEmpty((String)keyspaceName)) {
            return null;
        }
        Keyspace keyspace = this.getKeyspace(keyspaceName);
        return keyspace == null ? null : keyspace.getUserType(ModelUtil.stripName(userTypeName));
    }

    public Column getColumn(KeyspaceEntity keyspaceEntity, TableEntity tableEntity, ColumnEntity columnEntity) {
        return this.getColumn(this.getKeyspaceName(keyspaceEntity), tableEntity, columnEntity);
    }

    public Column getColumn(String keyspaceName, TableEntity tableEntity, ColumnEntity columnEntity) {
        if (columnEntity == null) {
            return null;
        }
        Table table = this.getTable(keyspaceName, tableEntity);
        if (table == null) {
            return null;
        }
        return table.getColumn(ModelUtil.stripName(columnEntity.getName()));
    }

    public UserTypeField getField(KeyspaceEntity keyspaceEntity, TypeEntity typeEntity, FieldEntity fieldEntity) {
        return this.getField(this.getKeyspaceName(keyspaceEntity), typeEntity, fieldEntity);
    }

    public UserTypeField getField(String keyspaceName, TypeEntity typeEntity, FieldEntity fieldEntity) {
        if (fieldEntity == null) {
            return null;
        }
        UserType type = this.getUserType(keyspaceName, typeEntity);
        if (type == null) {
            return null;
        }
        return type.getField(ModelUtil.stripName(fieldEntity.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("meta: " + this.name + ", currentKs: " + this.getCurrentKeyspaceName() + "\n");
        String metaIndent = "";
        String indentLevel = "  ";
        String ksIndent = String.valueOf(metaIndent) + indentLevel;
        Indices indices = this.keyspaces;
        synchronized (indices) {
            for (Keyspace ks : this.keyspaces) {
                sb.append(String.valueOf(ksIndent) + ks.toString() + "\n");
            }
        }
        indices = this.indices;
        synchronized (indices) {
            for (Index idx : this.indices) {
                sb.append(String.valueOf(idx.toString()) + "\n");
            }
        }
        return sb.toString();
    }
}

