/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.AbstractKeyspaceSchemaElement;
import com.datastax.devcenter.schema.FunctionParameter;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.types.CqlDataType;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;

public class SchemaFunction
extends AbstractKeyspaceSchemaElement {
    private final List<FunctionParameter> functionParameters = new LinkedList<FunctionParameter>();
    private CqlDataType returnType;
    boolean isConverter = true;
    private boolean isAggregate;
    private EClass containingStatementType;

    public SchemaFunction(String name, int statementIndex) {
        super(name, statementIndex);
    }

    public SchemaFunction functionName(String functionName) {
        this.name = ModelUtil.stripName(functionName);
        return this;
    }

    public SchemaFunction addFunctionParameter(String name, CqlDataType functionParameterType) {
        FunctionParameter parameter = new FunctionParameter(name, functionParameterType);
        parameter.setFunction(this);
        this.functionParameters.add(parameter);
        return this;
    }

    public SchemaFunction addFunctionParameter(FunctionParameter parameter) {
        parameter.setFunction(this);
        this.functionParameters.add(parameter);
        return this;
    }

    public SchemaFunction returnType(CqlDataType returnType) {
        this.returnType = returnType;
        return this;
    }

    public SchemaFunction aggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
        return this;
    }

    public SchemaFunction containingStatementTypeRestriction(EClass containingStatementType) {
        this.containingStatementType = containingStatementType;
        return this;
    }

    public SchemaFunction converter(boolean isConverter) {
        this.isConverter = isConverter;
        return this;
    }

    public String toString() {
        return this.name;
    }

    public boolean isInputParameterValid(int parameterPosition, String input) {
        return this.functionParameters.get(parameterPosition - 1).getType().validate(input);
    }

    public boolean isInputValid(String input) {
        return this.isInputParameterValid(1, input);
    }

    public boolean isInputParameterValid(int parameterPosition, Term term) {
        return this.functionParameters.get(parameterPosition - 1).getType().validate(term);
    }

    public boolean isInputValid(Term term) {
        return this.isInputParameterValid(1, term);
    }

    public boolean isConverter() {
        return this.isConverter;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isBuiltin() {
        return this.getKeyspace().isSystemKeyspace();
    }

    public String getFunctionName() {
        return this.name;
    }

    public CqlDataType getReturnType() {
        return this.returnType;
    }

    public EClass getContainingStatementType() {
        return this.containingStatementType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaFunction deepCopy(Object parent) {
        Keyspace parentKeyspace = (Keyspace)parent;
        SchemaFunction function = parentKeyspace.getFunction(this);
        if (function == null) {
            function = new SchemaFunction(this.name, this.statementIndex);
            function.aggregate(this.isAggregate).returnType(this.returnType).converter(this.isConverter).containingStatementTypeRestriction(this.containingStatementType);
            function.setKeyspace(parentKeyspace);
            List<FunctionParameter> list = this.functionParameters;
            synchronized (list) {
                for (FunctionParameter fp : this.functionParameters) {
                    function.addFunctionParameter(fp.deepCopy(function));
                }
            }
        }
        return function;
    }

    public List<FunctionParameter> getFunctionParameters() {
        return this.functionParameters;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.containingStatementType == null ? 0 : this.containingStatementType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.functionParameters == null ? 0 : this.functionParameters.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaFunction other = (SchemaFunction)obj;
        if (this.containingStatementType == null ? other.containingStatementType != null : !this.containingStatementType.equals(other.containingStatementType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.functionParameters == null ? other.functionParameters != null : !this.functionParameters.equals(other.functionParameters));
    }
}

