/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.User;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.options.Caching;
import com.datastax.devcenter.schema.options.CompressionAlgorithm;
import com.datastax.devcenter.schema.options.KeyspaceOptions;
import com.datastax.devcenter.schema.options.KeyspaceReplication;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.devcenter.schema.options.ReplicationStrategy;
import com.datastax.devcenter.schema.options.SpeculativeRetry;
import com.datastax.devcenter.schema.options.TableCaching;
import com.datastax.devcenter.schema.options.TableCompaction;
import com.datastax.devcenter.schema.options.TableCompression;
import com.datastax.devcenter.schema.options.TableOptions;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CustomCqlDataType;
import com.datastax.devcenter.schema.types.ListCqlDataType;
import com.datastax.devcenter.schema.types.MapCqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.devcenter.schema.types.SetCqlDataType;
import com.datastax.devcenter.schema.types.TupleCqlDataType;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import com.datastax.devcenter.schema.types.UserDefinedTypeCqlDataType;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.VersionNumber;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SchemaInitializer {
    private static final String SYSTEM_KEYSPACE = "system";
    private static final String SCHEMA_AGGREGATES_TABLE = "schema_aggregates";
    private static final String SCHEMA_FUNCTIONS_TABLE = "schema_functions";
    private static final String KEYSPACE_NAME_COLUMN = "keyspace_name";
    private static final String FUNCTION_NAME_COLUMN = "function_name";
    private static final String AGGREGATE_NAME_COLUMN = "aggregate_name";
    private static final String FUNCTION_PARAMETER_TYPES_COLUMN = "argument_types";
    private static final String FUNCTION_PARAMETER_NAMES_COLUMN = "argument_names";
    private static final String FUNCTION_RETURN_TYPE_COLUMN = "return_type";
    private static final String SYSTEM_AUTH_KEYSPACE = "system_auth";
    private static final String ROLES_TABLE = "roles";
    private static final String ROLES_ROLENAME_COLUMN = "role";
    private static final String ROLES_LOGIN_COLUMN = "can_login";
    private static final String ROLES_SUPERUSER_COLUMN = "is_superuser";
    private static final String USERS_TABLE = "users";
    private static final String USERS_NAME_COLUMN = "name";
    private static final String USERS_SUPERUSER_COLUMN = "super";
    static final Method methodParseOne;

    static {
        try {
            Class<?> cls = Class.forName("com.datastax.driver.core.CassandraTypeParser");
            methodParseOne = cls.getDeclaredMethod("parseOne", String.class);
            methodParseOne.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Schema init(Connection connection) {
        if (connection == null) {
            return new Schema("");
        }
        Metadata metadata = connection.getMetadata();
        if (metadata == null) {
            return new Schema("");
        }
        VersionNumber version = connection.getCassandraVersion();
        Schema schema = new Schema(metadata.getClusterName());
        this.loadMetaDataFromDriver(metadata, version, schema);
        this.loadUDFMetaData(connection, version, schema);
        this.loadUserRoleMetaData(connection, version, schema);
        return schema;
    }

    private void loadUserRoleMetaData(Connection connection, VersionNumber version, Schema schema) {
        if (version.compareTo(CqlConstants.CASSANDRA_2_2_0) >= 0) {
            this.loadUserDataFromRolesTable(connection, schema);
        } else {
            this.loadUserDataFromUsersTable(connection, schema);
        }
    }

    private void loadUserDataFromUsersTable(Connection connection, Schema schema) {
        if (schema.getKeyspace(SYSTEM_AUTH_KEYSPACE) != null) {
            ArrayList<String> userQueries = new ArrayList<String>();
            userQueries.add(String.format("select %s, %s from %s", USERS_NAME_COLUMN, USERS_SUPERUSER_COLUMN, USERS_TABLE));
            try {
                ResultSet resultSet = connection.execute(userQueries, SYSTEM_AUTH_KEYSPACE, false);
                Iterator rows = resultSet.iterator();
                Row row = null;
                while (rows.hasNext()) {
                    row = (Row)rows.next();
                    User newUser = new User(row.getString(USERS_NAME_COLUMN));
                    newUser.setCanLogin(true);
                    newUser.setSuperuser(row.getBool(USERS_SUPERUSER_COLUMN));
                    schema.addUser(newUser);
                }
            }
            catch (Throwable e) {
                DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)this.getClass().getName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            }
        }
    }

    private void loadUserDataFromRolesTable(Connection connection, Schema schema) {
        ArrayList<String> userQueries = new ArrayList<String>();
        userQueries.add(String.format("select %s, %s, %s from %s", ROLES_ROLENAME_COLUMN, ROLES_SUPERUSER_COLUMN, ROLES_LOGIN_COLUMN, ROLES_TABLE));
        try {
            ResultSet resultSet = connection.execute(userQueries, SYSTEM_AUTH_KEYSPACE, false);
            Iterator rows = resultSet.iterator();
            Row row = null;
            while (rows.hasNext()) {
                row = (Row)rows.next();
                User newUser = new User(row.getString(ROLES_ROLENAME_COLUMN));
                newUser.setCanLogin(row.getBool(ROLES_LOGIN_COLUMN));
                newUser.setSuperuser(row.getBool(ROLES_SUPERUSER_COLUMN));
                schema.addUser(newUser);
            }
        }
        catch (Throwable e) {
            DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)this.getClass().getName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    private void loadUDFMetaData(Connection connection, VersionNumber version, Schema schema) {
        if (version.compareTo(CqlConstants.CASSANDRA_2_2_0) >= 0) {
            this.loadFunctionsFromSystemTable(FUNCTION_NAME_COLUMN, connection, schema, SCHEMA_FUNCTIONS_TABLE, false);
            this.loadFunctionsFromSystemTable(AGGREGATE_NAME_COLUMN, connection, schema, SCHEMA_AGGREGATES_TABLE, true);
        }
    }

    private void loadFunctionsFromSystemTable(String nameColumnName, Connection connection, Schema schema, String functionTable, boolean isAggregate) {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("select * from " + functionTable);
        try {
            this.extractFunctionMetadataFromResultSet(nameColumnName, connection, schema, queries, isAggregate);
        }
        catch (Throwable e) {
            DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)this.getClass().getName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    private void extractFunctionMetadataFromResultSet(String functionNameColumnName, Connection connection, Schema schema, List<String> queries, boolean isAggregate) throws Exception, Throwable {
        ResultSet resultSet = connection.execute(queries, SYSTEM_KEYSPACE, false);
        Iterator rows = resultSet.iterator();
        Row next = null;
        while (rows.hasNext()) {
            next = (Row)rows.next();
            String functionName = next.getString(functionNameColumnName);
            String returnType = next.getString(FUNCTION_RETURN_TYPE_COLUMN);
            String keyspaceName = next.getString(KEYSPACE_NAME_COLUMN);
            Keyspace keyspace = schema.getKeyspace(keyspaceName);
            DataType driverReturnType = (DataType)methodParseOne.invoke(null, returnType);
            CqlDataType cqlReturnType = SchemaInitializer.getDataTypeMapping(driverReturnType);
            List parameterTypes = next.getList(FUNCTION_PARAMETER_TYPES_COLUMN, String.class);
            List parameterNames = null;
            if (!isAggregate) {
                parameterNames = next.getList(FUNCTION_PARAMETER_NAMES_COLUMN, String.class);
            }
            SchemaFunction function = new SchemaFunction(functionName, -1).returnType(cqlReturnType).converter(false);
            if (isAggregate) {
                function.aggregate(true).containingStatementTypeRestriction(CqlPackage.Literals.SELECTOR_FUNCTION);
            }
            int index = 0;
            while (index < parameterTypes.size()) {
                String parameterTypeString = (String)parameterTypes.get(index);
                DataType driverType = (DataType)methodParseOne.invoke(null, parameterTypeString);
                CqlDataType cqlDataType = SchemaInitializer.getDataTypeMapping(driverType);
                String name = null;
                name = parameterNames != null ? (String)parameterNames.get(index) : "p" + (index + 1);
                function.addFunctionParameter(name, cqlDataType);
                ++index;
            }
            keyspace.addFunction(function);
        }
    }

    private void loadMetaDataFromDriver(Metadata metadata, VersionNumber version, Schema schema) {
        for (KeyspaceMetadata keyspaceMetadata : metadata.getKeyspaces()) {
            Keyspace keyspace = new Keyspace(keyspaceMetadata.getName());
            keyspace.setSchema(schema);
            schema.addKeyspace(keyspace);
            this.loadKeyspaceMetaData(keyspaceMetadata, keyspace);
            for (TableMetadata tableMetadata : keyspaceMetadata.getTables()) {
                this.loadTableMetaData(version, schema, keyspace, tableMetadata);
            }
            this.loadUDTMetadata(keyspaceMetadata, keyspace);
        }
    }

    private void loadKeyspaceMetaData(KeyspaceMetadata keyspaceMetadata, Keyspace keyspace) {
        KeyspaceOptions keyspaceOptions = new KeyspaceOptions();
        keyspace.setOptions(keyspaceOptions);
        keyspaceOptions.setDurableWrites(keyspaceMetadata.isDurableWrites());
        KeyspaceReplication keyspaceReplication = keyspaceOptions.getReplication();
        Map keyspaceReplicationMetadata = keyspaceMetadata.getReplication();
        for (Map.Entry entry : keyspaceReplicationMetadata.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                if ("class".equalsIgnoreCase(key)) {
                    keyspaceReplication.setStrategy(ReplicationStrategy.lookup(value));
                    continue;
                }
                if ("replication_factor".equalsIgnoreCase(key)) {
                    keyspaceReplication.setReplicationFactor(Integer.valueOf(value));
                    continue;
                }
                KeyspaceReplication.DataCenter datacenter = new KeyspaceReplication.DataCenter(key, Integer.valueOf(value));
                keyspaceReplication.addDataCenter(datacenter);
            }
            catch (Exception e) {
                String msg = String.format("Error decoding '%s'='%s': %s", key, value, e.toString());
                DevCenterLogger.error((String)msg, (String)SchemaInitializer.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            }
        }
    }

    private void loadTableMetaData(VersionNumber version, Schema schema, Keyspace keyspace, TableMetadata tableMetadata) {
        Table table = new Table(tableMetadata.getName());
        table.setKeyspace(keyspace);
        keyspace.addTable(table);
        this.loadPartitionMetaData(tableMetadata, table);
        this.loadColumnMetaData(tableMetadata, table);
        this.loadColumnMetaData(schema, tableMetadata, table);
        table.setCompactStorage(tableMetadata.getOptions().isCompactStorage());
        TableMetadata.Options optionsMetadata = tableMetadata.getOptions();
        TableOptions options = this.loadTableOptionsMetaData(table, optionsMetadata);
        this.loadCachingMetaData(version, optionsMetadata, options);
        this.loadTableCompressionMetaData(optionsMetadata, options);
        this.loadTableCompactionMetaData(optionsMetadata, options);
    }

    private void loadColumnMetaData(TableMetadata tableMetadata, Table table) {
        for (ColumnMetadata columnMetadata : tableMetadata.getClusteringColumns()) {
            Column column = new Column(columnMetadata.getName(), SchemaInitializer.getDataTypeMapping(columnMetadata.getType()));
            column.setTable(table);
            table.addClusteringKey(column);
        }
    }

    private void loadPartitionMetaData(TableMetadata tableMetadata, Table table) {
        for (ColumnMetadata columnMetadata : tableMetadata.getPartitionKey()) {
            Column column = new Column(columnMetadata.getName(), SchemaInitializer.getDataTypeMapping(columnMetadata.getType()));
            column.setTable(table);
            table.addPartitionKey(column);
        }
    }

    private void loadColumnMetaData(Schema schema, TableMetadata tableMetadata, Table table) {
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            Column column = new Column(columnMetadata.getName(), SchemaInitializer.getDataTypeMapping(columnMetadata.getType()));
            column.setStatic(columnMetadata.isStatic());
            column.setTable(table);
            table.addColumn(column);
            ColumnMetadata.IndexMetadata indexMetadata = columnMetadata.getIndex();
            if (indexMetadata == null) continue;
            Index index = new Index(indexMetadata.getName());
            index.setCustomClassName(indexMetadata.getIndexClassName());
            index.setFull(indexMetadata.isFull());
            index.setKeys(indexMetadata.isKeys());
            index.setEntries(indexMetadata.isEntries());
            index.setColumn(column);
            column.setIndex(index);
            schema.addIndex(index);
        }
    }

    private TableOptions loadTableOptionsMetaData(Table table, TableMetadata.Options optionsMetadata) {
        TableOptions options = new TableOptions();
        table.setOptions(options);
        options.setBloomFilterFPChance(optionsMetadata.getBloomFilterFalsePositiveChance());
        options.setComment(optionsMetadata.getComment());
        options.setDcLocalReadRepairChance(optionsMetadata.getLocalReadRepairChance());
        options.setDefaultTimeToLive(optionsMetadata.getDefaultTimeToLive());
        options.setGcGraceSeconds(optionsMetadata.getGcGraceInSeconds());
        options.setIndexInterval(optionsMetadata.getIndexInterval());
        options.setMaxIndexInterval(optionsMetadata.getMaxIndexInterval());
        options.setMemtableFlushPeriodInMs(optionsMetadata.getMemtableFlushPeriodInMs());
        options.setMinIndexInterval(optionsMetadata.getMinIndexInterval());
        options.setPopulateIOCacheOnFlush(optionsMetadata.getPopulateIOCacheOnFlush());
        options.setReadRepairChance(optionsMetadata.getReadRepairChance());
        options.setReplicateOnWrite(optionsMetadata.getReplicateOnWrite());
        try {
            options.setSpeculativeRetry(SpeculativeRetry.parse(optionsMetadata.getSpeculativeRetry()));
        }
        catch (Exception e) {
            String msg = String.format("Error decoding 'speculative_retry'='%s': %s", optionsMetadata.getSpeculativeRetry(), e.toString());
            DevCenterLogger.error((String)msg, (String)SchemaInitializer.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
        return options;
    }

    private void loadCachingMetaData(VersionNumber version, TableMetadata.Options optionsMetadata, TableOptions options) {
        Map cachingMetadata = optionsMetadata.getCaching();
        TableCaching caching = new TableCaching();
        options.setCaching(caching);
        if (version.getMajor() < 2 || version.getMajor() == 2 && version.getMinor() < 1) {
            String keys = (String)cachingMetadata.get("keys");
            if (keys != null) {
                caching.setValue(Caching.lookup(keys));
            }
        } else {
            for (Map.Entry entry : cachingMetadata.entrySet()) {
                try {
                    OptionsHelper.setOptionValue(caching, (String)entry.getKey(), (String)entry.getValue());
                }
                catch (Exception e) {
                    String msg = String.format("Error decoding '%s'='%s': %s", entry.getKey(), entry.getValue(), e.toString());
                    DevCenterLogger.error((String)msg, (String)SchemaInitializer.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                }
            }
        }
    }

    private void loadTableCompressionMetaData(TableMetadata.Options optionsMetadata, TableOptions options) {
        Map compressionMetadata = optionsMetadata.getCompression();
        TableCompression compression = new TableCompression();
        options.setCompression(compression);
        if (compressionMetadata.isEmpty()) {
            compression.setAlgorithm(CompressionAlgorithm.NONE);
        } else {
            for (Map.Entry entry : compressionMetadata.entrySet()) {
                try {
                    OptionsHelper.setOptionValue(compression, (String)entry.getKey(), (String)entry.getValue());
                }
                catch (Exception e) {
                    String msg = String.format("Error decoding '%s'='%s': %s", entry.getKey(), entry.getValue(), e.toString());
                    DevCenterLogger.error((String)msg, (String)SchemaInitializer.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                }
            }
        }
    }

    private void loadTableCompactionMetaData(TableMetadata.Options optionsMetadata, TableOptions options) {
        Map compactionMetadata = optionsMetadata.getCompaction();
        TableCompaction compaction = new TableCompaction();
        options.setCompaction(compaction);
        for (Map.Entry entry : compactionMetadata.entrySet()) {
            try {
                OptionsHelper.setOptionValue(compaction, (String)entry.getKey(), (String)entry.getValue());
            }
            catch (Exception e) {
                String msg = String.format("Error decoding '%s'='%s': %s", entry.getKey(), entry.getValue(), e.toString());
                DevCenterLogger.error((String)msg, (String)SchemaInitializer.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            }
        }
    }

    private void loadUDTMetadata(KeyspaceMetadata keyspaceMetadata, Keyspace keyspace) {
        for (com.datastax.driver.core.UserType userTypeMetadata : keyspaceMetadata.getUserTypes()) {
            UserType userType = new UserType(userTypeMetadata.getTypeName());
            userType.setKeyspace(keyspace);
            keyspace.addUserType(userType);
            for (UserType.Field field : userTypeMetadata) {
                UserTypeField userTypeField = new UserTypeField(field.getName(), SchemaInitializer.getDataTypeMapping(field.getType()));
                userType.addField(userTypeField);
            }
        }
    }

    public static CqlDataType getDataTypeMapping(DataType otherType) {
        switch (otherType.getName()) {
            case CUSTOM: {
                return new CustomCqlDataType(otherType.getCustomTypeClassName());
            }
            case LIST: {
                CqlDataType listElementType = SchemaInitializer.getDataTypeMapping((DataType)otherType.getTypeArguments().get(0));
                ListCqlDataType listType = new ListCqlDataType(listElementType);
                listType.setFrozen(otherType.isFrozen());
                return listType;
            }
            case MAP: {
                CqlDataType keyType = SchemaInitializer.getDataTypeMapping((DataType)otherType.getTypeArguments().get(0));
                CqlDataType valueType = SchemaInitializer.getDataTypeMapping((DataType)otherType.getTypeArguments().get(1));
                MapCqlDataType mapType = new MapCqlDataType(keyType, valueType);
                mapType.setFrozen(otherType.isFrozen());
                return mapType;
            }
            case SET: {
                CqlDataType setElementType = SchemaInitializer.getDataTypeMapping((DataType)otherType.getTypeArguments().get(0));
                SetCqlDataType setType = new SetCqlDataType(setElementType);
                setType.setFrozen(otherType.isFrozen());
                return setType;
            }
            case UDT: {
                com.datastax.driver.core.UserType driverUserType = (com.datastax.driver.core.UserType)otherType;
                String cqlUserTypeName = driverUserType.getTypeName();
                UserType cqlUserType = new UserType(cqlUserTypeName);
                Collection driverFieldNames = driverUserType.getFieldNames();
                for (String driverFieldName : driverFieldNames) {
                    DataType driverFieldType = driverUserType.getFieldType(driverFieldName);
                    cqlUserType.addField(new UserTypeField(driverFieldName, SchemaInitializer.getDataTypeMapping(driverFieldType)));
                }
                UserDefinedTypeCqlDataType userType = new UserDefinedTypeCqlDataType(cqlUserType);
                userType.setFrozen(driverUserType.isFrozen());
                return userType;
            }
            case TUPLE: {
                TupleType driverTupleType = (TupleType)otherType;
                List driverTupleDataTypes = driverTupleType.getComponentTypes();
                ArrayList<CqlDataType> cqlTupleTypes = new ArrayList<CqlDataType>();
                for (DataType driverTupleDataType : driverTupleDataTypes) {
                    cqlTupleTypes.add(SchemaInitializer.getDataTypeMapping(driverTupleDataType));
                }
                TupleCqlDataType tupleType = new TupleCqlDataType(cqlTupleTypes);
                tupleType.setFrozen(driverTupleType.isFrozen());
                return tupleType;
            }
        }
        NativeCqlDataType nativeType = NativeCqlDataType.getByCanonicalString(otherType.getName().toString());
        if (nativeType == null) {
            return UnknownCqlDataType.INSTANCE;
        }
        return nativeType;
    }
}

