/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.cql.cql.BatchStatement;
import com.datastax.devcenter.cql.cql.CqlStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class StatementIndexMap {
    private final ConcurrentMap<CqlStatement, StatementIndexMeta> stmtIndexMetaMap = new ConcurrentHashMap<CqlStatement, StatementIndexMeta>();

    public void setStatementIndex(CqlStatement stmt, int index) {
        this.stmtIndexMetaMap.put(stmt, new StatementIndexMeta(stmt, index, false));
        if (stmt instanceof BatchStatement) {
            for (CqlStatement containedStmt : ((BatchStatement)stmt).getStatements()) {
                this.stmtIndexMetaMap.put(containedStmt, new StatementIndexMeta(containedStmt, index, true));
            }
        }
    }

    public int getStatementIndex(CqlStatement stmt) {
        StatementIndexMeta meta = stmt != null ? (StatementIndexMeta)this.stmtIndexMetaMap.get(stmt) : null;
        return meta != null ? meta.getIndex() : -1;
    }

    public int getStatementOffset(CqlStatement stmt) {
        StatementIndexMeta meta = (StatementIndexMeta)this.stmtIndexMetaMap.get(stmt);
        return meta != null ? meta.getOffset() : -1;
    }

    public int getStatementLength(CqlStatement stmt) {
        StatementIndexMeta meta = (StatementIndexMeta)this.stmtIndexMetaMap.get(stmt);
        return meta != null ? meta.getLength() : -1;
    }

    public CqlStatement getStatementAtOffset(int offset) {
        CqlStatement result = null;
        int maxStartOffset = -1;
        for (Map.Entry entry : this.stmtIndexMetaMap.entrySet()) {
            StatementIndexMeta stmtMeta = (StatementIndexMeta)entry.getValue();
            int stmtStartOffset = stmtMeta.getOffset();
            int stmtEndOffset = stmtStartOffset + stmtMeta.getLength();
            if (stmtStartOffset > offset || stmtEndOffset <= offset || stmtStartOffset <= maxStartOffset) continue;
            result = (CqlStatement)entry.getKey();
            maxStartOffset = stmtStartOffset;
        }
        return result;
    }

    public List<CqlStatement> getStatementsIntersectingRange(int rangeStartOffset, int rangeEndOffset) {
        ArrayList<CqlStatement> statements = new ArrayList<CqlStatement>();
        if (rangeStartOffset < 0 || rangeEndOffset < 0 || rangeStartOffset >= rangeEndOffset) {
            return statements;
        }
        for (Map.Entry entry : this.stmtIndexMetaMap.entrySet()) {
            StatementIndexMeta meta = (StatementIndexMeta)entry.getValue();
            if (meta.getOffset() >= rangeEndOffset || meta.getOffset() + meta.getLength() <= rangeStartOffset || meta.isContainedInBatch()) continue;
            statements.add((CqlStatement)entry.getKey());
        }
        Collections.sort(statements, new Comparator<CqlStatement>(){

            @Override
            public int compare(CqlStatement n1, CqlStatement n2) {
                int o2;
                int o1 = NodeModelUtils.getNode((EObject)n1).getOffset();
                return o1 < (o2 = NodeModelUtils.getNode((EObject)n2).getOffset()) ? -1 : (o1 == o2 ? 0 : 1);
            }
        });
        return statements;
    }

    public void clear() {
        this.stmtIndexMetaMap.clear();
    }

    private static class StatementIndexMeta {
        private final int index;
        private final int offset;
        private final int length;
        private final boolean containedInBatch;

        private StatementIndexMeta(EObject stmt, int index, boolean containedInBatch) {
            this.index = index;
            this.containedInBatch = containedInBatch;
            ICompositeNode node = NodeModelUtils.getNode((EObject)stmt);
            if (node != null) {
                this.offset = node.getOffset();
                this.length = node.getLength();
            } else {
                this.offset = 0;
                this.length = 0;
            }
        }

        private int getIndex() {
            return this.index;
        }

        private int getOffset() {
            return this.offset;
        }

        private int getLength() {
            return this.length;
        }

        private boolean isContainedInBatch() {
            return this.containedInBatch;
        }
    }
}

