/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.schema.AbstractKeyspaceSchemaElement;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.options.TableOptions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Table
extends AbstractKeyspaceSchemaElement {
    private final List<Column> columns = Collections.synchronizedList(new ArrayList());
    private final List<Column> partitionKeys = Collections.synchronizedList(new ArrayList());
    private final List<Column> clusteringKeys = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<String, ClusteringOrder> clusteringOrders = new ConcurrentHashMap<String, ClusteringOrder>(8, 0.9f, 1);
    private boolean compactStorage = false;
    private TableOptions options;

    public Table(String name) {
        super(name);
    }

    public Table(String name, int statementIndex) {
        this(name);
        this.setStatementIndex(statementIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table deepCopy(Object parent) {
        Keyspace parentKeyspace = (Keyspace)parent;
        Table newTable = new Table(this.name, this.getStatementIndex());
        newTable.setKeyspace(parentKeyspace);
        newTable.setCompactStorage(this.isCompactStorage());
        newTable.options = this.options == null ? null : this.options.deepCopy();
        List<Column> list = this.columns;
        synchronized (list) {
            Column clone;
            for (Column column : this.columns) {
                clone = column.deepCopy(newTable);
                newTable.columns.add(clone);
            }
            for (Column partitionKey : this.partitionKeys) {
                clone = newTable.getColumn(partitionKey.getName());
                newTable.partitionKeys.add(clone);
            }
            for (Column clusteringColumn : this.clusteringKeys) {
                clone = newTable.getColumn(clusteringColumn.getName());
                newTable.clusteringKeys.add(clone);
            }
            newTable.clusteringOrders.putAll(this.clusteringOrders);
        }
        return newTable;
    }

    public boolean isCompactStorage() {
        return this.compactStorage;
    }

    public void setCompactStorage(boolean compactStorage) {
        this.compactStorage = compactStorage;
        this.firePropertyChange("compactStorage", this.compactStorage, this.compactStorage);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column getColumn(String name) {
        Column result = null;
        if (name != null) {
            List<Column> list = this.columns;
            synchronized (list) {
                for (Column columnMeta : this.columns) {
                    if (!name.equals(columnMeta.getName())) continue;
                    result = columnMeta;
                    break;
                }
            }
        }
        return result;
    }

    public Table addColumn(Column column) {
        if (column != null && column.getName() != null) {
            this.removeColumn(column.getName());
            ArrayList<Column> oldList = new ArrayList<Column>(this.columns);
            ArrayList<Column> nonPrimaryKeyColumns = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
            this.columns.add(column);
            column.setTable(this);
            this.firePropertyChange("columns", oldList, this.columns);
            this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumns, this.getNonPrimaryKeyColumns());
        }
        return this;
    }

    public Table removeColumn(String name) {
        Column column = this.getColumn(name);
        if (column != null) {
            this.removeColumn(column);
        }
        return this;
    }

    public Table removeColumn(Column column) {
        ArrayList<Column> columnsOld = new ArrayList<Column>(this.columns);
        ArrayList<Column> nonPrimaryKeyColumnsOld = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
        this.removePartitionKey(column);
        this.removeClusteringKey(column);
        if (this.columns.remove(column)) {
            this.firePropertyChange("columns", columnsOld, this.columns);
            this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumnsOld, this.getNonPrimaryKeyColumns());
        }
        return this;
    }

    public void renameColumn(String oldColumnName, String newColumnName, int statementIndex) {
        this.renameColumn(this.getColumn(oldColumnName), newColumnName, statementIndex);
        this.renameColumn(this.getPartitionKey(oldColumnName), newColumnName, statementIndex);
        this.renameColumn(this.getClusteringKey(oldColumnName), newColumnName, statementIndex);
        ClusteringOrder clusteringOrder = this.removeClusteringOrder(oldColumnName);
        if (clusteringOrder != null) {
            this.addClusteringOrder(newColumnName, clusteringOrder);
        }
    }

    private void renameColumn(Column oldColumn, String newColumnName, int statementIndex) {
        if (oldColumn != null) {
            oldColumn.setName(newColumnName);
            oldColumn.setStatementIndex(statementIndex);
        }
    }

    public void moveColumnUp(Column column) {
        int i = this.columns.indexOf(column);
        if (i > 0) {
            ArrayList<Column> columnsOld = new ArrayList<Column>(this.columns);
            ArrayList<Column> nonPrimaryKeyColumnsOld = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
            Collections.swap(this.getColumns(), i, i - 1);
            if (column.isPrimaryKey()) {
                this.rebuildPrimaryKeys(new ArrayList<Column>(this.getPrimaryKeys()));
            }
            this.firePropertyChange("columns", columnsOld, this.columns);
            this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumnsOld, this.getNonPrimaryKeyColumns());
        }
    }

    public void moveColumnDown(Column column) {
        int i = this.columns.indexOf(column);
        if (i >= 0 && i < this.columns.size() - 1) {
            ArrayList<Column> columnsOld = new ArrayList<Column>(this.columns);
            ArrayList<Column> nonPrimaryKeyColumnsOld = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
            Collections.swap(this.getColumns(), i, i + 1);
            if (column.isPrimaryKey()) {
                this.rebuildPrimaryKeys(new ArrayList<Column>(this.getPrimaryKeys()));
            }
            this.firePropertyChange("columns", columnsOld, this.columns);
            this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumnsOld, this.getNonPrimaryKeyColumns());
        }
    }

    public boolean isColumnContain(String name) {
        return this.isCollectionOfColumnsContain(this.getColumns(), name);
    }

    public boolean isClusteringKeyContain(String name) {
        return this.isCollectionOfColumnsContain(this.getClusteringKeys(), name);
    }

    public boolean isPartitionKeyContain(String name) {
        return this.isCollectionOfColumnsContain(this.getPartitionKeys(), name);
    }

    public boolean isPrimaryKeyContain(String name) {
        return this.isClusteringKeyContain(name) || this.isPartitionKeyContain(name);
    }

    private boolean isCollectionOfColumnsContain(Collection<Column> columns, String name) {
        boolean result = false;
        if (columns == null || name == null) {
            return result;
        }
        for (Column col : columns) {
            if (!col.getName().equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public List<Column> getNonPrimaryKeyColumns() {
        ArrayList<Column> cols = new ArrayList<Column>();
        for (Column col : this.getColumns()) {
            if (this.isPrimaryKeyContain(col.getName())) continue;
            cols.add(col);
        }
        return ImmutableList.builder().addAll(cols).build();
    }

    public boolean hasCounter() {
        for (Column col : this.columns) {
            if (!col.isCounter()) continue;
            return true;
        }
        return false;
    }

    public List<Column> getPrimaryKeys() {
        return ImmutableList.builder().addAll(this.partitionKeys).addAll(this.clusteringKeys).build();
    }

    public Table addPrimaryKey(Column primaryKey) {
        if (primaryKey != null) {
            primaryKey.setTable(this);
            ArrayList<Column> newList = new ArrayList<Column>(this.getPrimaryKeys());
            if (!newList.contains(primaryKey)) {
                newList.add(primaryKey);
            }
            this.rebuildPrimaryKeys(newList);
        }
        return this;
    }

    public void removePrimaryKey(Column primaryKey) {
        ArrayList<Column> newList = new ArrayList<Column>(this.getPrimaryKeys());
        newList.remove(primaryKey);
        this.rebuildPrimaryKeys(newList);
    }

    private void rebuildPrimaryKeys(List<Column> newPrimaryKeys) {
        ArrayList<Column> primaryKeysOld = new ArrayList<Column>(this.getPrimaryKeys());
        ArrayList<Column> partitionKeysOld = new ArrayList<Column>(this.getPartitionKeys());
        ArrayList<Column> clusteringKeysOld = new ArrayList<Column>(this.getClusteringKeys());
        ArrayList<Column> nonPrimaryKeyColumns = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
        Collections.sort(newPrimaryKeys, new Comparator<Column>(){

            @Override
            public int compare(Column o1, Column o2) {
                int i1 = Table.this.columns.indexOf(o1);
                int i2 = Table.this.columns.indexOf(o2);
                return ComparisonChain.start().compare(i1, i2).result();
            }
        });
        this.partitionKeys.clear();
        this.clusteringKeys.clear();
        if (!newPrimaryKeys.isEmpty()) {
            this.partitionKeys.add(newPrimaryKeys.remove(0));
            for (Column clusteringKey : newPrimaryKeys) {
                this.clusteringKeys.add(clusteringKey);
                ClusteringOrder order = (ClusteringOrder)((Object)this.clusteringOrders.get(clusteringKey.getName()));
                if (order != null && order != ClusteringOrder.NONE) continue;
                this.clusteringOrders.put(clusteringKey.getName(), ClusteringOrder.ASC);
            }
        }
        this.firePropertyChange("primaryKeys", primaryKeysOld, this.getPrimaryKeys());
        this.firePropertyChange("partitionKeys", partitionKeysOld, this.getPartitionKeys());
        this.firePropertyChange("clusteringKeys", clusteringKeysOld, this.getClusteringKeys());
        this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumns, this.getNonPrimaryKeyColumns());
    }

    public List<Column> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Column getPartitionKey(String columnName) {
        for (Column pkCol : this.partitionKeys) {
            if (!pkCol.getName().equals(columnName)) continue;
            return pkCol;
        }
        return null;
    }

    public Table addPartitionKey(Column partitionKey) {
        if (partitionKey != null) {
            this.removePartitionKey(partitionKey);
            ArrayList<Column> primaryKeysOld = new ArrayList<Column>(this.getPrimaryKeys());
            ArrayList<Column> partitionKeysOld = new ArrayList<Column>(this.getPartitionKeys());
            ArrayList<Column> nonPrimaryKeyColumns = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
            this.partitionKeys.add(partitionKey);
            partitionKey.setTable(this);
            this.firePropertyChange("partitionKeys", partitionKeysOld, this.getPartitionKeys());
            this.firePropertyChange("primaryKeys", primaryKeysOld, this.getPrimaryKeys());
            this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumns, this.getNonPrimaryKeyColumns());
        }
        return this;
    }

    public void removePartitionKey(Column column) {
        ArrayList<Column> primaryKeysOld = new ArrayList<Column>(this.getPrimaryKeys());
        ArrayList<Column> partitionKeysOld = new ArrayList<Column>(this.getPartitionKeys());
        ArrayList<Column> nonPrimaryKeyColumns = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
        if (this.partitionKeys.remove(column)) {
            this.firePropertyChange("partitionKeys", partitionKeysOld, this.getPartitionKeys());
            this.firePropertyChange("primaryKeys", primaryKeysOld, this.getPrimaryKeys());
            this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumns, this.getNonPrimaryKeyColumns());
        }
    }

    public void movePartitionKeyUp(Column column) {
        int i = this.partitionKeys.indexOf(column);
        if (i > 0) {
            ArrayList<Column> oldList = new ArrayList<Column>(this.partitionKeys);
            Collections.swap(this.partitionKeys, i, i - 1);
            this.firePropertyChange("partitionKeys", oldList, this.partitionKeys);
        }
    }

    public void movePartitionKeyDown(Column column) {
        int i = this.partitionKeys.indexOf(column);
        if (i >= 0 && i < this.partitionKeys.size() - 1) {
            ArrayList<Column> oldList = new ArrayList<Column>(this.partitionKeys);
            Collections.swap(this.partitionKeys, i, i + 1);
            this.firePropertyChange("partitionKeys", oldList, this.partitionKeys);
        }
    }

    public List<Column> getClusteringKeys() {
        return this.clusteringKeys;
    }

    public Column getClusteringKey(String columnName) {
        for (Column clusteringCol : this.getClusteringKeys()) {
            if (!clusteringCol.getName().equals(columnName)) continue;
            return clusteringCol;
        }
        return null;
    }

    public Table addClusteringKey(Column clusteringKey) {
        this.addClusteringKey(clusteringKey, ClusteringOrder.ASC);
        return this;
    }

    public Table addClusteringKey(Column clusteringKey, ClusteringOrder order) {
        if (clusteringKey != null) {
            this.removeClusteringKey(clusteringKey);
            ArrayList<Column> primaryKeysOld = new ArrayList<Column>(this.getPrimaryKeys());
            ArrayList<Column> clusteringKeysOld = new ArrayList<Column>(this.getClusteringKeys());
            ArrayList<Column> nonPrimaryKeyColumns = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
            this.clusteringKeys.add(clusteringKey);
            clusteringKey.setTable(this);
            this.addClusteringOrder(clusteringKey.getName(), order);
            this.firePropertyChange("clusteringKeys", clusteringKeysOld, this.getClusteringKeys());
            this.firePropertyChange("primaryKeys", primaryKeysOld, this.getPrimaryKeys());
            this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumns, this.getNonPrimaryKeyColumns());
        }
        return this;
    }

    public void removeClusteringKey(Column column) {
        ArrayList<Column> primaryKeysOld = new ArrayList<Column>(this.getPrimaryKeys());
        ArrayList<Column> clusteringKeysOld = new ArrayList<Column>(this.getClusteringKeys());
        ArrayList<Column> nonPrimaryKeyColumns = new ArrayList<Column>(this.getNonPrimaryKeyColumns());
        if (this.clusteringKeys.remove(column)) {
            this.removeClusteringOrder(column.getName());
            this.firePropertyChange("clusteringKeys", clusteringKeysOld, this.getClusteringKeys());
            this.firePropertyChange("primaryKeys", primaryKeysOld, this.getPrimaryKeys());
            this.firePropertyChange("nonPrimaryKeyColumns", nonPrimaryKeyColumns, this.getNonPrimaryKeyColumns());
        }
    }

    public void moveClusteringKeyUp(Column column) {
        int i = this.clusteringKeys.indexOf(column);
        if (i > 0) {
            ArrayList<Column> oldList = new ArrayList<Column>(this.clusteringKeys);
            Collections.swap(this.clusteringKeys, i, i - 1);
            this.firePropertyChange("clusteringKeys", oldList, this.clusteringKeys);
        }
    }

    public void moveClusteringKeyDown(Column column) {
        int i = this.clusteringKeys.indexOf(column);
        if (i >= 0 && i < this.clusteringKeys.size() - 1) {
            ArrayList<Column> oldList = new ArrayList<Column>(this.clusteringKeys);
            Collections.swap(this.clusteringKeys, i, i + 1);
            this.firePropertyChange("clusteringKeys", oldList, this.clusteringKeys);
        }
    }

    public Table addClusteringOrder(String columnName, ClusteringOrder order) {
        if (columnName != null) {
            this.clusteringOrders.put(columnName, order);
        }
        return this;
    }

    public ClusteringOrder removeClusteringOrder(String columnName) {
        return (ClusteringOrder)((Object)this.clusteringOrders.remove(columnName));
    }

    public ClusteringOrder getClusteringOrder(String columnName) {
        ClusteringOrder n = (ClusteringOrder)((Object)this.clusteringOrders.get(columnName));
        return n == null ? ClusteringOrder.NONE : n;
    }

    public TableOptions getOptions() {
        return this.options;
    }

    public void setOptions(TableOptions options) {
        this.options = options;
        this.firePropertyChange("options", this.options, this.options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  " + String.format("table: %s #%d pk: %s ck: %s", this.name, this.statementIndex, this.partitionKeys, this.clusteringKeys) + "\n");
        String idIndent = "      ";
        List<Column> list = this.columns;
        synchronized (list) {
            for (Column col : this.columns) {
                sb.append(String.valueOf(idIndent) + col.toString() + "\n");
            }
        }
        return sb.toString();
    }

    public static enum ClusteringOrder {
        NONE("NONE", "NONE"),
        ASC("ASC", "DESC"),
        DESC("DESC", "ASC");

        private final String sameOrder;
        private final String oppositeOrder;

        private ClusteringOrder(String sameOrder, String oppositeOrder) {
            this.sameOrder = sameOrder;
            this.oppositeOrder = oppositeOrder;
        }

        public String toString() {
            return this.sameOrder;
        }

        public String getOrder() {
            return this.sameOrder;
        }

        public String getOppositeOrder() {
            return this.oppositeOrder;
        }
    }
}

