/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;

public class Trigger
extends AbstractSchemaElement {
    private Table table;
    private String triggerClassName;

    public Trigger(String name) {
        super(name);
    }

    public Trigger(String name, int scriptLineIndex) {
        this(name);
        this.setStatementIndex(scriptLineIndex);
        this.triggerClassName = null;
    }

    public Table getTable() {
        return this.table;
    }

    public Trigger setTable(Table table) {
        this.table = table;
        return this;
    }

    public String getTriggerClassName() {
        return this.triggerClassName;
    }

    public Trigger setTriggerClassName(String name) {
        this.triggerClassName = name;
        return this;
    }

    @Override
    public Trigger deepCopy(Object parent) {
        Schema parentSchema = (Schema)parent;
        Table newTable = null;
        if (this.table != null) {
            Keyspace newKeyspace = parentSchema.getKeyspace(this.table.getKeyspace().getName());
            newTable = newKeyspace.getTable(this.table.getName());
        }
        Trigger newTrigger = new Trigger(this.name, this.statementIndex);
        newTrigger.setTable(newTable);
        newTrigger.setTriggerClassName(this.triggerClassName);
        return newTrigger;
    }

    public String toString() {
        return String.format("trigger: %s class: %s #%d", this.name, this.triggerClassName, this.statementIndex);
    }
}

