/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.schema.AbstractSchemaElement;

public class User
extends AbstractSchemaElement {
    private boolean isSuperuser = false;
    private boolean canLogin = true;

    public User(String name) {
        super(name);
    }

    public User(String name, int scriptLineIndex) {
        this(name);
        this.setStatementIndex(scriptLineIndex);
    }

    @Override
    public User deepCopy(Object parent) {
        User newUser = new User(this.name, this.statementIndex);
        newUser.isSuperuser = this.isSuperuser;
        newUser.canLogin = this.canLogin;
        return newUser;
    }

    public boolean isSuperuser() {
        return this.isSuperuser;
    }

    public void setSuperuser(boolean isSuperuser) {
        this.isSuperuser = isSuperuser;
        this.firePropertyChange("isSuperuser", this.isSuperuser, this.isSuperuser);
    }

    public boolean isCanLogin() {
        return this.canLogin;
    }

    public void setCanLogin(boolean canLogin) {
        this.canLogin = canLogin;
        this.firePropertyChange("canLogin", this.canLogin, this.canLogin);
    }

    public String toString() {
        return String.format("user: %s %s %s", this.name, this.canLogin ? "login" : "", this.isSuperuser ? "superuser" : "");
    }
}

