/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.schema.AbstractKeyspaceSchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.UserTypeField;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UserType
extends AbstractKeyspaceSchemaElement {
    private final List<UserTypeField> fields = Collections.synchronizedList(new ArrayList());

    public UserType(String name) {
        super(name);
    }

    public UserType(String name, int statementIndex) {
        this(name);
        this.setStatementIndex(statementIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserType deepCopy(Object parent) {
        Keyspace parentKeyspace = (Keyspace)parent;
        UserType newUserType = new UserType(this.name, this.getStatementIndex());
        newUserType.setKeyspace(parentKeyspace);
        List<UserTypeField> list = this.fields;
        synchronized (list) {
            for (UserTypeField field : this.fields) {
                UserTypeField clone = field.deepCopy(newUserType);
                newUserType.addField(clone);
            }
        }
        return newUserType;
    }

    public List<UserTypeField> getFields() {
        return this.fields;
    }

    public UserTypeField getField(String name) {
        UserTypeField result = null;
        if (name != null) {
            for (UserTypeField field : this.fields) {
                if (!name.equals(field.getName())) continue;
                result = field;
                break;
            }
        }
        return result;
    }

    public UserType addField(UserTypeField userTypeField) {
        if (userTypeField != null && userTypeField.getName() != null && !userTypeField.getType().isReachableFrom(this)) {
            this.removeField(userTypeField);
            ArrayList<UserTypeField> oldList = new ArrayList<UserTypeField>(this.fields);
            this.fields.add(userTypeField);
            userTypeField.setUserType(this);
            this.firePropertyChange("fields", oldList, this.fields);
        }
        return this;
    }

    public UserType removeField(String name) {
        UserTypeField field = this.getField(name);
        if (field != null) {
            this.removeField(field);
        }
        return this;
    }

    public void renameField(String oldFieldName, String newFieldName, int statementIndex) {
        this.renameField(this.getField(oldFieldName), newFieldName, statementIndex);
    }

    private void renameField(UserTypeField oldField, String newFieldName, int statementIndex) {
        if (oldField != null) {
            oldField.setName(newFieldName);
            oldField.setStatementIndex(statementIndex);
        }
    }

    public UserType removeField(UserTypeField field) {
        ArrayList<UserTypeField> oldFields = new ArrayList<UserTypeField>(this.fields);
        if (this.fields.remove(field)) {
            this.firePropertyChange("fields", oldFields, this.fields);
        }
        return this;
    }

    public void moveFieldUp(UserTypeField field) {
        int i = this.fields.indexOf(field);
        if (i > 0) {
            ArrayList<UserTypeField> oldFields = new ArrayList<UserTypeField>(this.fields);
            Collections.swap(this.getFields(), i, i - 1);
            this.firePropertyChange("fields", oldFields, this.fields);
        }
    }

    public void moveFieldDown(UserTypeField column) {
        int i = this.fields.indexOf(column);
        if (i >= 0 && i < this.fields.size() - 1) {
            ArrayList<UserTypeField> oldFields = new ArrayList<UserTypeField>(this.fields);
            Collections.swap(this.getFields(), i, i + 1);
            this.firePropertyChange("fields", oldFields, this.fields);
        }
    }

    public boolean isFieldContain(String name) {
        return this.isCollectionOfFieldsContain(this.getFields(), name);
    }

    private boolean isCollectionOfFieldsContain(Collection<UserTypeField> fields, String name) {
        boolean result = false;
        if (fields == null || name == null) {
            return result;
        }
        for (UserTypeField field : fields) {
            if (!Objects.equal((Object)name, (Object)field.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  " + String.format("user type: %s #%d", this.name, this.statementIndex) + "\n");
        String idIndent = "      ";
        for (UserTypeField field : this.fields) {
            sb.append(String.valueOf(idIndent) + field.toString() + "\n");
        }
        return sb.toString();
    }
}

