/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema;

import com.datastax.devcenter.schema.AbstractSchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.KeyspaceProvider;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.types.CqlDataType;

public class UserTypeField
extends AbstractSchemaElement
implements KeyspaceProvider {
    private CqlDataType type;
    private UserType userType;
    private String originalName;

    public UserTypeField(String name, CqlDataType dataType) {
        this(name, name, dataType);
    }

    public UserTypeField(String name, String originalName, CqlDataType dataType) {
        super(name);
        this.type = dataType;
        this.originalName = originalName;
    }

    public UserTypeField(String name, int scriptLineIndex, CqlDataType dataType) {
        this(name, dataType);
        this.setStatementIndex(scriptLineIndex);
    }

    @Override
    public UserTypeField deepCopy(Object parent) {
        UserType parentUserType = (UserType)parent;
        Keyspace parentKeyspace = parentUserType == null ? null : parentUserType.getKeyspace();
        UserTypeField newField = new UserTypeField(this.name, this.statementIndex, this.type.deepCopy(parentKeyspace));
        newField.setUserType(parentUserType);
        return newField;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @Override
    public Keyspace getKeyspace() {
        return this.userType.getKeyspace();
    }

    public UserType getUserType() {
        return this.userType;
    }

    protected void setUserType(UserType userType) {
        this.userType = userType;
        this.firePropertyChange("userType", this.userType, this.userType);
    }

    public CqlDataType getType() {
        return this.type;
    }

    public void setType(CqlDataType type) {
        this.type = type;
        this.firePropertyChange("type", this.type, this.type);
    }

    public String toString() {
        return String.format("type field: %s %s #%d", this.name, this.type, this.statementIndex);
    }
}

