/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.ClassOption;

public enum CompactionStrategy implements ClassOption
{
    SIZE_TIERED("SizeTieredCompactionStrategy", "org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy"),
    DATE_TIERED("DateTieredCompactionStrategy", "org.apache.cassandra.db.compaction.DateTieredCompactionStrategy"),
    LEVELED("LeveledCompactionStrategy", "org.apache.cassandra.db.compaction.LeveledCompactionStrategy");

    private final String simpleName;
    private final String fqdn;

    private CompactionStrategy(String simpleName, String fqdn) {
        this.fqdn = fqdn;
        this.simpleName = simpleName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fqdn;
    }

    public static CompactionStrategy lookup(String name) {
        CompactionStrategy[] compactionStrategyArray = CompactionStrategy.values();
        int n = compactionStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompactionStrategy value = compactionStrategyArray[n2];
            if (value.name().equals(name) || value.fqdn.equals(name) || value.simpleName.equals(name)) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No enum constant found for name: " + name);
    }
}

