/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.ClassOption;

public enum CompressionAlgorithm implements ClassOption
{
    LZ4("LZ4Compressor", "org.apache.cassandra.io.compress.LZ4Compressor"),
    SNAPPY("SnappyCompressor", "org.apache.cassandra.io.compress.SnappyCompressor"),
    DEFLATE("DeflateCompressor", "org.apache.cassandra.io.compress.DeflateCompressor"),
    NONE("", "");

    private final String simpleName;
    private final String fqdn;

    private CompressionAlgorithm(String simpleName, String fqdn) {
        this.fqdn = fqdn;
        this.simpleName = simpleName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fqdn;
    }

    public static CompressionAlgorithm lookup(String name) {
        CompressionAlgorithm[] compressionAlgorithmArray = CompressionAlgorithm.values();
        int n = compressionAlgorithmArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompressionAlgorithm value = compressionAlgorithmArray[n2];
            if (value.name().equals(name) || value.fqdn.equals(name) || value.simpleName.equals(name)) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No enum constant found for name: " + name);
    }
}

