/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.DefaultValue;
import com.datastax.devcenter.schema.options.KeyspaceReplication;
import com.datastax.devcenter.schema.options.OptionName;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class KeyspaceOptions {
    @OptionName(value="durable_writes")
    @DefaultValue(value="true")
    private Boolean durableWrites;
    private KeyspaceReplication replication;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public KeyspaceOptions() {
        this.replication = new KeyspaceReplication();
    }

    public KeyspaceOptions(Boolean durableWrites, KeyspaceReplication replication) {
        this.durableWrites = durableWrites;
        this.replication = replication == null ? null : replication.deepCopy();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public KeyspaceOptions deepCopy() {
        return new KeyspaceOptions(this.durableWrites, this.replication.deepCopy());
    }

    public Boolean getDurableWrites() {
        return this.durableWrites;
    }

    public void setDurableWrites(Boolean durableWrites) {
        this.durableWrites = durableWrites;
        this.firePropertyChange("durableWrites", this.durableWrites, this.durableWrites);
    }

    public KeyspaceReplication getReplication() {
        return this.replication;
    }

    public void setReplication(KeyspaceReplication replication) {
        this.replication = replication;
        this.firePropertyChange("replication", this.replication, this.replication);
    }
}

