/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.DefaultValue;
import com.datastax.devcenter.schema.options.OptionName;
import com.datastax.devcenter.schema.options.ReplicationStrategy;
import com.datastax.devcenter.schema.options.ValidReplicationStrategies;
import com.google.common.base.Objects;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KeyspaceReplication {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    @OptionName(value="class")
    @DefaultValue(value="SimpleStrategy")
    private ReplicationStrategy strategy;
    @OptionName(value="replication_factor")
    @DefaultValue(value="1")
    @ValidReplicationStrategies(value={ReplicationStrategy.SIMPLE})
    private Integer replicationFactor;
    @OptionName(value="data_center")
    @DefaultValue(value="datacenter")
    @ValidReplicationStrategies(value={ReplicationStrategy.NETWORK_TOPOLOGY})
    private List<DataCenter> networkStrategyDataCenters;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public KeyspaceReplication() {
        this.networkStrategyDataCenters = new ArrayList<DataCenter>();
    }

    public KeyspaceReplication(ReplicationStrategy replicationStrategy, Integer replicationFactor) {
        this.strategy = replicationStrategy;
        this.replicationFactor = replicationFactor;
        this.networkStrategyDataCenters = new ArrayList<DataCenter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyspaceReplication deepCopy() {
        KeyspaceReplication copy = new KeyspaceReplication(this.strategy, this.replicationFactor);
        List<DataCenter> list = this.networkStrategyDataCenters;
        synchronized (list) {
            for (DataCenter datacenter : this.networkStrategyDataCenters) {
                copy.addDataCenter(new DataCenter(datacenter.getName(), datacenter.getReplicationFactor()));
            }
        }
        return copy;
    }

    public ReplicationStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ReplicationStrategy strategy) {
        this.strategy = strategy;
        this.firePropertyChange("strategy", this.strategy, this.strategy);
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
        this.firePropertyChange("replicationFactor", this.replicationFactor, this.replicationFactor);
    }

    public List<DataCenter> getNetworkStrategyDataCenters() {
        return this.networkStrategyDataCenters;
    }

    public void setNetworkStrategyDataCenters(List<DataCenter> networkStrategyDataCenters) {
        this.networkStrategyDataCenters = networkStrategyDataCenters;
        this.firePropertyChange("networkStrategyDataCenters", networkStrategyDataCenters, this.networkStrategyDataCenters);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        result = 31 * result + (this.replicationFactor == null ? 0 : this.replicationFactor.hashCode());
        result = 31 * result + (this.networkStrategyDataCenters == null ? 0 : this.networkStrategyDataCenters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyspaceReplication other = (KeyspaceReplication)obj;
        if (this.strategy != other.strategy) {
            return false;
        }
        if (this.replicationFactor == null ? other.replicationFactor != null : !this.replicationFactor.equals(other.replicationFactor)) {
            return false;
        }
        return !(this.networkStrategyDataCenters == null ? other.networkStrategyDataCenters != null : !this.networkStrategyDataCenters.equals(other.networkStrategyDataCenters));
    }

    public boolean isDataCenterContain(String name) {
        List<DataCenter> dataCenters = this.getNetworkStrategyDataCenters();
        boolean result = false;
        if (dataCenters == null || name == null) {
            return result;
        }
        for (DataCenter dc : dataCenters) {
            if (!dc.getName().equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void addDataCenter(DataCenter datacenter) {
        if (datacenter != null && datacenter.getName() != null) {
            ArrayList<DataCenter> oldValue = new ArrayList<DataCenter>(this.getNetworkStrategyDataCenters());
            this.networkStrategyDataCenters.add(datacenter);
            this.firePropertyChange("networkStrategyDataCenters", oldValue, this.getNetworkStrategyDataCenters());
        }
    }

    public void removeDataCenter(DataCenter datacenter) {
        ArrayList<DataCenter> oldValue = new ArrayList<DataCenter>(this.getNetworkStrategyDataCenters());
        if (this.networkStrategyDataCenters.remove(datacenter)) {
            this.firePropertyChange("networkStrategyDataCenters", oldValue, this.getNetworkStrategyDataCenters());
        }
    }

    public void moveDataCenterUp(DataCenter column) {
        int i = this.networkStrategyDataCenters.indexOf(column);
        if (i > 0) {
            ArrayList<DataCenter> oldValue = new ArrayList<DataCenter>(this.getNetworkStrategyDataCenters());
            Collections.swap(this.getNetworkStrategyDataCenters(), i, i - 1);
            this.firePropertyChange("networkStrategyDataCenters", oldValue, this.getNetworkStrategyDataCenters());
        }
    }

    public void moveDataCenterDown(DataCenter column) {
        int i = this.networkStrategyDataCenters.indexOf(column);
        if (i >= 0 && i < this.networkStrategyDataCenters.size() - 1) {
            ArrayList<DataCenter> oldValue = new ArrayList<DataCenter>(this.getNetworkStrategyDataCenters());
            Collections.swap(this.getNetworkStrategyDataCenters(), i, i + 1);
            this.firePropertyChange("networkStrategyDataCenters", oldValue, this.getNetworkStrategyDataCenters());
        }
    }

    public static class DataCenter {
        private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        private String name;
        private Integer replicationFactor;

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }

        public DataCenter(String name, Integer replicationFactor) {
            this.name = name;
            this.replicationFactor = replicationFactor;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        public void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            this.firePropertyChange("replicationFactor", this.replicationFactor, this.replicationFactor);
        }

        public String toString() {
            return String.format("%s:%s", this.name, this.replicationFactor.toString());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DataCenter)) {
                return false;
            }
            DataCenter other = (DataCenter)obj;
            return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.replicationFactor, (Object)other.replicationFactor);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.replicationFactor});
        }
    }
}

