/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.common.utils.BeanPropertyHelper;
import com.datastax.devcenter.common.utils.ConversionHelper;
import com.datastax.devcenter.connections.util.VersionNumberUtils;
import com.datastax.devcenter.schema.options.CompactionStrategy;
import com.datastax.devcenter.schema.options.CompactionStrategyOption;
import com.datastax.devcenter.schema.options.CompactionStrategyOverride;
import com.datastax.devcenter.schema.options.DefaultValue;
import com.datastax.devcenter.schema.options.KeyspaceReplication;
import com.datastax.devcenter.schema.options.OptionName;
import com.datastax.devcenter.schema.options.ReplicationStrategy;
import com.datastax.devcenter.schema.options.RowsCaching;
import com.datastax.devcenter.schema.options.SpeculativeRetry;
import com.datastax.devcenter.schema.options.TableCompaction;
import com.datastax.devcenter.schema.options.ValidCompactionStrategies;
import com.datastax.devcenter.schema.options.ValidReplicationStrategies;
import com.datastax.devcenter.schema.options.ValidVersionRange;
import com.datastax.devcenter.schema.options.ValidVersionRanges;
import com.datastax.devcenter.schema.options.VersionOverride;
import com.datastax.driver.core.VersionNumber;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.xtext.util.Arrays;

public class OptionsHelper {
    static {
        ConversionHelper.register((Converter)new RowsCaching.RowsCachingConverter(), RowsCaching.class);
        ConversionHelper.register((Converter)new SpeculativeRetry.SpeculativeRetryConverter(), SpeculativeRetry.class);
    }

    public static boolean hasOptionName(Class<?> clazz, String property) {
        Field field = BeanPropertyHelper.getPropertyField(clazz, (String)property);
        OptionName ann = field.getAnnotation(OptionName.class);
        return ann != null;
    }

    public static String getOptionName(Class<?> clazz, String property) {
        Field field = BeanPropertyHelper.getPropertyField(clazz, (String)property);
        OptionName ann = field.getAnnotation(OptionName.class);
        if (ann == null) {
            throw new IllegalArgumentException("Field does not have an @OptionName annotation: " + property);
        }
        return ann.value();
    }

    public static void setOptionValue(Object bean, String optionName, String rawValue) {
        Field field = OptionsHelper.getFieldOptionName(bean.getClass(), optionName);
        Object converted = ConversionHelper.convert((Object)rawValue, field.getType());
        BeanPropertyHelper.nullSafeSetProperty((Object)bean, (String)field.getName(), (Object)converted);
    }

    public static boolean isOptionValidForVersion(Class<?> clazz, String property, VersionNumber version) {
        ValidVersionRange[] ranges;
        Field field = BeanPropertyHelper.getPropertyField(clazz, (String)property);
        ValidVersionRange vvr = field.getAnnotation(ValidVersionRange.class);
        if (vvr == null) {
            ValidVersionRanges vvrs = field.getAnnotation(ValidVersionRanges.class);
            if (vvrs == null) {
                return true;
            }
            ranges = vvrs.value();
        } else {
            ranges = new ValidVersionRange[]{vvr};
        }
        return OptionsHelper.isVersionWithinValidRange(ranges, version);
    }

    public static boolean isVersionWithinValidRange(ValidVersionRange[] validRanges, VersionNumber version) {
        ValidVersionRange[] validVersionRangeArray = validRanges;
        int n = validRanges.length;
        int n2 = 0;
        while (n2 < n) {
            ValidVersionRange range = validVersionRangeArray[n2];
            if (VersionNumberUtils.isVersionInRange((VersionNumber)version, (String)range.from(), (String)range.to())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isVersionWithinValidRange(ValidVersionRanges validRanges, VersionNumber version) {
        ValidVersionRange[] ranges = validRanges.value();
        return OptionsHelper.isVersionWithinValidRange(ranges, version);
    }

    private static boolean isOptionValidForStrategy(Object bean, String property, VersionNumber version) {
        if (bean instanceof TableCompaction) {
            CompactionStrategy currentStrategy = ((TableCompaction)bean).getStrategy();
            return OptionsHelper.isOptionValidForCompactionStrategy(bean.getClass(), property, currentStrategy, version);
        }
        if (bean instanceof KeyspaceReplication) {
            ReplicationStrategy currentStrategy = ((KeyspaceReplication)bean).getStrategy();
            return OptionsHelper.isOptionValidForReplicationStrategy(bean.getClass(), property, currentStrategy);
        }
        return true;
    }

    public static boolean isOptionValidForCompactionStrategy(Class<?> clazz, String property, CompactionStrategy strategy, VersionNumber version) {
        CompactionStrategyOption[] validStrategies;
        Field field = BeanPropertyHelper.getPropertyField(clazz, (String)property);
        ValidCompactionStrategies vcs = field.getAnnotation(ValidCompactionStrategies.class);
        if (vcs == null) {
            return true;
        }
        CompactionStrategyOption[] compactionStrategyOptionArray = validStrategies = vcs.value();
        int n = validStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            CompactionStrategyOption validStrategy = compactionStrategyOptionArray[n2];
            boolean isValidForAllVersions = validStrategy.versions().value().length == 0;
            boolean isValidForVersionRange = OptionsHelper.isVersionWithinValidRange(validStrategy.versions(), version);
            if (validStrategy.value() == strategy && (isValidForAllVersions || isValidForVersionRange)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isOptionValidForReplicationStrategy(Class<?> clazz, String property, ReplicationStrategy strategy) {
        Field field = BeanPropertyHelper.getPropertyField(clazz, (String)property);
        ValidReplicationStrategies vrs = field.getAnnotation(ValidReplicationStrategies.class);
        return vrs == null || Arrays.contains((Object[])vrs.value(), (Object)strategy);
    }

    public static Object getOptionDefaultValue(Object bean, String property, VersionNumber version, CompactionStrategy strategy) {
        Field field = BeanPropertyHelper.getPropertyField(bean.getClass(), (String)property);
        DefaultValue ann = field.getAnnotation(DefaultValue.class);
        if (ann == null) {
            return null;
        }
        PropertyDescriptor pd = BeanPropertyHelper.getPropertyDescriptor(bean.getClass(), (String)property);
        Object value = ConversionHelper.convert((Object)ann.value(), pd.getPropertyType());
        if (ann.versionOverrides().length > 0) {
            value = OptionsHelper.overrideByVersion(pd, value, version, ann.versionOverrides());
        }
        if (ann.compactionStrategyOverrides().length > 0) {
            value = OptionsHelper.overrideByCompactionStrategy(pd, value, strategy, ann.compactionStrategyOverrides());
        }
        return value;
    }

    public static Object getOptionCurrentOrDefaultValue(Object bean, String property, VersionNumber version, CompactionStrategy strategy) {
        Object value = BeanPropertyHelper.nullSafeGetProperty((Object)bean, (String)property);
        if (value == null) {
            value = OptionsHelper.getOptionDefaultValue(bean, property, version, strategy);
        }
        return value;
    }

    public static Object getOptionDefaultValue(Object bean, String property, VersionNumber version) {
        Field field = BeanPropertyHelper.getPropertyField(bean.getClass(), (String)property);
        DefaultValue ann = field.getAnnotation(DefaultValue.class);
        if (ann == null) {
            return null;
        }
        PropertyDescriptor pd = BeanPropertyHelper.getPropertyDescriptor(bean.getClass(), (String)property);
        Object value = ConversionHelper.convert((Object)ann.value(), pd.getPropertyType());
        if (ann.versionOverrides().length > 0) {
            value = OptionsHelper.overrideByVersion(pd, value, version, ann.versionOverrides());
        }
        return value;
    }

    public static Object getOptionCurrentOrDefaultValue(Object bean, String property, VersionNumber version) {
        Object value = BeanPropertyHelper.nullSafeGetProperty((Object)bean, (String)property);
        if (value == null) {
            value = OptionsHelper.getOptionDefaultValue(bean, property, version);
        }
        return value;
    }

    public static Map<String, Object> getNonNullOptions(Object bean, VersionNumber version) {
        PropertyDescriptor[] pds;
        TreeMap<String, Object> nonNullOptions = new TreeMap<String, Object>();
        Class<?> beanClass = bean.getClass();
        PropertyDescriptor[] propertyDescriptorArray = pds = PropertyUtils.getPropertyDescriptors(beanClass);
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            String propertyName = pd.getName();
            Class<?> propertyType = pd.getPropertyType();
            Object currentValue = BeanPropertyHelper.nullSafeGetProperty((Object)bean, (String)propertyName);
            if (OptionsHelper.isSimpleProperty(propertyType) && OptionsHelper.hasOptionName(beanClass, propertyName) && OptionsHelper.isOptionValidForVersion(beanClass, propertyName, version) && OptionsHelper.isOptionValidForStrategy(bean, propertyName, version) && currentValue != null) {
                nonNullOptions.put(OptionsHelper.getOptionName(beanClass, propertyName), currentValue);
            }
            ++n2;
        }
        return nonNullOptions;
    }

    public static void setDefaultValueForNullOptions(Object bean, VersionNumber version) {
        PropertyDescriptor[] pds;
        Class<?> beanClass = bean.getClass();
        PropertyDescriptor[] propertyDescriptorArray = pds = PropertyUtils.getPropertyDescriptors(beanClass);
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            String propertyName = pd.getName();
            Class<?> propertyType = pd.getPropertyType();
            Object currentValue = BeanPropertyHelper.nullSafeGetProperty((Object)bean, (String)propertyName);
            if (OptionsHelper.isSimpleProperty(propertyType) && OptionsHelper.hasOptionName(beanClass, propertyName) && OptionsHelper.isOptionValidForVersion(beanClass, propertyName, version) && currentValue == null) {
                BeanPropertyHelper.nullSafeSetProperty((Object)bean, (String)propertyName, (Object)OptionsHelper.getOptionDefaultValue(bean, propertyName, version));
            }
            ++n2;
        }
    }

    public static Map<String, Object> getAlteredOptions(Object initial, Object current, VersionNumber version, CompactionStrategy initialStrategy, CompactionStrategy currentStrategy, boolean subProperties) {
        PropertyDescriptor[] pds;
        TreeMap<String, Object> alteredOptions = new TreeMap<String, Object>();
        TreeMap<String, Object> unalteredOptions = new TreeMap<String, Object>();
        Class<?> beanClass = current.getClass();
        PropertyDescriptor[] propertyDescriptorArray = pds = PropertyUtils.getPropertyDescriptors(beanClass);
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            String propertyName = pd.getName();
            Class<?> propertyType = pd.getPropertyType();
            if (OptionsHelper.isSimpleProperty(propertyType) && OptionsHelper.hasOptionName(beanClass, propertyName) && OptionsHelper.isOptionValidForVersion(beanClass, propertyName, version) && OptionsHelper.isOptionValidForCompactionStrategy(beanClass, propertyName, currentStrategy, version)) {
                boolean altered;
                String optionName = OptionsHelper.getOptionName(beanClass, propertyName);
                Object initialValue = OptionsHelper.getOptionCurrentOrDefaultValue(initial, propertyName, version, initialStrategy);
                Object currentValue = OptionsHelper.getOptionCurrentOrDefaultValue(current, propertyName, version, currentStrategy);
                boolean bl = initialValue == null ? currentValue != null : (altered = !initialValue.equals(currentValue));
                if (altered) {
                    alteredOptions.put(optionName, currentValue);
                } else {
                    unalteredOptions.put(optionName, currentValue);
                }
            }
            ++n2;
        }
        if (!alteredOptions.isEmpty() && subProperties) {
            alteredOptions.putAll(unalteredOptions);
        }
        return alteredOptions;
    }

    public static Map<String, Object> getAlteredOptions(Object initial, Object current, VersionNumber version, ReplicationStrategy initialStrategy, ReplicationStrategy currentStrategy, boolean subProperties) {
        PropertyDescriptor[] pds;
        TreeMap<String, Object> alteredOptions = new TreeMap<String, Object>();
        TreeMap<String, Object> unalteredOptions = new TreeMap<String, Object>();
        Class<?> beanClass = current.getClass();
        PropertyDescriptor[] propertyDescriptorArray = pds = PropertyUtils.getPropertyDescriptors(beanClass);
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            String propertyName = pd.getName();
            Class<?> propertyType = pd.getPropertyType();
            if (OptionsHelper.isSimpleProperty(propertyType) && OptionsHelper.hasOptionName(beanClass, propertyName) && OptionsHelper.isOptionValidForVersion(beanClass, propertyName, version) && OptionsHelper.isOptionValidForReplicationStrategy(beanClass, propertyName, currentStrategy)) {
                boolean altered;
                String optionName = OptionsHelper.getOptionName(beanClass, propertyName);
                Object initialValue = OptionsHelper.getOptionCurrentOrDefaultValue(initial, propertyName, version);
                Object currentValue = OptionsHelper.getOptionCurrentOrDefaultValue(current, propertyName, version);
                boolean bl = initialValue == null ? currentValue != null : (altered = !initialValue.equals(currentValue));
                if (altered) {
                    alteredOptions.put(optionName, currentValue);
                } else {
                    unalteredOptions.put(optionName, currentValue);
                }
            }
            ++n2;
        }
        if (!alteredOptions.isEmpty() && subProperties) {
            alteredOptions.putAll(unalteredOptions);
        }
        return alteredOptions;
    }

    private static Object overrideByVersion(PropertyDescriptor pd, Object defaultValue, VersionNumber version, VersionOverride[] overrides) {
        VersionOverride[] versionOverrideArray = overrides;
        int n = overrides.length;
        int n2 = 0;
        while (n2 < n) {
            VersionOverride override = versionOverrideArray[n2];
            if (VersionNumberUtils.isVersionInRange((VersionNumber)version, (String)override.fromVersion(), (String)override.toVersion())) {
                return ConversionHelper.convert((Object)override.value(), pd.getPropertyType());
            }
            ++n2;
        }
        return defaultValue;
    }

    private static Object overrideByCompactionStrategy(PropertyDescriptor pd, Object defaultValue, CompactionStrategy strategy, CompactionStrategyOverride[] overrides) {
        CompactionStrategyOverride[] compactionStrategyOverrideArray = overrides;
        int n = overrides.length;
        int n2 = 0;
        while (n2 < n) {
            CompactionStrategyOverride override = compactionStrategyOverrideArray[n2];
            if (strategy == override.strategy()) {
                return ConversionHelper.convert((Object)override.value(), pd.getPropertyType());
            }
            ++n2;
        }
        return defaultValue;
    }

    private static boolean isSimpleProperty(Class<?> type) {
        return Number.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || RowsCaching.class.isAssignableFrom(type) || SpeculativeRetry.class.isAssignableFrom(type);
    }

    private static Field getFieldOptionName(Class<?> clazz, String optionName) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            OptionName ann = field.getAnnotation(OptionName.class);
            if (ann != null && ann.value().equals(optionName)) {
                return field;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown option name: " + optionName);
    }
}

