/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.SpeculativeRetry;

public class PercentileSpeculativeRetry
extends SpeculativeRetry {
    private final double percentile;

    public PercentileSpeculativeRetry(double percentile) {
        this.percentile = percentile;
    }

    public double getPercentile() {
        return this.percentile;
    }

    @Override
    public PercentileSpeculativeRetry deepCopy() {
        return new PercentileSpeculativeRetry(this.percentile);
    }

    public String toString() {
        return String.valueOf(this.percentile) + "PERCENTILE";
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.percentile);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PercentileSpeculativeRetry other = (PercentileSpeculativeRetry)obj;
        return Double.doubleToLongBits(this.percentile) == Double.doubleToLongBits(other.percentile);
    }
}

