/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.options.ClassOption;

public enum ReplicationStrategy implements ClassOption
{
    SIMPLE("SimpleStrategy", "org.apache.cassandra.locator.SimpleStrategy"),
    NETWORK_TOPOLOGY("NetworkTopologyStrategy", "org.apache.cassandra.locator.NetworkTopologyStrategy"),
    LOCAL("LocalStrategy", "org.apache.cassandra.locator.LocalStrategy"),
    OLD("OldNetworkTopologyStrategy", "org.apache.cassandra.locator.OldNetworkTopologyStrategy");

    private final String simpleName;
    private final String fqdn;

    private ReplicationStrategy(String simpleName, String fqdn) {
        this.fqdn = fqdn;
        this.simpleName = simpleName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fqdn;
    }

    public boolean matches(String strategy) {
        return (strategy = ModelUtil.stripName(strategy)).equals(this.simpleName) || strategy.equals(this.fqdn);
    }

    public boolean matchesFQDN(String strategy) {
        strategy = ModelUtil.stripName(strategy);
        return strategy.equals(this.fqdn);
    }

    public static ReplicationStrategy lookup(String name) {
        ReplicationStrategy[] replicationStrategyArray = ReplicationStrategy.values();
        int n = replicationStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReplicationStrategy value = replicationStrategyArray[n2];
            if (value.name().equals(name) || value.fqdn.equals(name) || value.simpleName.equals(name)) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No enum constant found for name: " + name);
    }
}

