/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.MillisecondsSpeculativeRetry;
import com.datastax.devcenter.schema.options.PercentileSpeculativeRetry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.Converter;

public class SpeculativeRetry {
    public static SpeculativeRetry ALWAYS = new SpeculativeRetry(){

        public String toString() {
            return "ALWAYS";
        }
    };
    public static SpeculativeRetry NONE = new SpeculativeRetry(){

        public String toString() {
            return "NONE";
        }
    };
    public static final SpeculativeRetry PERCENTILE = new SpeculativeRetry(){

        public String toString() {
            return "PERCENTILE";
        }
    };
    public static final SpeculativeRetry MILLISECONDS = new SpeculativeRetry(){

        public String toString() {
            return "MILLISECONDS";
        }
    };
    public static Pattern PERCENTILE_PATTERN = Pattern.compile("([\\d\\.]+)percentile", 2);
    public static Pattern MILLISECONDS_PATTERN = Pattern.compile("([\\d\\.]+)ms", 2);

    public static SpeculativeRetry parse(String raw) {
        if (raw == null) {
            return null;
        }
        if ("ALWAYS".equalsIgnoreCase(raw)) {
            return ALWAYS;
        }
        if ("NONE".equalsIgnoreCase(raw)) {
            return NONE;
        }
        Matcher matcher = PERCENTILE_PATTERN.matcher(raw);
        if (matcher.matches()) {
            return new PercentileSpeculativeRetry(Double.parseDouble(matcher.group(1)));
        }
        matcher = MILLISECONDS_PATTERN.matcher(raw);
        if (matcher.matches()) {
            return new MillisecondsSpeculativeRetry((int)Double.parseDouble(matcher.group(1)));
        }
        throw new IllegalArgumentException("Cannot parse speculative_retry option: " + raw);
    }

    SpeculativeRetry() {
    }

    public SpeculativeRetry deepCopy() {
        return this;
    }

    public static final class SpeculativeRetryConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            return SpeculativeRetry.parse((String)value);
        }
    }
}

