/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.Caching;
import com.datastax.devcenter.schema.options.DefaultValue;
import com.datastax.devcenter.schema.options.KeysCaching;
import com.datastax.devcenter.schema.options.OptionName;
import com.datastax.devcenter.schema.options.RowsCaching;
import com.datastax.devcenter.schema.options.ValidVersionRange;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TableCaching {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    @OptionName(value="caching")
    @DefaultValue(value="KEYS_ONLY")
    @ValidVersionRange(to="2.1.0-0")
    private Caching value;
    @OptionName(value="keys")
    @DefaultValue(value="ALL")
    @ValidVersionRange(from="2.1.0-0")
    private KeysCaching keys;
    @OptionName(value="rows_per_partition")
    @DefaultValue(value="NONE")
    @ValidVersionRange(from="2.1.0-0")
    private RowsCaching rows;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public TableCaching() {
    }

    public TableCaching(Caching value, KeysCaching keys, RowsCaching rows) {
        this.value = value;
        this.keys = keys;
        this.rows = rows == null ? null : rows.deepCopy();
    }

    public TableCaching deepCopy() {
        return new TableCaching(this.value, this.keys, this.rows);
    }

    public Caching getValue() {
        return this.value;
    }

    public void setValue(Caching value) {
        this.value = value;
    }

    public KeysCaching getKeys() {
        return this.keys;
    }

    public void setKeys(KeysCaching keys) {
        this.keys = keys;
        this.firePropertyChange("keys", (Object)this.keys, (Object)this.keys);
    }

    public RowsCaching getRows() {
        return this.rows;
    }

    public void setRows(RowsCaching rowsPerPartition) {
        this.rows = rowsPerPartition;
        this.firePropertyChange("rows", this.rows, this.rows);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        result = 31 * result + (this.rows == null ? 0 : this.rows.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableCaching other = (TableCaching)obj;
        if (this.keys != other.keys) {
            return false;
        }
        if (this.rows == null ? other.rows != null : !this.rows.equals(other.rows)) {
            return false;
        }
        return this.value == other.value;
    }
}

