/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.CompactionStrategy;
import com.datastax.devcenter.schema.options.CompactionStrategyOption;
import com.datastax.devcenter.schema.options.DefaultValue;
import com.datastax.devcenter.schema.options.OptionName;
import com.datastax.devcenter.schema.options.Ratio;
import com.datastax.devcenter.schema.options.Scalar;
import com.datastax.devcenter.schema.options.TimestampResolution;
import com.datastax.devcenter.schema.options.ValidCompactionStrategies;
import com.datastax.devcenter.schema.options.ValidVersionRange;
import com.datastax.devcenter.schema.options.ValidVersionRanges;
import com.datastax.devcenter.schema.options.VersionOverride;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TableCompaction {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    @OptionName(value="class")
    @DefaultValue(value="SizeTieredCompactionStrategy")
    private CompactionStrategy strategy;
    @OptionName(value="enabled")
    @DefaultValue(value="true")
    @ValidVersionRange(from="2.0.0-0")
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.LEVELED), @CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED), @CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED, versions=@ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")}))})
    private Boolean enabled;
    @OptionName(value="tombstone_compaction_interval")
    @DefaultValue(value="86400")
    @Scalar(value=Scalar.Unit.SECONDS)
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.LEVELED), @CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED), @CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED, versions=@ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")}))})
    private Integer tombstoneCompactionInterval;
    @OptionName(value="tombstone_threshold")
    @DefaultValue(value="0.2")
    @Ratio
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.LEVELED), @CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED), @CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED, versions=@ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")}))})
    private Double tombstoneThreshold;
    @OptionName(value="unchecked_tombstone_compaction")
    @DefaultValue(value="false")
    @ValidVersionRange(from="2.0.9-0")
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.LEVELED), @CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED), @CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED, versions=@ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")}))})
    private Boolean uncheckedTombstoneCompaction;
    @OptionName(value="min_threshold")
    @DefaultValue(value="4")
    @Scalar(value=Scalar.Unit.TABLES)
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED), @CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED, versions=@ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")}))})
    private Integer minThreshold;
    @OptionName(value="max_threshold")
    @DefaultValue(value="32")
    @Scalar(value=Scalar.Unit.TABLES)
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED), @CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED, versions=@ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")}))})
    private Integer maxThreshold;
    @OptionName(value="min_sstable_size")
    @DefaultValue(value="50")
    @Scalar(value=Scalar.Unit.MEGABYTES)
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED)})
    private Integer minSsTableSize;
    @OptionName(value="bucket_high")
    @DefaultValue(value="1.5")
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED)})
    private Double bucketHigh;
    @OptionName(value="bucket_low")
    @DefaultValue(value="0.5")
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED)})
    private Double bucketLow;
    @OptionName(value="cold_reads_to_omit")
    @DefaultValue(value="0.05", versionOverrides={@VersionOverride(fromVersion="2.0.3-0", toVersion="2.1.0-0", value="0")})
    @Ratio
    @ValidVersionRange(from="2.0.3-0")
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.SIZE_TIERED)})
    private Double coldReadsToOmit;
    @OptionName(value="sstable_size_in_mb")
    @DefaultValue(value="160")
    @Scalar(value=Scalar.Unit.MEGABYTES)
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.LEVELED)})
    private Integer ssTableSizeInMB;
    @OptionName(value="base_time_seconds")
    @DefaultValue(value="60", versionOverrides={@VersionOverride(fromVersion="2.0.11-0", toVersion="2.0.12-0", value="3600"), @VersionOverride(fromVersion="2.1.1-0", toVersion="2.1.3-0", value="3600")})
    @Scalar(value=Scalar.Unit.SECONDS)
    @ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")})
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED)})
    private Integer baseTimeSeconds;
    @OptionName(value="max_sstable_age_days")
    @DefaultValue(value="365")
    @Scalar(value=Scalar.Unit.DAYS)
    @ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")})
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED)})
    private Integer maxSsTableAgeDays;
    @OptionName(value="timestamp_resolution")
    @DefaultValue(value="MICROSECONDS")
    @ValidVersionRanges(value={@ValidVersionRange(from="2.0.11-0", to="2.1.0-0"), @ValidVersionRange(from="2.1.1-0")})
    @ValidCompactionStrategies(value={@CompactionStrategyOption(value=CompactionStrategy.DATE_TIERED)})
    private TimestampResolution timestampResolution;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public TableCompaction() {
    }

    public TableCompaction(CompactionStrategy compactionClass, Boolean enabled, Integer maxThreshold, Integer minThreshold, Integer tombstoneCompactionInterval, Double tombstoneThreshold, Boolean uncheckedTombstoneCompaction, Integer minSsTableSize, Double bucketHigh, Double bucketLow, Double coldReadsToOmit, Integer ssTableSizeInMB, Integer baseTimeSeconds, Integer maxSsTableAgeDays, TimestampResolution timestampResolution) {
        this.strategy = compactionClass;
        this.enabled = enabled;
        this.maxThreshold = maxThreshold;
        this.minThreshold = minThreshold;
        this.tombstoneCompactionInterval = tombstoneCompactionInterval;
        this.tombstoneThreshold = tombstoneThreshold;
        this.uncheckedTombstoneCompaction = uncheckedTombstoneCompaction;
        this.minSsTableSize = minSsTableSize;
        this.bucketHigh = bucketHigh;
        this.bucketLow = bucketLow;
        this.coldReadsToOmit = coldReadsToOmit;
        this.ssTableSizeInMB = ssTableSizeInMB;
        this.baseTimeSeconds = baseTimeSeconds;
        this.maxSsTableAgeDays = maxSsTableAgeDays;
        this.timestampResolution = timestampResolution;
    }

    public TableCompaction deepCopy() {
        return new TableCompaction(this.strategy, this.enabled, this.maxThreshold, this.minThreshold, this.tombstoneCompactionInterval, this.tombstoneThreshold, this.uncheckedTombstoneCompaction, this.minSsTableSize, this.bucketHigh, this.bucketLow, this.coldReadsToOmit, this.ssTableSizeInMB, this.baseTimeSeconds, this.maxSsTableAgeDays, this.timestampResolution);
    }

    public CompactionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(CompactionStrategy strategy) {
        this.strategy = strategy;
        this.firePropertyChange("strategy", this.strategy, this.strategy);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
        this.firePropertyChange("enabled", this.enabled, this.enabled);
    }

    public Integer getMaxThreshold() {
        return this.maxThreshold;
    }

    public void setMaxThreshold(Integer maxThreshold) {
        this.maxThreshold = maxThreshold;
        this.firePropertyChange("maxThreshold", this.maxThreshold, this.maxThreshold);
    }

    public Integer getMinThreshold() {
        return this.minThreshold;
    }

    public void setMinThreshold(Integer minThreshold) {
        this.minThreshold = minThreshold;
        this.firePropertyChange("minThreshold", this.minThreshold, this.minThreshold);
    }

    public Integer getTombstoneCompactionInterval() {
        return this.tombstoneCompactionInterval;
    }

    public void setTombstoneCompactionInterval(Integer tombstoneCompactionInterval) {
        this.tombstoneCompactionInterval = tombstoneCompactionInterval;
        this.firePropertyChange("tombstoneCompactionInterval", this.tombstoneCompactionInterval, this.tombstoneCompactionInterval);
    }

    public Double getTombstoneThreshold() {
        return this.tombstoneThreshold;
    }

    public void setTombstoneThreshold(Double tombstoneThreshold) {
        this.tombstoneThreshold = tombstoneThreshold;
        this.firePropertyChange("tombstoneThreshold", this.tombstoneThreshold, this.tombstoneThreshold);
    }

    public Boolean getUncheckedTombstoneCompaction() {
        return this.uncheckedTombstoneCompaction;
    }

    public void setUncheckedTombstoneCompaction(Boolean uncheckedTombstoneCompaction) {
        this.uncheckedTombstoneCompaction = uncheckedTombstoneCompaction;
        this.firePropertyChange("uncheckedTombstoneCompaction", this.uncheckedTombstoneCompaction, this.uncheckedTombstoneCompaction);
    }

    public Integer getMinSsTableSize() {
        return this.minSsTableSize;
    }

    public void setMinSsTableSize(Integer minSsTableSize) {
        this.minSsTableSize = minSsTableSize;
        this.firePropertyChange("minSsTableSize", this.minSsTableSize, this.minSsTableSize);
    }

    public Double getBucketHigh() {
        return this.bucketHigh;
    }

    public void setBucketHigh(Double bucketHigh) {
        this.bucketHigh = bucketHigh;
        this.firePropertyChange("bucketHigh", this.bucketHigh, this.bucketHigh);
    }

    public Double getBucketLow() {
        return this.bucketLow;
    }

    public void setBucketLow(Double bucketLow) {
        this.bucketLow = bucketLow;
        this.firePropertyChange("bucketLow", this.bucketLow, this.bucketLow);
    }

    public Double getColdReadsToOmit() {
        return this.coldReadsToOmit;
    }

    public void setColdReadsToOmit(Double coldReadsToOmit) {
        this.coldReadsToOmit = coldReadsToOmit;
        this.firePropertyChange("coldReadsToOmit", this.coldReadsToOmit, this.coldReadsToOmit);
    }

    public Integer getSsTableSizeInMB() {
        return this.ssTableSizeInMB;
    }

    public void setSsTableSizeInMB(Integer ssTableSizeInMB) {
        this.ssTableSizeInMB = ssTableSizeInMB;
        this.firePropertyChange("ssTableSizeInMB", this.ssTableSizeInMB, this.ssTableSizeInMB);
    }

    public Integer getBaseTimeSeconds() {
        return this.baseTimeSeconds;
    }

    public void setBaseTimeSeconds(Integer baseTimeSeconds) {
        this.baseTimeSeconds = baseTimeSeconds;
        this.firePropertyChange("baseTimeSeconds", this.baseTimeSeconds, this.baseTimeSeconds);
    }

    public Integer getMaxSsTableAgeDays() {
        return this.maxSsTableAgeDays;
    }

    public void setMaxSsTableAgeDays(Integer maxSsTableAgeDays) {
        this.maxSsTableAgeDays = maxSsTableAgeDays;
        this.firePropertyChange("maxSsTableAgeDays", this.maxSsTableAgeDays, this.maxSsTableAgeDays);
    }

    public TimestampResolution getTimestampResolution() {
        return this.timestampResolution;
    }

    public void setTimestampResolution(TimestampResolution timestampResolution) {
        this.timestampResolution = timestampResolution;
        this.firePropertyChange("timestampResolution", (Object)this.timestampResolution, (Object)this.timestampResolution);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.baseTimeSeconds == null ? 0 : this.baseTimeSeconds.hashCode());
        result = 31 * result + (this.bucketHigh == null ? 0 : this.bucketHigh.hashCode());
        result = 31 * result + (this.bucketLow == null ? 0 : this.bucketLow.hashCode());
        result = 31 * result + (this.coldReadsToOmit == null ? 0 : this.coldReadsToOmit.hashCode());
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.maxSsTableAgeDays == null ? 0 : this.maxSsTableAgeDays.hashCode());
        result = 31 * result + (this.maxThreshold == null ? 0 : this.maxThreshold.hashCode());
        result = 31 * result + (this.minSsTableSize == null ? 0 : this.minSsTableSize.hashCode());
        result = 31 * result + (this.minThreshold == null ? 0 : this.minThreshold.hashCode());
        result = 31 * result + (this.ssTableSizeInMB == null ? 0 : this.ssTableSizeInMB.hashCode());
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        result = 31 * result + (this.timestampResolution == null ? 0 : this.timestampResolution.hashCode());
        result = 31 * result + (this.tombstoneCompactionInterval == null ? 0 : this.tombstoneCompactionInterval.hashCode());
        result = 31 * result + (this.tombstoneThreshold == null ? 0 : this.tombstoneThreshold.hashCode());
        result = 31 * result + (this.uncheckedTombstoneCompaction == null ? 0 : this.uncheckedTombstoneCompaction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableCompaction other = (TableCompaction)obj;
        if (this.baseTimeSeconds == null ? other.baseTimeSeconds != null : !this.baseTimeSeconds.equals(other.baseTimeSeconds)) {
            return false;
        }
        if (this.bucketHigh == null ? other.bucketHigh != null : !this.bucketHigh.equals(other.bucketHigh)) {
            return false;
        }
        if (this.bucketLow == null ? other.bucketLow != null : !this.bucketLow.equals(other.bucketLow)) {
            return false;
        }
        if (this.coldReadsToOmit == null ? other.coldReadsToOmit != null : !this.coldReadsToOmit.equals(other.coldReadsToOmit)) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.maxSsTableAgeDays == null ? other.maxSsTableAgeDays != null : !this.maxSsTableAgeDays.equals(other.maxSsTableAgeDays)) {
            return false;
        }
        if (this.maxThreshold == null ? other.maxThreshold != null : !this.maxThreshold.equals(other.maxThreshold)) {
            return false;
        }
        if (this.minSsTableSize == null ? other.minSsTableSize != null : !this.minSsTableSize.equals(other.minSsTableSize)) {
            return false;
        }
        if (this.minThreshold == null ? other.minThreshold != null : !this.minThreshold.equals(other.minThreshold)) {
            return false;
        }
        if (this.ssTableSizeInMB == null ? other.ssTableSizeInMB != null : !this.ssTableSizeInMB.equals(other.ssTableSizeInMB)) {
            return false;
        }
        if (this.strategy != other.strategy) {
            return false;
        }
        if (this.timestampResolution != other.timestampResolution) {
            return false;
        }
        if (this.tombstoneCompactionInterval == null ? other.tombstoneCompactionInterval != null : !this.tombstoneCompactionInterval.equals(other.tombstoneCompactionInterval)) {
            return false;
        }
        if (this.tombstoneThreshold == null ? other.tombstoneThreshold != null : !this.tombstoneThreshold.equals(other.tombstoneThreshold)) {
            return false;
        }
        return !(this.uncheckedTombstoneCompaction == null ? other.uncheckedTombstoneCompaction != null : !this.uncheckedTombstoneCompaction.equals(other.uncheckedTombstoneCompaction));
    }
}

