/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.CompressionAlgorithm;
import com.datastax.devcenter.schema.options.DefaultValue;
import com.datastax.devcenter.schema.options.OptionName;
import com.datastax.devcenter.schema.options.Ratio;
import com.datastax.devcenter.schema.options.Scalar;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TableCompression {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    @OptionName(value="sstable_compression")
    @DefaultValue(value="SNAPPY")
    private CompressionAlgorithm algorithm;
    @OptionName(value="chunk_length_kb")
    @DefaultValue(value="64")
    @Scalar(value=Scalar.Unit.KILOBYTES)
    private Integer chunkLengthKb;
    @OptionName(value="crc_check_chance")
    @DefaultValue(value="1.0")
    @Ratio
    private Double crcCheckChance;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public TableCompression() {
    }

    public TableCompression(CompressionAlgorithm algorithm, Integer chunkLengthKb, Double crcCheckChance) {
        this.algorithm = algorithm;
        this.chunkLengthKb = chunkLengthKb;
        this.crcCheckChance = crcCheckChance;
    }

    public CompressionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(CompressionAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.firePropertyChange("algorithm", this.algorithm, this.algorithm);
    }

    public Integer getChunkLengthKb() {
        return this.chunkLengthKb;
    }

    public void setChunkLengthKb(Integer chunkLengthKb) {
        this.chunkLengthKb = chunkLengthKb;
        this.firePropertyChange("chunkLengthKb", this.chunkLengthKb, this.chunkLengthKb);
    }

    public Double getCrcCheckChance() {
        return this.crcCheckChance;
    }

    public void setCrcCheckChance(Double crcCheckChance) {
        this.crcCheckChance = crcCheckChance;
        this.firePropertyChange("crcCheckChance", this.crcCheckChance, this.crcCheckChance);
    }

    public TableCompression deepCopy() {
        return new TableCompression(this.algorithm, this.chunkLengthKb, this.crcCheckChance);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.chunkLengthKb == null ? 0 : this.chunkLengthKb.hashCode());
        result = 31 * result + (this.crcCheckChance == null ? 0 : this.crcCheckChance.hashCode());
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableCompression other = (TableCompression)obj;
        if (this.chunkLengthKb == null ? other.chunkLengthKb != null : !this.chunkLengthKb.equals(other.chunkLengthKb)) {
            return false;
        }
        if (this.crcCheckChance == null ? other.crcCheckChance != null : !this.crcCheckChance.equals(other.crcCheckChance)) {
            return false;
        }
        return this.algorithm == other.algorithm;
    }
}

