/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.options;

import com.datastax.devcenter.schema.options.CompactionStrategy;
import com.datastax.devcenter.schema.options.CompactionStrategyOverride;
import com.datastax.devcenter.schema.options.DefaultValue;
import com.datastax.devcenter.schema.options.OptionName;
import com.datastax.devcenter.schema.options.Ratio;
import com.datastax.devcenter.schema.options.Scalar;
import com.datastax.devcenter.schema.options.SpeculativeRetry;
import com.datastax.devcenter.schema.options.TableCaching;
import com.datastax.devcenter.schema.options.TableCompaction;
import com.datastax.devcenter.schema.options.TableCompression;
import com.datastax.devcenter.schema.options.ValidVersionRange;
import com.datastax.devcenter.schema.options.VersionOverride;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TableOptions {
    @OptionName(value="comment")
    private String comment;
    @DefaultValue(value="0.01", compactionStrategyOverrides={@CompactionStrategyOverride(strategy=CompactionStrategy.LEVELED, value="0.1")})
    @OptionName(value="bloom_filter_fp_chance")
    @Ratio
    private Double bloomFilterFPChance;
    @DefaultValue(value="0.0", versionOverrides={@VersionOverride(toVersion="2.0.9-0", value="0.1")})
    @OptionName(value="read_repair_chance")
    @Ratio
    private Double readRepairChance;
    @DefaultValue(value="0.1", versionOverrides={@VersionOverride(toVersion="2.0.9-0", value="0.0")})
    @OptionName(value="dclocal_read_repair_chance")
    @Ratio
    private Double dcLocalReadRepairChance;
    @OptionName(value="default_time_to_live")
    @DefaultValue(value="0")
    @Scalar(value=Scalar.Unit.SECONDS)
    @ValidVersionRange(from="2.0.0-0")
    private Integer defaultTimeToLive;
    @OptionName(value="gc_grace_seconds")
    @DefaultValue(value="864000")
    @Scalar(value=Scalar.Unit.SECONDS)
    private Integer gcGraceSeconds;
    @OptionName(value="index_interval")
    @DefaultValue(value="128")
    @Scalar(value=Scalar.Unit.ROWS)
    @ValidVersionRange(from="2.0.0-0", to="2.1.0-0")
    private Integer indexInterval;
    @OptionName(value="min_index_interval")
    @DefaultValue(value="128")
    @Scalar(value=Scalar.Unit.ROWS)
    @ValidVersionRange(from="2.1.0-0")
    private Integer minIndexInterval;
    @OptionName(value="max_index_interval")
    @DefaultValue(value="2048")
    @Scalar(value=Scalar.Unit.ROWS)
    @ValidVersionRange(from="2.1.0-0")
    private Integer maxIndexInterval;
    @OptionName(value="memtable_flush_period_in_ms")
    @DefaultValue(value="0")
    @Scalar(value=Scalar.Unit.MILLISECONDS)
    @ValidVersionRange(from="2.0.0-0")
    private Integer memtableFlushPeriodInMs;
    @OptionName(value="populate_io_cache_on_flush")
    @DefaultValue(value="false")
    @ValidVersionRange(from="2.0.0-0", to="2.1.0-0")
    private Boolean populateIOCacheOnFlush;
    @OptionName(value="replicate_on_write")
    @DefaultValue(value="true")
    @ValidVersionRange(from="2.0.0-0", to="2.1.0-0")
    private Boolean replicateOnWrite;
    @OptionName(value="speculative_retry")
    @DefaultValue(value="99.0percentile")
    @ValidVersionRange(from="2.0.2-0")
    private SpeculativeRetry speculativeRetry;
    private TableCaching caching;
    private TableCompaction compaction;
    private TableCompression compression;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public TableOptions() {
    }

    public TableOptions(String comment, Double bloomFilterFPChance, Double readRepairChance, Double dcLocalReadRepairChance, Integer defaultTimeToLive, Integer gcGraceSeconds, Integer minIndexInterval, Integer maxIndexInterval, Integer indexInterval, Integer memtableFlushPeriodInMs, Boolean populateIOCacheOnFlush, Boolean replicateOnWrite, SpeculativeRetry speculativeRetry, TableCaching caching, TableCompaction compaction, TableCompression compression) {
        this.comment = comment;
        this.bloomFilterFPChance = bloomFilterFPChance;
        this.readRepairChance = readRepairChance;
        this.dcLocalReadRepairChance = dcLocalReadRepairChance;
        this.defaultTimeToLive = defaultTimeToLive;
        this.gcGraceSeconds = gcGraceSeconds;
        this.minIndexInterval = minIndexInterval;
        this.maxIndexInterval = maxIndexInterval;
        this.indexInterval = indexInterval;
        this.memtableFlushPeriodInMs = memtableFlushPeriodInMs;
        this.populateIOCacheOnFlush = populateIOCacheOnFlush;
        this.replicateOnWrite = replicateOnWrite;
        this.speculativeRetry = speculativeRetry == null ? null : speculativeRetry.deepCopy();
        this.caching = caching == null ? null : caching.deepCopy();
        this.compaction = compaction == null ? null : compaction.deepCopy();
        this.compression = compression == null ? null : compression.deepCopy();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public TableOptions deepCopy() {
        return new TableOptions(this.comment, this.bloomFilterFPChance, this.readRepairChance, this.dcLocalReadRepairChance, this.defaultTimeToLive, this.gcGraceSeconds, this.minIndexInterval, this.maxIndexInterval, this.indexInterval, this.memtableFlushPeriodInMs, this.populateIOCacheOnFlush, this.replicateOnWrite, this.speculativeRetry, this.caching, this.compaction, this.compression);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.firePropertyChange("comment", this.comment, this.comment);
    }

    public Double getBloomFilterFPChance() {
        return this.bloomFilterFPChance;
    }

    public void setBloomFilterFPChance(Double bloomFilterFPChance) {
        this.bloomFilterFPChance = bloomFilterFPChance;
        this.firePropertyChange("bloomFilterFPChance", this.bloomFilterFPChance, this.bloomFilterFPChance);
    }

    public Double getReadRepairChance() {
        return this.readRepairChance;
    }

    public void setReadRepairChance(Double readRepairChance) {
        this.readRepairChance = readRepairChance;
        this.firePropertyChange("readRepairChance", this.readRepairChance, this.readRepairChance);
    }

    public Double getDcLocalReadRepairChance() {
        return this.dcLocalReadRepairChance;
    }

    public void setDcLocalReadRepairChance(Double dcLocalReadRepairChance) {
        this.dcLocalReadRepairChance = dcLocalReadRepairChance;
        this.firePropertyChange("dcLocalReadRepairChance", this.dcLocalReadRepairChance, this.dcLocalReadRepairChance);
    }

    public Integer getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public void setDefaultTimeToLive(Integer defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
        this.firePropertyChange("defaultTimeToLive", this.defaultTimeToLive, this.defaultTimeToLive);
    }

    public Integer getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public void setGcGraceSeconds(Integer gcGraceSeconds) {
        this.gcGraceSeconds = gcGraceSeconds;
        this.firePropertyChange("gcGraceSeconds", this.gcGraceSeconds, this.gcGraceSeconds);
    }

    public Integer getMinIndexInterval() {
        return this.minIndexInterval;
    }

    public void setMinIndexInterval(Integer minIndexInterval) {
        this.minIndexInterval = minIndexInterval;
        this.firePropertyChange("minIndexInterval", this.minIndexInterval, this.minIndexInterval);
    }

    public Integer getMaxIndexInterval() {
        return this.maxIndexInterval;
    }

    public void setMaxIndexInterval(Integer maxIndexInterval) {
        this.maxIndexInterval = maxIndexInterval;
        this.firePropertyChange("maxIndexInterval", this.maxIndexInterval, this.maxIndexInterval);
    }

    public Integer getIndexInterval() {
        return this.indexInterval;
    }

    public void setIndexInterval(Integer indexInterval) {
        this.indexInterval = indexInterval;
        this.firePropertyChange("indexInterval", this.indexInterval, this.indexInterval);
    }

    public Integer getMemtableFlushPeriodInMs() {
        return this.memtableFlushPeriodInMs;
    }

    public void setMemtableFlushPeriodInMs(Integer memtableFlushPeriodInMs) {
        this.memtableFlushPeriodInMs = memtableFlushPeriodInMs;
        this.firePropertyChange("memtableFlushPeriodInMs", this.memtableFlushPeriodInMs, this.memtableFlushPeriodInMs);
    }

    public Boolean getPopulateIOCacheOnFlush() {
        return this.populateIOCacheOnFlush;
    }

    public void setPopulateIOCacheOnFlush(Boolean populateIOCacheOnFlush) {
        this.populateIOCacheOnFlush = populateIOCacheOnFlush;
        this.firePropertyChange("populateIOCacheOnFlush", this.populateIOCacheOnFlush, this.populateIOCacheOnFlush);
    }

    public Boolean getReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    public void setReplicateOnWrite(Boolean replicateOnWrite) {
        this.replicateOnWrite = replicateOnWrite;
        this.firePropertyChange("replicateOnWrite", this.replicateOnWrite, this.replicateOnWrite);
    }

    public SpeculativeRetry getSpeculativeRetry() {
        return this.speculativeRetry;
    }

    public void setSpeculativeRetry(SpeculativeRetry speculativeRetry) {
        this.speculativeRetry = speculativeRetry;
        this.firePropertyChange("speculativeRetry", this.speculativeRetry, this.speculativeRetry);
    }

    public TableCaching getCaching() {
        return this.caching;
    }

    public void setCaching(TableCaching caching) {
        this.caching = caching;
        this.firePropertyChange("caching", this.caching, this.caching);
    }

    public TableCompaction getCompaction() {
        return this.compaction;
    }

    public void setCompaction(TableCompaction compaction) {
        this.compaction = compaction;
        this.firePropertyChange("compaction", this.compaction, this.compaction);
    }

    public TableCompression getCompression() {
        return this.compression;
    }

    public void setCompression(TableCompression compression) {
        this.compression = compression;
        this.firePropertyChange("compression", this.compression, this.compression);
    }
}

