/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractDecimalCqlDataType
extends NativeCqlDataType {
    private static final Pattern patternFloat = Pattern.compile("^-?\\d+(\\.\\d*)?([eE][+-]?\\d+)?$");

    AbstractDecimalCqlDataType(String canonicalString) {
        super(canonicalString);
    }

    @Override
    public boolean validate(String value) {
        if (super.validate(value)) {
            return true;
        }
        if ("NaN".equals(value) || "Infinity".equals(value)) {
            return true;
        }
        Matcher matcherFloat = patternFloat.matcher(value);
        return matcherFloat.matches();
    }
}

