/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AsciiTextCqlTextDataType
extends NativeCqlDataType {
    public static final AsciiTextCqlTextDataType INSTANCE = new AsciiTextCqlTextDataType();
    private final Pattern patternAscii = Pattern.compile("^\\p{ASCII}*$");

    private AsciiTextCqlTextDataType() {
        super("ascii");
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public boolean validate(String value) {
        if (super.validate(value)) {
            return true;
        }
        if (!value.startsWith("'") || !value.endsWith("'")) {
            return false;
        }
        Matcher matcherAscii = this.patternAscii.matcher(value);
        return matcherAscii.matches();
    }
}

