/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.AbstractIntegerCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;

public final class BigIntCqlDataType
extends AbstractIntegerCqlDataType {
    public static final BigIntCqlDataType INSTANCE = new BigIntCqlDataType();

    private BigIntCqlDataType() {
        super("bigint");
    }

    @Override
    public boolean validate(String value) {
        if (super.validate(value)) {
            try {
                Long.parseLong(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isCompatibleWith(CqlDataType other) {
        return super.isCompatibleWith(other) || TIMESTAMP.equals(other);
    }
}

