/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BlobCqlDataType
extends NativeCqlDataType {
    private static final Pattern HEX_NUMBER = Pattern.compile("0[xX][0-9A-Fa-f]+");
    public static final BlobCqlDataType INSTANCE = new BlobCqlDataType();

    private BlobCqlDataType() {
        super("blob");
    }

    @Override
    public boolean validate(String value) {
        Matcher matcher;
        return value.length() % 2 == 0 && (matcher = HEX_NUMBER.matcher(value)).matches();
    }

    @Override
    public boolean isCompatibleWith(CqlDataType other) {
        return true;
    }
}

