/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.types.ComplexCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import java.util.Collection;

public abstract class CollectionCqlDataType
extends ComplexCqlDataType {
    protected final CqlDataType elementType;

    CollectionCqlDataType(CqlDataType elementType) {
        this.elementType = elementType;
    }

    public CqlDataType getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isReachableFrom(UserType targetUserType) {
        return this.elementType.isReachableFrom(targetUserType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        CollectionCqlDataType other = (CollectionCqlDataType)obj;
        return !(this.elementType == null ? other.elementType != null : !this.elementType.equals(other.elementType));
    }

    protected AssignabilityType testAssignabilityOfElements(Collection<Term> terms, CqlDataType elementType, Schema schema, Keyspace ks) {
        AssignabilityType assignabilityType = AssignabilityType.EXACT_MATCH;
        for (Term t : terms) {
            AssignabilityType valueAssignabilityType = elementType.testAssignment(t, schema, ks);
            if (assignabilityType.isNotAssignable()) continue;
            if (valueAssignabilityType.isNotAssignable()) {
                assignabilityType = AssignabilityType.NOT_ASSIGNABLE;
                continue;
            }
            if (!valueAssignabilityType.isWeaklyAssignable()) continue;
            assignabilityType = AssignabilityType.WEAKLY_ASSIGNABLE;
        }
        return assignabilityType;
    }
}

