/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.schema.types.CqlDataType;

public abstract class ComplexCqlDataType
extends CqlDataType {
    protected boolean frozen = false;

    ComplexCqlDataType() {
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public final Type toGrammarType() {
        Type type = this.toCanonicalGrammarType();
        if (this.isFrozen()) {
            Type frozenType = CqlFactory.eINSTANCE.createType();
            frozenType.setFrozenType(type);
            return frozenType;
        }
        return type;
    }

    protected abstract Type toCanonicalGrammarType();

    @Override
    public final boolean validate(String value) {
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Boolean.valueOf(this.frozen).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplexCqlDataType)) {
            return false;
        }
        ComplexCqlDataType other = (ComplexCqlDataType)obj;
        return this.frozen == other.frozen;
    }

    @Override
    public String toString() {
        String format = this.isFrozen() ? "frozen<%s>" : "%s";
        return String.format(format, this.toCanonicalString());
    }
}

