/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.validation.FunctionUtil;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.cql.validation.assignment.Assignment;
import com.datastax.devcenter.cql.validation.assignment.AssignmentTester;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import com.google.common.base.Function;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class CqlDataType {
    public static Function<CqlDataType, Type> TO_GRAMMAR_TYPE = new Function<CqlDataType, Type>(){

        public Type apply(CqlDataType input) {
            return input.toGrammarType();
        }
    };
    public static Function<CqlDataType, String> TO_CANONICAL_STRING = new Function<CqlDataType, String>(){

        public String apply(CqlDataType input) {
            return input.toCanonicalString();
        }
    };

    CqlDataType() {
    }

    public boolean isFrozen() {
        return false;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public boolean isSet() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public boolean isUserDefinedType() {
        return false;
    }

    public boolean isTuple() {
        return false;
    }

    public boolean isCustom() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public abstract CqlDataType deepCopy(Keyspace var1);

    public abstract Type toGrammarType();

    public abstract String toCanonicalString();

    public boolean validate(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return "null".equalsIgnoreCase(value);
    }

    public AssignabilityType testAssignment(Term term, Schema schema, Keyspace ks) {
        Value value;
        if (term == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        if (term.getValue() != null && (value = term.getValue()) != null && value.isNil()) {
            return AssignabilityType.WEAKLY_ASSIGNABLE;
        }
        if (term.getCastType() != null) {
            CqlDataType type = CqlDataTypeFactory.fromTermType(term, schema, ks);
            return AssignmentTester.testAssignment(Assignment.create(type, null), this, schema, ks);
        }
        if (term.getFunctionName() != null) {
            List<Assignment> args = CqlDataTypeFactory.fromFunctionArgumentTypes(term.getFunctionName(), term.getArgs(), schema);
            List<SchemaFunction> schemaFunctions = FunctionUtil.findMatchingFunctions(term.getFunctionName(), args, schema, false);
            if (schemaFunctions.size() == 1) {
                CqlDataType type = schemaFunctions.get(0).getReturnType();
                if (type.equals(UnknownCqlDataType.INSTANCE)) {
                    return AssignabilityType.WEAKLY_ASSIGNABLE;
                }
                return AssignmentTester.testAssignment(Assignment.create(type, null), this, schema, ks);
            }
            return AssignabilityType.WEAKLY_ASSIGNABLE;
        }
        AssignabilityType assignabilityType = this.testAssignmentInternal(term.getValue(), schema, ks);
        if (assignabilityType.isNotAssignable() && term.getAlternateValue() != null && (assignabilityType = this.testAssignmentInternal(term.getAlternateValue(), schema, ks)).isNotAssignable() && !this.isText()) {
            term.setValue((Value)EcoreUtil.copy((EObject)term.getAlternateValue()));
        }
        return assignabilityType;
    }

    protected abstract AssignabilityType testAssignmentInternal(Value var1, Schema var2, Keyspace var3);

    public boolean validate(Term term) {
        Term castTerm;
        CqlDataType castCqlDataType;
        Type castType;
        if (term == null) {
            return false;
        }
        if (term.getFunctionName() != null) {
            return true;
        }
        Value value = term.getValue();
        if (value != null) {
            if (value.isNil()) {
                return true;
            }
            if (value.getConstant() != null) {
                return this.validate(value.getConstant().getValue());
            }
        }
        if ((castType = term.getCastType()) != null && (castCqlDataType = CqlDataTypeFactory.fromGrammarType(castType, null)).validate(castTerm = term.getTerm())) {
            return this.isValueCompatibleWith(castCqlDataType);
        }
        return false;
    }

    public abstract boolean isReachableFrom(UserType var1);

    public boolean isCompatibleWith(CqlDataType other) {
        return this.equals(other);
    }

    public boolean isValueCompatibleWith(CqlDataType other) {
        return this.isCompatibleWith(other);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        return this.toCanonicalString();
    }

    public static class DeepCopy
    implements Function<CqlDataType, CqlDataType> {
        private final Keyspace keyspace;

        public DeepCopy(Keyspace keyspace) {
            this.keyspace = keyspace;
        }

        public CqlDataType apply(CqlDataType input) {
            return input.deepCopy(this.keyspace);
        }
    }
}

