/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.BooleanValue;
import com.datastax.devcenter.cql.cql.CollectionLiteral;
import com.datastax.devcenter.cql.cql.CollectionType;
import com.datastax.devcenter.cql.cql.ConstantValue;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.FloatValue;
import com.datastax.devcenter.cql.cql.Function;
import com.datastax.devcenter.cql.cql.FunctionArgs;
import com.datastax.devcenter.cql.cql.HexValue;
import com.datastax.devcenter.cql.cql.IntegerValue;
import com.datastax.devcenter.cql.cql.ListLiteral;
import com.datastax.devcenter.cql.cql.ListType;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.MapType;
import com.datastax.devcenter.cql.cql.SetLiteral;
import com.datastax.devcenter.cql.cql.SetType;
import com.datastax.devcenter.cql.cql.StringValue;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TupleLiteral;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.UUIDValue;
import com.datastax.devcenter.cql.cql.UnrepresentableNumericValue;
import com.datastax.devcenter.cql.cql.UserTypeEntry;
import com.datastax.devcenter.cql.cql.UserTypeLiteral;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.FunctionUtil;
import com.datastax.devcenter.cql.validation.assignment.Assignment;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.BlobCqlDataType;
import com.datastax.devcenter.schema.types.BooleanCqlDataType;
import com.datastax.devcenter.schema.types.ComplexCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CustomCqlDataType;
import com.datastax.devcenter.schema.types.FloatCqlDataType;
import com.datastax.devcenter.schema.types.ImmutableCqlDataType;
import com.datastax.devcenter.schema.types.IntCqlDataType;
import com.datastax.devcenter.schema.types.ListCqlDataType;
import com.datastax.devcenter.schema.types.MapCqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.devcenter.schema.types.SetCqlDataType;
import com.datastax.devcenter.schema.types.TextCqlDataType;
import com.datastax.devcenter.schema.types.TupleCqlDataType;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import com.datastax.devcenter.schema.types.UserDefinedTypeCqlDataType;
import com.datastax.devcenter.schema.types.UuidCqlDataType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class CqlDataTypeFactory {
    public static CqlDataType fromGrammarType(Type grammarType, Keyspace keyspace) {
        if (grammarType == null) {
            return UnknownCqlDataType.INSTANCE;
        }
        if (grammarType.getNativeType() != null) {
            return NativeCqlDataType.getByCanonicalString(grammarType.getNativeType());
        }
        if (grammarType.getCollectionType() != null) {
            CollectionType ct = grammarType.getCollectionType();
            if (ct instanceof MapType) {
                MapType mt = (MapType)ct;
                return new MapCqlDataType(CqlDataTypeFactory.fromGrammarType(mt.getT1(), keyspace), CqlDataTypeFactory.fromGrammarType(mt.getT2(), keyspace));
            }
            if (ct instanceof ListType) {
                ListType lt = (ListType)ct;
                return new ListCqlDataType(CqlDataTypeFactory.fromGrammarType(lt.getT(), keyspace));
            }
            SetType st = (SetType)ct;
            return new SetCqlDataType(CqlDataTypeFactory.fromGrammarType(st.getT(), keyspace));
        }
        if (grammarType.getUserType() != null) {
            String userTypeName = ModelUtil.stripName(grammarType.getUserType().getName());
            UserType userType = null;
            if (keyspace != null) {
                userType = keyspace.getUserType(userTypeName);
            }
            if (userType == null) {
                return UnknownCqlDataType.INSTANCE;
            }
            return new UserDefinedTypeCqlDataType(userType);
        }
        if (grammarType.getTuple() != null) {
            ArrayList<CqlDataType> tupleTypes = new ArrayList<CqlDataType>();
            for (Type type : grammarType.getTuple().getTupleTypes()) {
                tupleTypes.add(CqlDataTypeFactory.fromGrammarType(type, keyspace));
            }
            return new TupleCqlDataType(tupleTypes);
        }
        if (grammarType.getFrozenType() != null) {
            CqlDataType cqlDataType = CqlDataTypeFactory.fromGrammarType(grammarType.getFrozenType(), keyspace);
            if (cqlDataType instanceof ComplexCqlDataType) {
                ((ComplexCqlDataType)cqlDataType).setFrozen(true);
            }
            return cqlDataType;
        }
        if (grammarType.getCustomType() != null) {
            return new CustomCqlDataType(grammarType.getCustomType());
        }
        return UnknownCqlDataType.INSTANCE;
    }

    public static CqlDataType fromTermType(Term term, Schema schema, Keyspace ks) {
        CqlDataType termAsType = UnknownCqlDataType.INSTANCE;
        if (term.getCastType() != null) {
            termAsType = CqlDataTypeFactory.fromGrammarType(term.getCastType(), ks);
        } else if (term.getValue() != null) {
            Value value = term.getValue();
            if (value.getCollection() != null) {
                termAsType = CqlDataTypeFactory.fromCollectionLiteralType(value.getCollection(), schema, ks);
            } else if (term.getValue().getConstant() != null) {
                termAsType = CqlDataTypeFactory.fromConstantValueType(value.getConstant());
            } else if (term.getValue().getTupleLiteral() != null) {
                termAsType = CqlDataTypeFactory.fromTupleTypeLiteral(value.getTupleLiteral(), schema, ks);
            } else if (term.getValue().getUserType() != null) {
                termAsType = CqlDataTypeFactory.fromUserTypeLiteral(value.getUserType(), schema, ks);
            }
        } else if (term.getFunctionName() != null) {
            List<Assignment> argTypes = CqlDataTypeFactory.fromFunctionArgumentTypes(term.getFunctionName(), term.getArgs(), schema);
            List<SchemaFunction> compatibleFunctions = FunctionUtil.findMatchingFunctions(term.getFunctionName(), argTypes, schema, false);
            if (compatibleFunctions.size() == 1) {
                termAsType = compatibleFunctions.get(0).getReturnType();
            }
        }
        if (termAsType != null && termAsType instanceof ComplexCqlDataType) {
            ((ComplexCqlDataType)termAsType).setFrozen(false);
        }
        return termAsType;
    }

    public static List<Assignment> fromFunctionArgumentTypes(Function function, FunctionArgs args, Schema schema) {
        LinkedList<Assignment> argumentTypes = new LinkedList<Assignment>();
        if (args != null && args.getArgs() != null) {
            for (Term term : args.getArgs()) {
                argumentTypes.add(Assignment.create(null, term));
            }
        }
        return argumentTypes;
    }

    public static CqlDataType fromUserTypeLiteral(UserTypeLiteral userType, Schema schema, Keyspace ks) {
        StringBuilder builder = new StringBuilder("usertype{ ");
        LinkedList<UserTypeField> fields = new LinkedList<UserTypeField>();
        Iterator it = userType.getEntries().iterator();
        while (it.hasNext()) {
            UserTypeEntry entry = (UserTypeEntry)it.next();
            FieldEntity fe = entry.getUserTypeField();
            CqlDataType type = CqlDataTypeFactory.fromTermType(entry.getValue(), schema, ks);
            fields.add(new UserTypeField(ModelUtil.escapeName(fe.getName()), type));
            builder.append(fe.getName());
            builder.append(" : ");
            builder.append(type);
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" }");
        UserType ut = new UserType(builder.toString());
        return new UserDefinedTypeCqlDataType(ut);
    }

    public static CqlDataType fromCollectionLiteralType(CollectionLiteral collection, Schema schema, Keyspace ks) {
        if (collection instanceof MapLiteral) {
            EList<MapEntry> entries = ((MapLiteral)collection).getEntries();
            CqlDataType keyType = UnknownCqlDataType.INSTANCE;
            CqlDataType valueType = UnknownCqlDataType.INSTANCE;
            for (MapEntry entry : entries) {
                CqlDataType nextKeyType = CqlDataTypeFactory.fromTermType(entry.getKey(), schema, ks);
                if (keyType != UnknownCqlDataType.INSTANCE && !((CqlDataType)keyType).equals(nextKeyType)) {
                    keyType = UnknownCqlDataType.INSTANCE;
                    break;
                }
                keyType = nextKeyType;
            }
            for (MapEntry entry : entries) {
                CqlDataType nextValueType = CqlDataTypeFactory.fromTermType(entry.getValue(), schema, ks);
                if (valueType != UnknownCqlDataType.INSTANCE && !((CqlDataType)valueType).equals(nextValueType)) {
                    valueType = UnknownCqlDataType.INSTANCE;
                    break;
                }
                valueType = nextValueType;
            }
            return new MapCqlDataType(keyType, valueType);
        }
        if (collection instanceof ListLiteral) {
            ListLiteral literal = (ListLiteral)collection;
            ListCqlDataType listType = new ListCqlDataType(UnknownCqlDataType.INSTANCE);
            for (Term t : literal.getValues()) {
                CqlDataType elementType = CqlDataTypeFactory.fromTermType(t, schema, ks);
                if (elementType == null) continue;
                if (listType.getElementType() != UnknownCqlDataType.INSTANCE && !elementType.equals(listType.getElementType())) {
                    listType = new ListCqlDataType(UnknownCqlDataType.INSTANCE);
                    break;
                }
                listType = new ListCqlDataType(elementType);
            }
            return listType;
        }
        if (collection instanceof SetLiteral) {
            SetLiteral literal = (SetLiteral)collection;
            SetCqlDataType setType = new SetCqlDataType(UnknownCqlDataType.INSTANCE);
            for (Term t : literal.getValues()) {
                CqlDataType elementType = CqlDataTypeFactory.fromTermType(t, schema, ks);
                if (elementType == null) continue;
                if (setType.getElementType() != UnknownCqlDataType.INSTANCE && !elementType.equals(setType.getElementType())) {
                    setType = new SetCqlDataType(UnknownCqlDataType.INSTANCE);
                    break;
                }
                setType = new SetCqlDataType(elementType);
            }
            return setType;
        }
        return UnknownCqlDataType.INSTANCE;
    }

    public static TupleCqlDataType fromTupleTypeLiteral(TupleLiteral tuple, Schema schema, Keyspace ks) {
        LinkedList<CqlDataType> innerTypes = new LinkedList<CqlDataType>();
        for (Term tupleTerm : tuple.getValues()) {
            innerTypes.add(CqlDataTypeFactory.fromTermType(tupleTerm, schema, ks));
        }
        return new TupleCqlDataType(innerTypes);
    }

    public static CqlDataType fromConstantValueType(ConstantValue value) {
        ImmutableCqlDataType argumentType = UnknownCqlDataType.INSTANCE;
        if (value instanceof BooleanValue) {
            argumentType = NativeCqlDataType.BOOLEAN;
        } else if (value instanceof IntegerValue) {
            argumentType = NativeCqlDataType.INT;
        } else if (value instanceof StringValue) {
            argumentType = NativeCqlDataType.TEXT;
        } else if (value instanceof FloatValue) {
            argumentType = NativeCqlDataType.FLOAT;
        } else if (value instanceof HexValue) {
            argumentType = NativeCqlDataType.BLOB;
        } else if (value instanceof UUIDValue) {
            argumentType = NativeCqlDataType.UUID;
        } else if (value instanceof UnrepresentableNumericValue && FloatCqlDataType.INSTANCE.validate(value.getValue())) {
            argumentType = NativeCqlDataType.FLOAT;
        }
        return argumentType;
    }

    public static Class<? extends ConstantValue> fromCqlDataType(NativeCqlDataType value) {
        if (value instanceof BooleanCqlDataType) {
            return BooleanValue.class;
        }
        if (value instanceof IntCqlDataType) {
            return IntegerValue.class;
        }
        if (value instanceof TextCqlDataType) {
            return StringValue.class;
        }
        if (value instanceof FloatCqlDataType) {
            return FloatValue.class;
        }
        if (value instanceof BlobCqlDataType) {
            return HexValue.class;
        }
        if (value instanceof UuidCqlDataType) {
            return UUIDValue.class;
        }
        return null;
    }
}

